/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.types;

import org.ws4d.java.structures.HashMap;
import org.ws4d.java.structures.HashSet;
import org.ws4d.java.structures.Iterator;
import org.ws4d.java.structures.Set;
import org.ws4d.java.types.QName;
import org.ws4d.java.types.URI;
import org.ws4d.java.types.URISet;
import org.ws4d.java.util.StringUtil;

public class ScopeSet {
    protected Set strScopes = null;
    protected URISet uriScopes = null;
    protected HashMap unknownAttributes = null;

    public ScopeSet() {
        this((String[])null);
    }

    public ScopeSet(int n) {
        this.uriScopes = new URISet(n);
    }

    public ScopeSet(String[] stringArray) {
        this.addAll(stringArray);
    }

    public ScopeSet(ScopeSet scopeSet) {
        this.addAll(scopeSet);
    }

    public static ScopeSet construct(String string) {
        String[] stringArray = StringUtil.split(string, ' ');
        return new ScopeSet(stringArray);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ScopeSet ");
        stringBuffer.append("[ scopes=").append(this.strScopes);
        stringBuffer.append(", unknownAttributes=").append(this.unknownAttributes);
        stringBuffer.append(" ]");
        return stringBuffer.toString();
    }

    public synchronized URI getScope(int n) {
        if (this.strScopes == null) {
            return null;
        }
        URI uRI = null;
        int n2 = 0;
        if (this.uriScopes == null) {
            Iterator iterator = this.strScopes.iterator();
            while (iterator.hasNext()) {
                URI uRI2 = new URI((String)iterator.next());
                if (n2 == n) {
                    uRI = uRI2;
                }
                ++n2;
            }
        } else {
            Iterator iterator = this.uriScopes.iterator();
            while (iterator.hasNext()) {
                Object object = iterator.next();
                if (n2 == n) {
                    return (URI)object;
                }
                ++n2;
            }
        }
        return uRI;
    }

    public int size() {
        return this.strScopes == null ? 0 : this.strScopes.size();
    }

    public synchronized URISet getScopesAsUris() {
        if (this.strScopes == null || this.strScopes.isEmpty()) {
            return null;
        }
        if (this.uriScopes == null) {
            this.uriScopes = new URISet(this.strScopes.size());
            Iterator iterator = this.strScopes.iterator();
            while (iterator.hasNext()) {
                this.uriScopes.add(new URI((String)iterator.next()));
            }
        }
        return this.uriScopes;
    }

    public synchronized String[] getScopesAsStringArray() {
        String[] stringArray = new String[this.strScopes.size()];
        int n = 0;
        Iterator iterator = this.strScopes.iterator();
        while (iterator.hasNext()) {
            stringArray[n] = (String)iterator.next();
            ++n;
        }
        return stringArray;
    }

    public synchronized String getScopesAsString() {
        StringBuffer stringBuffer = new StringBuffer(this.strScopes.size() * 20);
        int n = 0;
        Iterator iterator = this.strScopes.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append((String)iterator.next());
            stringBuffer.append(' ');
            ++n;
        }
        return stringBuffer.toString().trim();
    }

    public boolean isEmpty() {
        return this.strScopes == null || this.strScopes.size() == 0;
    }

    public Object getUnknownAttribute(QName qName) {
        return this.unknownAttributes == null ? null : this.unknownAttributes.get(qName);
    }

    public HashMap getUnknownAttributes() {
        return this.unknownAttributes;
    }

    public synchronized void addScope(String string) {
        if (this.strScopes == null) {
            this.strScopes = new HashSet(3);
        }
        if (this.uriScopes != null) {
            this.uriScopes.add(new URI(string));
        }
        this.strScopes.add(string);
    }

    public synchronized void addScope(URI uRI) {
        if (this.strScopes == null) {
            this.strScopes = new HashSet(3);
        }
        if (this.uriScopes != null) {
            this.uriScopes.add(uRI);
        }
        this.strScopes.add(uRI.toString());
    }

    private void addAll(String[] stringArray) {
        if (stringArray != null) {
            if (this.strScopes == null) {
                this.strScopes = new HashSet(stringArray.length);
            }
            for (int i = 0; i < stringArray.length; ++i) {
                this.strScopes.add(stringArray[i]);
            }
        }
    }

    public synchronized void addAll(ScopeSet scopeSet) {
        block5: {
            if (scopeSet == null || scopeSet.isEmpty()) break block5;
            if (this.strScopes == null || this.strScopes.isEmpty()) {
                if (this.strScopes == null) {
                    this.strScopes = new HashSet(scopeSet.size());
                }
                Iterator iterator = scopeSet.strScopes.iterator();
                while (iterator.hasNext()) {
                    this.strScopes.add(iterator.next());
                }
            } else {
                Iterator iterator = scopeSet.strScopes.iterator();
                while (iterator.hasNext()) {
                    Object object = iterator.next();
                    if (this.strScopes.contains(object)) continue;
                    this.addScope((String)object);
                }
            }
        }
    }

    public void addUnknownAttribute(QName qName, Object object) {
        if (this.unknownAttributes == null) {
            this.unknownAttributes = new HashMap();
        }
        this.unknownAttributes.put(qName, object);
    }

    public synchronized boolean containsAll(ScopeSet scopeSet) {
        if (scopeSet == null) {
            return true;
        }
        if (scopeSet.isEmpty()) {
            return true;
        }
        if (this.strScopes != null) {
            if (scopeSet.strScopes == null) {
                return this.strScopes.size() == 0;
            }
            return this.strScopes.containsAll(scopeSet.strScopes);
        }
        return scopeSet.strScopes == null || scopeSet.strScopes.isEmpty();
    }

    public synchronized boolean contains(String string) {
        return this.strScopes != null ? this.strScopes.contains(string) : false;
    }

    public synchronized void setScopes(String[] stringArray) {
        this.strScopes = new HashSet(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            this.strScopes.add(stringArray[i]);
        }
        this.uriScopes = null;
    }
}

