/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.types;

import org.ws4d.java.structures.Iterator;
import org.ws4d.java.structures.LinkedList;
import org.ws4d.java.util.StringUtil;

public class URI {
    public static final String URN_SCHEMA_PREFIX = "urn";
    public static final URI EMPTY_URI = new URI("", "", "", "", "", 0);
    private static final String[][] AVAILABLE_PROTOCOLS = new String[][]{{"http", "80"}, {"https", "443"}, {"ftp", "21"}};
    private String schema = null;
    private String authority = null;
    private String path = null;
    private String query = null;
    private String fragment = null;
    private String schemaDecoded = null;
    private String pathDecoded = null;
    private String queryDecoded = null;
    private String fragmentDecoded = null;
    private String user = null;
    private String password = null;
    private String host = null;
    private int port = -1;
    private int hash = 0;
    private boolean notInitialized = true;
    private boolean valid = true;
    private boolean isIPv6 = false;
    private boolean relative = false;
    private int pathdeepness = -1;
    private int protocolNum = -1;
    private int defaultPort = -1;
    private static final char GD_COLON = ':';
    private static final char GD_SLASH = '/';
    private static final char GD_QMARK = '?';
    private static final char GD_HASH = '#';
    private static final char GD_SQ_BR_OPEN = '[';
    private static final char GD_SQ_BR_CLOSE = ']';
    private static final char GD_AT = '@';

    public URI(String string) {
        int n;
        int n2;
        int n3 = 0;
        int n4 = string.indexOf(63, n3);
        if (n4 != -1) {
            n2 = n4;
            n3 = n4 + 1;
            n = string.indexOf(35, n3 + 1);
            if (n != -1) {
                this.query = string.substring(n3, n);
                n3 = n + 1;
                this.fragment = string.length() > n3 ? string.substring(n3) : "";
            } else {
                this.query = string.substring(n3);
            }
        } else {
            n = string.indexOf(35, n3);
            if (n != -1) {
                n2 = n;
                n3 = n + 1;
                this.fragment = string.length() > n3 ? string.substring(n3) : "";
            } else {
                n2 = string.length();
            }
        }
        string = string.substring(0, n2);
        int n5 = string.indexOf(47);
        n = string.indexOf(58);
        if (n != -1 && (n5 == -1 || n < n5)) {
            this.schema = string.substring(0, n);
            n3 = n + 1;
        } else {
            this.relative = true;
            n3 = 0;
        }
        if (string.length() == n3) {
            return;
        }
        if (n5 == n3) {
            if (string.length() == n3 + 1) {
                this.path = String.valueOf('/');
                return;
            }
            if (string.charAt(n3 + 1) == '/') {
                n5 = string.indexOf(47, n3 + 2);
                if (n5 != -1) {
                    this.authority = string.substring(n3 + 2, n5);
                    this.path = string.substring(n5);
                } else {
                    this.authority = string.substring(n3 + 2);
                }
            } else {
                this.path = string.substring(n3);
            }
        } else if (string.length() > 0) {
            this.path = string.substring(n3);
        }
        if (this.path == null) {
            this.path = this.authority == null ? "" : String.valueOf('/');
        }
        if (!this.relative) {
            this.removeDotsFromPath();
        }
    }

    public URI(URI uRI, URI uRI2) {
        if (uRI.isRelativeReference()) {
            throw new RuntimeException("Error while merging: Base URI is a relative reference. " + uRI.toString());
        }
        boolean bl = false;
        if (uRI2.schema != null && !uRI2.schema.equals(uRI.schema)) {
            bl = true;
        }
        if (bl) {
            this.setValues(uRI2.schema, uRI2.authority, uRI2.path, uRI2.query, uRI2.fragment, -1);
        } else if (uRI2.authority != null) {
            this.setValues(uRI.schema, uRI2.authority, uRI2.path, uRI2.query, uRI2.fragment, -1);
        } else if (uRI2.path.length() > 0) {
            if (uRI2.path.charAt(0) == '/') {
                this.setValues(uRI.schema, uRI.authority, uRI2.path, uRI2.query, uRI2.fragment, -1);
            } else {
                String string = URI.mergePaths(uRI.path, uRI2.path);
                this.setValues(uRI.schema, uRI.authority, string, uRI2.query, uRI2.fragment, -1);
            }
        } else if (uRI2.query != null) {
            this.setValues(uRI.schema, uRI.authority, uRI.path, uRI2.query, uRI2.fragment, uRI.pathdeepness);
        } else {
            this.setValues(uRI.schema, uRI.authority, uRI.path, uRI.query, uRI2.fragment, uRI.pathdeepness);
        }
    }

    public URI(URI uRI, String string) {
        this(uRI, new URI(null, null, string, null, null, -1));
    }

    public URI(String string, URI uRI) {
        this(uRI, new URI(string));
    }

    public URI(String string, String string2) {
        this(new URI(string), string2);
    }

    protected URI(URI uRI) {
        this.schema = uRI.schema;
        this.authority = uRI.authority;
        this.path = uRI.path;
        this.query = uRI.query;
        this.fragment = uRI.fragment;
        this.host = uRI.host;
        this.port = uRI.port;
        this.user = uRI.user;
        this.password = uRI.password;
        this.hash = uRI.hash;
        this.pathdeepness = uRI.pathdeepness;
        this.protocolNum = uRI.protocolNum;
        this.defaultPort = uRI.defaultPort;
        this.relative = uRI.relative;
        this.valid = uRI.valid;
        this.notInitialized = uRI.notInitialized;
        this.isIPv6 = uRI.isIPv6;
    }

    private URI(String string, String string2, String string3, String string4, String string5, int n) {
        this.setValues(string, string2, string3, string4, string5, n);
    }

    private void initLazy() {
        if (this.authority != null) {
            int n;
            String string = null;
            String string2 = null;
            int n2 = this.authority.indexOf(64);
            if (n2 != -1) {
                string = this.authority.substring(0, n2);
                string2 = this.authority.substring(n2 + 1, this.authority.length());
                n = string.indexOf(58);
                if (n != -1) {
                    this.user = StringUtil.decodeURL(string.substring(0, n));
                    this.password = StringUtil.decodeURL(string.substring(n + 1, string.length()));
                } else {
                    this.user = StringUtil.decodeURL(string);
                }
            } else {
                string2 = this.authority;
            }
            n = string2.substring(0, string2.length()).lastIndexOf(91);
            int n3 = string2.substring(0, string2.length()).lastIndexOf(93);
            if (n == -1 != (n3 == -1) || n3 < n) {
                this.valid = false;
                this.notInitialized = false;
                return;
            }
            if (n != -1) {
                this.isIPv6 = true;
                int n4 = string2.indexOf(37, n + 3);
                this.host = n4 == -1 ? string2.substring(n, n3 + 1) : string2.substring(n, n4).toLowerCase() + string2.substring(n4, n3 + 1);
                if (string2.length() > n3 + 2 && string2.charAt(n3 + 1) == ':') {
                    try {
                        this.port = Integer.parseInt(StringUtil.decodeURL(string2.substring(n3 + 2)));
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.valid = false;
                        this.notInitialized = false;
                        return;
                    }
                } else if (string2.length() > n3 + 1) {
                    this.valid = false;
                    this.notInitialized = false;
                    return;
                }
            } else {
                int n5 = string2.indexOf(58);
                if (n5 != -1) {
                    this.host = StringUtil.decodeURL(string2.substring(0, n5)).toLowerCase();
                    if (string2.length() > n5 + 1) {
                        try {
                            this.port = Integer.parseInt(StringUtil.decodeURL(string2.substring(n5 + 1)));
                        }
                        catch (NumberFormatException numberFormatException) {
                            this.valid = false;
                            this.notInitialized = false;
                            return;
                        }
                    }
                } else {
                    this.host = StringUtil.decodeURL(string2).toLowerCase();
                }
            }
            if (this.schema != null) {
                this.initSchemaInternal(this.schema);
                if (this.port == -1) {
                    this.port = this.defaultPort;
                }
            }
            if (this.host != null && this.host.length() == 0) {
                this.valid = false;
                this.notInitialized = false;
                return;
            }
        }
        this.notInitialized = false;
    }

    private void setValues(String string, String string2, String string3, String string4, String string5, int n) {
        this.schema = string;
        this.authority = string2;
        this.path = string3 == null ? "" : string3;
        this.query = string4;
        this.fragment = string5;
        if (string == null) {
            this.relative = true;
        } else if (n != -1) {
            this.pathdeepness = n;
        } else {
            this.removeDotsFromPath();
        }
    }

    private void initSchemaInternal(String string) {
        for (int i = 0; i < AVAILABLE_PROTOCOLS.length; ++i) {
            if (AVAILABLE_PROTOCOLS[i][0] == null || !StringUtil.equalsIgnoreCase(AVAILABLE_PROTOCOLS[i][0], string)) continue;
            this.protocolNum = i;
            if (AVAILABLE_PROTOCOLS[i][1] != null) {
                this.defaultPort = Integer.parseInt(AVAILABLE_PROTOCOLS[i][1]);
            }
            return;
        }
    }

    private void removeDotsFromPath() {
        String string = this.path;
        LinkedList linkedList = new LinkedList();
        while (string.length() > 0) {
            int n = string.indexOf(46);
            int n2 = string.indexOf(47);
            if (n == 0) {
                if (n2 == -1) {
                    if (string.length() == 1 || string.length() == 2 && string.charAt(1) == '.') break;
                    linkedList.add(string);
                    break;
                }
                if (n2 == 1 || n2 == 2 && string.charAt(1) == '.') {
                    string = string.substring(n2);
                    continue;
                }
            } else if (n2 == 0 && n == 1) {
                if (string.length() == 2) {
                    linkedList.add("/");
                    break;
                }
                char c = string.charAt(2);
                if (c == '/') {
                    string = string.substring(2);
                    continue;
                }
                if (c == '.') {
                    if (string.length() == 3) {
                        if (linkedList.size() > 0) {
                            linkedList.removeLast();
                        }
                        linkedList.add("/");
                        break;
                    }
                    if (string.charAt(3) == '/') {
                        if (linkedList.size() > 0) {
                            linkedList.removeLast();
                        }
                        string = string.substring(3);
                        continue;
                    }
                }
            }
            if (n2 == -1) {
                linkedList.add(string);
                break;
            }
            if (n2 == 0 && (n2 = string.indexOf(47, 1)) == -1) {
                linkedList.add(string);
                break;
            }
            linkedList.add(string.substring(0, n2));
            string = string.substring(n2);
        }
        this.pathdeepness = linkedList.size();
        StringBuffer stringBuffer = new StringBuffer(string.length());
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append((String)iterator.next());
        }
        this.path = stringBuffer.toString();
    }

    private static String mergePaths(String string, String string2) {
        int n = string.lastIndexOf(47);
        if (n == -1) {
            return string2;
        }
        return string.substring(0, n + 1) + string2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(20);
        if (this.schema != null) {
            stringBuffer.append(this.schema);
            stringBuffer.append(':');
        }
        if (this.authority != null) {
            stringBuffer.append("//");
            stringBuffer.append(this.authority);
        }
        if (this.path != null) {
            stringBuffer.append(this.path);
        }
        if (this.query != null) {
            stringBuffer.append('?');
            stringBuffer.append(this.query);
        }
        if (this.fragment != null) {
            stringBuffer.append('#');
            stringBuffer.append(this.fragment);
        }
        return stringBuffer.toString();
    }

    public Object clone() {
        return new URI(this);
    }

    public int hashCode() {
        if (this.hash != 0) {
            return this.hash;
        }
        if (this.notInitialized) {
            this.initLazy();
        }
        int n = 1;
        n = 31 * n + (this.schema == null ? 0 : this.getSchema().hashCode());
        n = 31 * n + (this.user == null ? 0 : this.user.hashCode());
        n = 31 * n + (this.password == null ? 0 : this.password.hashCode());
        n = 31 * n + (this.host == null ? 0 : this.host.hashCode());
        n = 31 * n + this.port;
        n = 31 * n + (this.path == null ? 0 : this.getPath().hashCode());
        n = 31 * n + (this.fragment == null ? 0 : this.getFragment().hashCode());
        this.hash = n = 31 * n + (this.query == null ? 0 : this.getQuery().hashCode());
        return this.hash;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        URI uRI = (URI)object;
        if (this.notInitialized) {
            this.initLazy();
        }
        if (uRI.notInitialized) {
            uRI.initLazy();
        }
        if (this.schema == null ? uRI.schema != null : !this.getSchema().equals(uRI.getSchema())) {
            return false;
        }
        if (this.user == null ? uRI.user != null : !this.user.equals(uRI.user)) {
            return false;
        }
        if (this.password == null ? uRI.password != null : !this.password.equals(uRI.password)) {
            return false;
        }
        if (this.host == null ? uRI.host != null : !this.host.equals(uRI.host)) {
            return false;
        }
        if (this.port != uRI.port) {
            return false;
        }
        if (!this.getPath().equals(uRI.getPath())) {
            return false;
        }
        if (this.query == null ? uRI.query != null : !this.getQuery().equals(uRI.getQuery())) {
            return false;
        }
        return !(this.fragment == null ? uRI.fragment != null : !this.getFragment().equals(uRI.getFragment()));
    }

    public boolean equalsWsdRfc3986(URI uRI) {
        if (this == uRI) {
            return true;
        }
        if (uRI == null) {
            return false;
        }
        if (this.notInitialized) {
            this.initLazy();
        }
        if (uRI.notInitialized) {
            uRI.initLazy();
        }
        if (this.schema == null ? uRI.schema != null : !this.getSchema().equals(uRI.getSchema())) {
            return false;
        }
        if (this.user == null ? uRI.user != null : !StringUtil.equalsIgnoreCase(this.user, uRI.user)) {
            return false;
        }
        if (this.password == null ? uRI.password != null : !StringUtil.equalsIgnoreCase(this.password, uRI.password)) {
            return false;
        }
        if (this.host == null ? uRI.host != null : !this.host.equals(uRI.host)) {
            return false;
        }
        if (this.port != uRI.port) {
            return false;
        }
        String string = this.getPath();
        String string2 = uRI.getPath();
        int n = string.length();
        int n2 = string2.length();
        int n3 = Math.min(n, n2);
        for (int i = 0; i < n3; ++i) {
            char c = string.charAt(i);
            if (c != string2.charAt(i)) {
                return false;
            }
            if (c != '.' || !this.checkDotSegment(string, i)) continue;
            return false;
        }
        if (n < n2) {
            return this.checkTail(string2, n3);
        }
        if (n > n2) {
            return this.checkTail(string, n3);
        }
        return true;
    }

    private boolean checkTail(String string, int n) {
        if (string.charAt(n) != '/') {
            return false;
        }
        int n2 = string.length();
        ++n;
        while (n < n2) {
            if (this.checkDotSegment(string, n)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private boolean checkDotSegment(String string, int n) {
        if (n > 0 && string.charAt(n - 1) != '/') {
            return false;
        }
        int n2 = string.length();
        if (n2 > ++n) {
            char c = string.charAt(n);
            if (c == '/') {
                return true;
            }
            if (c == '.') {
                if (n2 > ++n) {
                    if (string.charAt(n) == '/') {
                        return true;
                    }
                } else {
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    public boolean isRelativeReference() {
        return this.relative;
    }

    public boolean isValid() {
        if (this.notInitialized) {
            this.initLazy();
        }
        return this.valid;
    }

    public boolean isURN() {
        return URN_SCHEMA_PREFIX.equals(this.schema);
    }

    public String getSchema() {
        if (this.schema != null && this.schemaDecoded == null) {
            this.schemaDecoded = StringUtil.decodeURL(this.schema).toLowerCase();
        }
        return this.schemaDecoded;
    }

    public String getUser() {
        if (this.notInitialized) {
            this.initLazy();
        }
        return this.user;
    }

    public String getPassword() {
        if (this.notInitialized) {
            this.initLazy();
        }
        return this.password;
    }

    public String getHost() {
        if (this.notInitialized) {
            this.initLazy();
        }
        return this.host;
    }

    public int getPort() {
        if (this.notInitialized) {
            this.initLazy();
        }
        return this.port;
    }

    public String getHostWithPort() {
        if (this.notInitialized) {
            this.initLazy();
        }
        if (this.isIPv6) {
            if (this.port != -1) {
                return '[' + this.host + ']' + ':' + this.port;
            }
            return '[' + this.host + ']';
        }
        if (this.port != -1) {
            return this.host + ':' + this.port;
        }
        return this.host;
    }

    public String getPath() {
        if (this.path != null && this.pathDecoded == null) {
            this.pathDecoded = StringUtil.decodeURL(this.path);
        }
        return this.pathDecoded;
    }

    public String getQuery() {
        if (this.query != null && this.queryDecoded == null) {
            this.queryDecoded = StringUtil.decodeURL(this.query);
        }
        return this.queryDecoded;
    }

    public void setQuery(String string) {
        this.queryDecoded = string;
        this.query = StringUtil.encodeURL(string);
        this.hash = 0;
    }

    public void setQueryEncoded(String string) {
        this.queryDecoded = null;
        this.query = string;
        this.hash = 0;
    }

    public String getFragment() {
        if (this.fragment != null && this.fragmentDecoded == null) {
            this.fragmentDecoded = StringUtil.decodeURL(this.fragment);
        }
        return this.fragmentDecoded;
    }

    public void setFragment(String string) {
        this.fragmentDecoded = string;
        this.fragment = StringUtil.encodeURL(string);
        this.hash = 0;
    }

    public void setFragmentEncoded(String string) {
        this.fragment = string;
        this.fragmentDecoded = null;
        this.hash = 0;
    }

    public int getPathDeepness() {
        return this.pathdeepness;
    }

    public String getPath(int n) {
        if (this.isRelativeReference()) {
            throw new RuntimeException("URI.getPath(URI, int) is not supported for relative URIs.");
        }
        if (this.path == null) {
            return "";
        }
        if (n > this.pathdeepness) {
            return this.getPath();
        }
        if (n < 1) {
            return String.valueOf('/');
        }
        String string = this.getPath();
        int n2 = string.length();
        if (n2 < 2) {
            return string;
        }
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            if ((n3 = string.indexOf(47, n3 + 1)) != -1) continue;
            return string;
        }
        return string.substring(0, n3);
    }

    public static URI absolutize(URI uRI, String string) {
        URI uRI2 = new URI(string);
        if (uRI2.isRelativeReference()) {
            uRI2 = new URI(string, uRI);
        }
        return uRI2;
    }

    public static final boolean isIPv6Address(String string) {
        int n = string.indexOf(58);
        return n > 0;
    }

    public boolean isIPv6Address() {
        if (this.notInitialized) {
            this.initLazy();
        }
        return this.isIPv6;
    }
}

