/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.util;

import org.ws4d.java.structures.ArrayList;
import org.ws4d.java.structures.HashSet;
import org.ws4d.java.structures.List;
import org.ws4d.java.structures.Set;

public class ObjectPool {
    private final InstanceCreator creator;
    private final List pooledObjects;
    private final Set acquiredObjects;
    private final int maxSize;

    public ObjectPool(InstanceCreator instanceCreator) {
        this(instanceCreator, 10);
    }

    public ObjectPool(InstanceCreator instanceCreator, int n) {
        this(instanceCreator, n, -1);
    }

    public ObjectPool(InstanceCreator instanceCreator, int n, int n2) {
        this.creator = instanceCreator;
        this.maxSize = n2;
        this.pooledObjects = new ArrayList(n + 5);
        this.acquiredObjects = new HashSet(n);
        for (int i = 0; i < n; ++i) {
            this.pooledObjects.add(instanceCreator.createInstance());
        }
    }

    public synchronized Object acquire() {
        Object object;
        if (this.pooledObjects.size() > 0) {
            object = this.pooledObjects.remove(0);
        } else if (this.maxSize == -1 || this.acquiredObjects.size() < this.maxSize) {
            object = this.creator.createInstance();
        } else {
            throw new RuntimeException("maximum pool size exceeded");
        }
        this.acquiredObjects.add(object);
        return object;
    }

    public synchronized void release(Object object) {
        if (!this.acquiredObjects.remove(object)) {
            return;
        }
        this.pooledObjects.add(object);
    }

    public static interface InstanceCreator {
        public Object createInstance();
    }
}

