/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.util;

import org.ws4d.java.DPWSFramework;
import org.ws4d.java.concurrency.LockSupport;
import org.ws4d.java.structures.ArrayList;
import org.ws4d.java.structures.Iterator;
import org.ws4d.java.structures.LinkedList;
import org.ws4d.java.structures.List;
import org.ws4d.java.structures.ListIterator;
import org.ws4d.java.util.TimedEntry;

public class WatchDog
implements Runnable {
    static final int ADDITIONAL_TIME_BEFORE_CALLBACK_REMOVAL = 50;
    protected final LinkedList listEntries = new LinkedList();
    private boolean running = false;
    protected LockSupport lock = new LockSupport();
    private static WatchDog watchdog = new WatchDog();

    private WatchDog() {
    }

    public static WatchDog getInstance() {
        return watchdog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(TimedEntry timedEntry, long l) {
        this.lock.exclusiveLock();
        try {
            if (timedEntry.registered) {
                this.update(timedEntry, l);
                return;
            }
            timedEntry.setTimer(l);
            if (this.listEntries.size() == 0) {
                this.listEntries.add(timedEntry);
            } else {
                boolean bl = false;
                ListIterator listIterator = this.listEntries.listIterator(this.listEntries.size());
                while (listIterator.hasPrevious()) {
                    TimedEntry timedEntry2 = (TimedEntry)listIterator.previous();
                    if (timedEntry2.compareTo(timedEntry) >= 0L) continue;
                    if (listIterator.hasNext()) {
                        listIterator.next();
                    }
                    listIterator.add(timedEntry);
                    bl = true;
                    break;
                }
                if (!bl) {
                    listIterator.add(timedEntry);
                }
            }
            timedEntry.registered = true;
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
        WatchDog watchDog = this;
        synchronized (watchDog) {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(TimedEntry timedEntry) {
        this.lock.sharedLock();
        try {
            timedEntry.disabled = true;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(TimedEntry timedEntry, long l) {
        ArrayList arrayList = new ArrayList(3);
        this.lock.exclusiveLock();
        try {
            if (!timedEntry.registered) {
                this.register(timedEntry, l);
                return;
            }
            timedEntry.setTimer(l);
            long l2 = System.currentTimeMillis();
            if (this.listEntries.size() > 1) {
                boolean bl = false;
                ListIterator listIterator = this.listEntries.listIterator();
                while (listIterator.hasNext()) {
                    TimedEntry timedEntry2 = (TimedEntry)listIterator.next();
                    if (timedEntry2.equals(timedEntry)) {
                        listIterator.remove();
                        timedEntry2.registered = false;
                        continue;
                    }
                    if (timedEntry2.timeToRemove <= l2) {
                        listIterator.remove();
                        if (!timedEntry2.disabled) {
                            ((List)arrayList).add(timedEntry2);
                        }
                        timedEntry2.registered = false;
                        timedEntry2.disabled = false;
                        continue;
                    }
                    if (timedEntry2.compareTo(timedEntry) > 0L && !bl) {
                        listIterator.previous();
                        listIterator.add(timedEntry);
                        bl = true;
                        if (timedEntry2.registered) continue;
                        break;
                    }
                    if (timedEntry2.registered) continue;
                    break;
                }
                if (!bl) {
                    listIterator.add(timedEntry);
                }
            }
            timedEntry.registered = true;
            timedEntry.disabled = false;
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
        this.callTimeouts(arrayList);
        WatchDog watchDog = this;
        synchronized (watchDog) {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.running = true;
        while (this.running) {
            try {
                Object object;
                this.lock.sharedLock();
                if (this.listEntries.size() == 0) {
                    object = this;
                    synchronized (object) {
                        this.lock.releaseSharedLock();
                        this.wait();
                        continue;
                    }
                }
                object = (TimedEntry)this.listEntries.getFirst();
                long l = ((TimedEntry)object).timeToRemove - System.currentTimeMillis();
                if (l > 0L) {
                    l += 50L;
                    WatchDog watchDog = this;
                    synchronized (watchDog) {
                        this.lock.releaseSharedLock();
                        this.wait(l);
                    }
                } else {
                    this.lock.releaseSharedLock();
                }
                this.checkEntries();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.running = false;
        WatchDog watchDog = this;
        synchronized (watchDog) {
            this.notifyAll();
        }
        this.clearEntries();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearEntries() {
        ArrayList arrayList = new ArrayList(this.listEntries.size());
        this.lock.exclusiveLock();
        try {
            Iterator iterator = this.listEntries.iterator();
            while (iterator.hasNext()) {
                TimedEntry timedEntry = (TimedEntry)iterator.next();
                iterator.remove();
                timedEntry.registered = false;
                timedEntry.disabled = false;
                ((List)arrayList).add(timedEntry);
            }
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
        this.callTimeouts(arrayList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkEntries() {
        long l = System.currentTimeMillis();
        ArrayList arrayList = new ArrayList(5);
        this.lock.exclusiveLock();
        try {
            Iterator iterator = this.listEntries.iterator();
            while (iterator.hasNext()) {
                TimedEntry timedEntry = (TimedEntry)iterator.next();
                if (timedEntry.timeToRemove <= l) {
                    iterator.remove();
                    if (!timedEntry.disabled) {
                        ((List)arrayList).add(timedEntry);
                    }
                    timedEntry.registered = false;
                    timedEntry.disabled = false;
                    continue;
                }
                break;
            }
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
        this.callTimeouts(arrayList);
    }

    private void callTimeouts(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            final TimedEntry timedEntry = (TimedEntry)iterator.next();
            DPWSFramework.getThreadPool().execute(new Runnable(){

                public void run() {
                    timedEntry.timedOut();
                }
            });
        }
    }
}

