/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.wsdl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import org.ws4d.java.DPWSFramework;
import org.ws4d.java.communication.ProtocolData;
import org.ws4d.java.communication.RequestHeader;
import org.ws4d.java.communication.Resource;
import org.ws4d.java.communication.monitor.MonitorStreamFactory;
import org.ws4d.java.communication.monitor.MonitoringContext;
import org.ws4d.java.communication.monitor.ResourceLoader;
import org.ws4d.java.schema.Element;
import org.ws4d.java.schema.Schema;
import org.ws4d.java.schema.SchemaUtil;
import org.ws4d.java.schema.Type;
import org.ws4d.java.structures.ArrayList;
import org.ws4d.java.structures.DataStructure;
import org.ws4d.java.structures.EmptyStructures;
import org.ws4d.java.structures.HashMap;
import org.ws4d.java.structures.Iterator;
import org.ws4d.java.structures.LinkedMap;
import org.ws4d.java.structures.List;
import org.ws4d.java.structures.ReadOnlyIterator;
import org.ws4d.java.types.Attributable;
import org.ws4d.java.types.CustomAttributeParser;
import org.ws4d.java.types.CustomAttributeValue;
import org.ws4d.java.types.InternetMediaType;
import org.ws4d.java.types.QName;
import org.ws4d.java.types.StringAttributeParser;
import org.ws4d.java.types.URI;
import org.ws4d.java.util.StringUtil;
import org.ws4d.java.wsdl.IOType;
import org.ws4d.java.wsdl.UnsupportedBindingException;
import org.ws4d.java.wsdl.WSDLBinding;
import org.ws4d.java.wsdl.WSDLMessage;
import org.ws4d.java.wsdl.WSDLOperation;
import org.ws4d.java.wsdl.WSDLPort;
import org.ws4d.java.wsdl.WSDLPortType;
import org.ws4d.java.wsdl.WSDLService;
import org.ws4d.java.wsdl.WSDLSupportFactory;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class WSDL
implements Resource {
    private static final HashMap DEFAULT_NAMESPACES = new LinkedMap();
    private static HashMap customAttributeParsers;
    private HashMap defaultNamespaces;
    private String name;
    private String targetNamespace;
    private HashMap imports;
    private HashMap types;
    private HashMap messages;
    private HashMap portTypes;
    private HashMap bindings;
    private HashMap services;
    private HashMap linkedWsdls;
    private long lastMod = 0L;

    public static void registerAttributeParserForNamespace(String string, CustomAttributeParser customAttributeParser) {
        if (customAttributeParsers == null) {
            customAttributeParsers = new HashMap();
        }
        customAttributeParsers.put(string, customAttributeParser);
    }

    public static CustomAttributeParser getAttributeParserForNamespace(String string) {
        if (customAttributeParsers == null) {
            return StringAttributeParser.INSTANCE;
        }
        CustomAttributeParser customAttributeParser = (CustomAttributeParser)customAttributeParsers.get(string);
        return customAttributeParser == null ? StringAttributeParser.INSTANCE : customAttributeParser;
    }

    public static WSDL parse(URI uRI) throws XmlPullParserException, IOException {
        return WSDL.parse(uRI, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WSDL parse(URI uRI, boolean bl) throws XmlPullParserException, IOException {
        ResourceLoader resourceLoader = DPWSFramework.getResourceAsStream(uRI);
        InputStream inputStream = resourceLoader.getInputStream();
        try {
            Object object;
            WSDL wSDL = WSDL.parse(inputStream, uRI, bl);
            MonitorStreamFactory monitorStreamFactory = DPWSFramework.getMonitorStreamFactory();
            if (monitorStreamFactory != null) {
                object = resourceLoader.getProtocolData();
                MonitoringContext monitoringContext = monitorStreamFactory.getMonitoringContextIn((ProtocolData)object);
                monitorStreamFactory.receivedResource((ProtocolData)object, monitoringContext, wSDL);
            }
            object = wSDL;
            return object;
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    public static WSDL parse(InputStream inputStream) throws XmlPullParserException, IOException {
        return WSDL.parse(inputStream, true);
    }

    public static WSDL parse(InputStream inputStream, boolean bl) throws XmlPullParserException, IOException {
        return WSDL.parse(inputStream, null, bl);
    }

    public static WSDL parse(InputStream inputStream, URI uRI, boolean bl) throws XmlPullParserException, IOException {
        return WSDLSupportFactory.getInstance().newParser().parse(inputStream, uRI, null, bl);
    }

    public static WSDL parse(XmlPullParser xmlPullParser) throws XmlPullParserException, IOException {
        return WSDL.parse(xmlPullParser, true);
    }

    public static WSDL parse(XmlPullParser xmlPullParser, boolean bl) throws XmlPullParserException, IOException {
        return WSDLSupportFactory.getInstance().newParser().parse(xmlPullParser, null, null, bl);
    }

    public WSDL() {
        this("", "");
    }

    public WSDL(String string) {
        this(string, "");
    }

    public WSDL(String string, String string2) {
        this.targetNamespace = string == null ? "" : string;
        this.name = string2;
        this.updateLastModified();
    }

    protected synchronized void updateLastModified() {
        Date date = new Date();
        this.lastMod = date.getTime();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[ name=").append(this.name);
        stringBuffer.append(", targetNamespace=").append(this.targetNamespace);
        stringBuffer.append(", types=").append(this.types);
        stringBuffer.append(", messages=").append(this.messages);
        stringBuffer.append(", portTypes=").append(this.portTypes);
        stringBuffer.append(", bindins=").append(this.bindings);
        stringBuffer.append(", services=").append(this.services);
        stringBuffer.append(" ]");
        return stringBuffer.toString();
    }

    public void serialize(URI uRI, RequestHeader requestHeader, InputStream inputStream, OutputStream outputStream) throws IOException {
        this.serialize(outputStream);
    }

    public InternetMediaType getContentType() {
        return InternetMediaType.getXML();
    }

    public HashMap getHeaderFields() {
        HashMap hashMap = new HashMap();
        hashMap.put("Last-Modified", StringUtil.getHTTPDate(this.lastMod));
        return hashMap;
    }

    public long size() {
        return -1L;
    }

    public DataStructure getSupportedOperations() {
        if (this.services != null && this.services.size() > 0) {
            ArrayList arrayList = new ArrayList();
            Iterator iterator = this.services.values().iterator();
            while (iterator.hasNext()) {
                WSDLService wSDLService = (WSDLService)iterator.next();
                arrayList.addAll(wSDLService.getOperations());
            }
            return arrayList;
        }
        if (this.bindings == null) {
            return EmptyStructures.EMPTY_STRUCTURE;
        }
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.bindings.values().iterator();
        while (iterator.hasNext()) {
            WSDLBinding wSDLBinding = (WSDLBinding)iterator.next();
            arrayList.addAll(wSDLBinding.getOperations());
        }
        return arrayList;
    }

    public DataStructure getSupportedPortTypes() {
        if (this.services != null && this.services.size() > 0) {
            ArrayList arrayList = new ArrayList();
            Iterator iterator = this.services.values().iterator();
            while (iterator.hasNext()) {
                WSDLService wSDLService = (WSDLService)iterator.next();
                arrayList.addAll(wSDLService.getPortTypes());
            }
            return arrayList;
        }
        if (this.bindings == null) {
            return EmptyStructures.EMPTY_STRUCTURE;
        }
        ArrayList arrayList = new ArrayList(this.bindings.size());
        Iterator iterator = this.bindings.values().iterator();
        while (iterator.hasNext()) {
            WSDLBinding wSDLBinding = (WSDLBinding)iterator.next();
            WSDLPortType wSDLPortType = wSDLBinding.getPortType();
            if (wSDLPortType == null) continue;
            ((List)arrayList).add(wSDLPortType);
        }
        return arrayList;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.updateLastModified();
        this.name = string;
    }

    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    public void setTargetNamespace(String string) {
        this.updateLastModified();
        this.targetNamespace = string;
    }

    public HashMap getImports() {
        if (this.imports == null || this.imports.isEmpty()) {
            return EmptyStructures.EMPTY_MAP;
        }
        return new LinkedMap(this.imports);
    }

    public WSDLPortType getPortType(String string) {
        return this.portTypes == null ? null : (WSDLPortType)this.portTypes.get(string);
    }

    public WSDLPortType getPortType(QName qName) {
        Object object;
        String string;
        String string2 = string = qName == null ? null : qName.getNamespace();
        if (this.targetNamespace.equals(string)) {
            if (this.portTypes == null) {
                return null;
            }
            return (WSDLPortType)this.portTypes.get(qName.getLocalPart());
        }
        if ((string == null || "".equals(string)) && (object = (WSDLPortType)this.portTypes.get(qName.getLocalPart())) != null) {
            return object;
        }
        if (this.linkedWsdls == null) {
            return null;
        }
        object = (WSDL)this.linkedWsdls.get(string);
        if (object != null) {
            return ((WSDL)object).getPortType(qName.getLocalPart());
        }
        Iterator iterator = this.linkedWsdls.values().iterator();
        while (iterator.hasNext()) {
            object = (WSDL)iterator.next();
            WSDLPortType wSDLPortType = ((WSDL)object).getPortType(qName);
            if (wSDLPortType == null) continue;
            return wSDLPortType;
        }
        return null;
    }

    public Iterator getPortTypes() {
        return this.portTypes == null ? EmptyStructures.EMPTY_ITERATOR : new ReadOnlyIterator(this.portTypes.values());
    }

    public WSDLMessage getMessage(String string) {
        return this.messages == null ? null : (WSDLMessage)this.messages.get(string);
    }

    public WSDLMessage getMessage(QName qName) {
        String string;
        String string2 = string = qName == null ? null : qName.getNamespace();
        if (this.targetNamespace.equals(string)) {
            if (this.messages == null) {
                return null;
            }
            return (WSDLMessage)this.messages.get(qName.getLocalPart());
        }
        if (this.linkedWsdls == null) {
            return null;
        }
        WSDL wSDL = (WSDL)this.linkedWsdls.get(string);
        if (wSDL != null) {
            return wSDL.getMessage(qName.getLocalPart());
        }
        Iterator iterator = this.linkedWsdls.values().iterator();
        while (iterator.hasNext()) {
            wSDL = (WSDL)iterator.next();
            WSDLMessage wSDLMessage = wSDL.getMessage(qName);
            if (wSDLMessage == null) continue;
            return wSDLMessage;
        }
        return null;
    }

    public Iterator getMessages() {
        return this.messages == null ? EmptyStructures.EMPTY_ITERATOR : new ReadOnlyIterator(this.messages.values());
    }

    public WSDLBinding getBinding(String string) {
        return this.bindings == null ? null : (WSDLBinding)this.bindings.get(string);
    }

    public WSDLBinding getBinding(QName qName) {
        String string;
        String string2 = string = qName == null ? null : qName.getNamespace();
        if (this.targetNamespace.equals(string)) {
            if (this.bindings == null) {
                return null;
            }
            return (WSDLBinding)this.bindings.get(qName.getLocalPart());
        }
        if (this.linkedWsdls == null) {
            return null;
        }
        WSDL wSDL = (WSDL)this.linkedWsdls.get(string);
        if (wSDL != null) {
            return wSDL.getBinding(qName.getLocalPart());
        }
        Iterator iterator = this.linkedWsdls.values().iterator();
        while (iterator.hasNext()) {
            wSDL = (WSDL)iterator.next();
            WSDLBinding wSDLBinding = wSDL.getBinding(qName);
            if (wSDLBinding == null) continue;
            return wSDLBinding;
        }
        return null;
    }

    public Iterator getBindings() {
        return this.bindings == null ? EmptyStructures.EMPTY_ITERATOR : new ReadOnlyIterator(this.bindings.values());
    }

    public Iterator getBindings(QName qName) {
        if (qName == null || this.bindings == null) {
            return EmptyStructures.EMPTY_ITERATOR;
        }
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.bindings.values().iterator();
        while (iterator.hasNext()) {
            WSDLBinding wSDLBinding = (WSDLBinding)iterator.next();
            if (!qName.equals(wSDLBinding.getTypeName())) continue;
            ((List)arrayList).add(wSDLBinding);
        }
        return new ReadOnlyIterator(arrayList);
    }

    public WSDLService getService(String string) {
        return this.services == null ? null : (WSDLService)this.services.get(string);
    }

    public WSDLService getService(QName qName) {
        String string;
        String string2 = string = qName == null ? null : qName.getNamespace();
        if (this.targetNamespace.equals(string)) {
            if (this.services == null) {
                return null;
            }
            return (WSDLService)this.services.get(qName.getLocalPart());
        }
        if (this.linkedWsdls == null) {
            return null;
        }
        WSDL wSDL = (WSDL)this.linkedWsdls.get(string);
        if (wSDL != null) {
            return wSDL.getService(qName.getLocalPart());
        }
        Iterator iterator = this.linkedWsdls.values().iterator();
        while (iterator.hasNext()) {
            wSDL = (WSDL)iterator.next();
            WSDLService wSDLService = wSDL.getService(qName);
            if (wSDLService == null) continue;
            return wSDLService;
        }
        return null;
    }

    public Iterator getServices() {
        return this.services == null ? EmptyStructures.EMPTY_ITERATOR : new ReadOnlyIterator(this.services.values());
    }

    public Schema getTypes(String string) {
        return this.types == null ? null : (Schema)this.types.get(string);
    }

    public Iterator getTypes() {
        return this.types == null ? EmptyStructures.EMPTY_ITERATOR : new ReadOnlyIterator(this.types.values());
    }

    public Type getSchemaType(String string) {
        return this.getSchemaType(new QName(string, this.getTargetNamespace()));
    }

    public Type getSchemaType(QName qName) {
        Object object;
        if (qName == null || this.types == null) {
            return null;
        }
        Schema schema = (Schema)this.types.get(qName.getNamespace());
        if (schema != null) {
            return schema.getType(qName);
        }
        Iterator iterator = this.types.values().iterator();
        while (iterator.hasNext()) {
            schema = (Schema)iterator.next();
            object = schema.getType(qName);
            if (object == null) continue;
            return object;
        }
        if (this.linkedWsdls != null) {
            iterator = this.linkedWsdls.values().iterator();
            while (iterator.hasNext()) {
                object = (WSDL)iterator.next();
                Type type = ((WSDL)object).getSchemaType(qName);
                if (type == null) continue;
                return type;
            }
        }
        return SchemaUtil.getType(qName);
    }

    public Element getSchemaElement(String string) {
        return this.getSchemaElement(new QName(string, this.getTargetNamespace()));
    }

    public Element getSchemaElement(QName qName) {
        Object object;
        if (qName == null || this.types == null) {
            return null;
        }
        Schema schema = (Schema)this.types.get(qName.getNamespace());
        if (schema != null) {
            return schema.getElement(qName);
        }
        Iterator iterator = this.types.values().iterator();
        while (iterator.hasNext()) {
            schema = (Schema)iterator.next();
            object = schema.getElement(qName);
            if (object == null) continue;
            return object;
        }
        if (this.linkedWsdls != null) {
            iterator = this.linkedWsdls.values().iterator();
            while (iterator.hasNext()) {
                object = (WSDL)iterator.next();
                Element element = ((WSDL)object).getSchemaElement(qName);
                if (element == null) continue;
                return element;
            }
        }
        return null;
    }

    public void addImport(String string, String string2) {
        this.updateLastModified();
        if (this.imports == null) {
            this.imports = new LinkedMap();
        }
        this.imports.put(string, string2);
    }

    public WSDL getLinkedWsdlRecursive(String string) {
        if (this.linkedWsdls == null) {
            return null;
        }
        WSDL wSDL = (WSDL)this.linkedWsdls.get(string);
        if (wSDL != null) {
            return wSDL;
        }
        Iterator iterator = this.linkedWsdls.values().iterator();
        while (iterator.hasNext()) {
            wSDL = (WSDL)iterator.next();
            if ((wSDL = wSDL.getLinkedWsdlRecursive(string)) == null) continue;
            return wSDL;
        }
        return null;
    }

    public WSDL getLinkedWsdl(String string) {
        return this.linkedWsdls == null ? null : (WSDL)this.linkedWsdls.get(string);
    }

    public Iterator getLinkedWsdls() {
        return this.linkedWsdls == null ? EmptyStructures.EMPTY_ITERATOR : new ReadOnlyIterator(this.linkedWsdls.values());
    }

    public void addLinkedWsdl(WSDL wSDL) {
        if (wSDL == null) {
            return;
        }
        this.updateLastModified();
        if (this.linkedWsdls == null) {
            this.linkedWsdls = new LinkedMap();
        }
        this.linkedWsdls.put(wSDL.getTargetNamespace(), wSDL);
    }

    public void addTypes(Schema schema) {
        if (schema == null) {
            return;
        }
        this.updateLastModified();
        if (this.types == null) {
            this.types = new LinkedMap();
        }
        this.types.put(schema.getTargetNamespace(), schema);
    }

    public void addMessage(WSDLMessage wSDLMessage) {
        if (wSDLMessage == null) {
            return;
        }
        this.updateLastModified();
        if (this.messages == null) {
            this.messages = new LinkedMap();
        }
        this.messages.put(wSDLMessage.getLocalName(), wSDLMessage);
        wSDLMessage.setWsdl(this);
    }

    public void addPortType(WSDLPortType wSDLPortType) {
        if (wSDLPortType == null) {
            return;
        }
        this.updateLastModified();
        if (this.portTypes == null) {
            this.portTypes = new LinkedMap();
        }
        this.portTypes.put(wSDLPortType.getLocalName(), wSDLPortType);
        wSDLPortType.setWsdl(this);
        this.declareCustomAttributeNamespaces(wSDLPortType);
        Iterator iterator = wSDLPortType.getOperations().iterator();
        while (iterator.hasNext()) {
            WSDLOperation wSDLOperation = (WSDLOperation)iterator.next();
            this.declareCustomAttributeNamespaces(wSDLOperation);
            this.declareCustomAttributeNamespaces(wSDLOperation.getInput());
            this.declareCustomAttributeNamespaces(wSDLOperation.getOutput());
            Iterator iterator2 = wSDLOperation.getFaults().iterator();
            while (iterator2.hasNext()) {
                this.declareCustomAttributeNamespaces((IOType)iterator2.next());
            }
        }
    }

    public void addBinding(WSDLBinding wSDLBinding) {
        if (wSDLBinding == null) {
            return;
        }
        this.updateLastModified();
        if (this.bindings == null) {
            this.bindings = new LinkedMap();
        }
        this.bindings.put(wSDLBinding.getLocalName(), wSDLBinding);
        wSDLBinding.setWsdl(this);
    }

    public void addService(WSDLService wSDLService) throws UnsupportedBindingException {
        if (wSDLService == null) {
            return;
        }
        this.updateLastModified();
        DataStructure dataStructure = wSDLService.getPorts();
        Iterator iterator = dataStructure.iterator();
        while (iterator.hasNext()) {
            WSDLPort wSDLPort = (WSDLPort)iterator.next();
            WSDLBinding wSDLBinding = this.getBinding(wSDLPort.getBindingName());
            if (wSDLBinding != null) continue;
            throw new UnsupportedBindingException("no binding specified for port " + wSDLPort.getName() + " of service " + wSDLService.getName());
        }
        if (this.services == null) {
            this.services = new LinkedMap();
        }
        this.services.put(wSDLService.getLocalName(), wSDLService);
        wSDLService.setWsdl(this);
    }

    public void serialize(OutputStream outputStream) throws IOException {
        WSDLSupportFactory.getInstance().newSerializer().serialize(this, outputStream);
    }

    public HashMap getDefaultNamespaces() {
        if (this.defaultNamespaces == null) {
            this.defaultNamespaces = new LinkedMap(DEFAULT_NAMESPACES);
        } else if (this.defaultNamespaces.isEmpty()) {
            this.defaultNamespaces.putAll(DEFAULT_NAMESPACES);
        }
        return new LinkedMap(this.defaultNamespaces);
    }

    public void storeDefaultNamespaces(XmlPullParser xmlPullParser) throws XmlPullParserException {
        int n = xmlPullParser.getNamespaceCount(xmlPullParser.getDepth());
        if (n == 0) {
            return;
        }
        this.updateLastModified();
        if (this.defaultNamespaces == null) {
            this.defaultNamespaces = new LinkedMap();
        }
        for (int i = 0; i < n; ++i) {
            String string = xmlPullParser.getNamespacePrefix(i);
            String string2 = xmlPullParser.getNamespaceUri(i);
            if (this.defaultNamespaces.containsKey(string2)) continue;
            this.defaultNamespaces.put(string2, string);
        }
    }

    public void storeDefaultNamespace(String string, String string2) {
        if (string2 == null || "".equals(string2)) {
            return;
        }
        this.updateLastModified();
        if (this.defaultNamespaces == null) {
            this.defaultNamespaces = new LinkedMap();
        }
        if (!this.defaultNamespaces.containsKey(string2)) {
            this.defaultNamespaces.put(string2, string);
        }
    }

    void declareCustomAttributeNamespaces(Attributable attributable) {
        if (attributable == null) {
            return;
        }
        HashMap hashMap = attributable.getAttributes();
        if (hashMap == null) {
            return;
        }
        this.updateLastModified();
        Iterator iterator = hashMap.entrySet().iterator();
        while (iterator.hasNext()) {
            HashMap.Entry entry = (HashMap.Entry)iterator.next();
            QName qName = (QName)entry.getKey();
            CustomAttributeValue customAttributeValue = (CustomAttributeValue)entry.getValue();
            this.declareCustomAttributeNamespaces(qName, customAttributeValue);
        }
    }

    void declareCustomAttributeNamespaces(QName qName, CustomAttributeValue customAttributeValue) {
        this.storeDefaultNamespace(qName.getPrefix(), qName.getNamespace());
        if (customAttributeValue == null) {
            return;
        }
        HashMap hashMap = customAttributeValue.getNamespaces();
        if (hashMap == null) {
            return;
        }
        this.updateLastModified();
        Iterator iterator = hashMap.entrySet().iterator();
        while (iterator.hasNext()) {
            HashMap.Entry entry = (HashMap.Entry)iterator.next();
            this.storeDefaultNamespace((String)entry.getValue(), (String)entry.getKey());
        }
    }

    public String shortDescription() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("WSDL [ ").append(this.targetNamespace).append(" ]");
        return stringBuffer.toString();
    }

    public long getLastModifiedDate() {
        return this.lastMod;
    }

    static {
        DEFAULT_NAMESPACES.put("http://schemas.xmlsoap.org/wsdl/", "wsdl");
        DEFAULT_NAMESPACES.put("http://www.w3.org/2003/05/soap-envelope", "s12");
        DEFAULT_NAMESPACES.put("http://www.w3.org/2001/XMLSchema", "xs");
        DEFAULT_NAMESPACES.put("http://www.w3.org/2005/08/addressing", "wsa");
        customAttributeParsers = null;
    }
}

