/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.wsdl;

import org.ws4d.java.configuration.FrameworkProperties;
import org.ws4d.java.util.Log;
import org.ws4d.java.wsdl.DefaultWSDLParser;
import org.ws4d.java.wsdl.DefaultWSDLSerializer;
import org.ws4d.java.wsdl.WSDLParser;
import org.ws4d.java.wsdl.WSDLSerializer;

public class WSDLSupportFactory {
    private static final WSDLSupportFactory INSTANCE;

    public static WSDLSupportFactory getInstance() {
        return INSTANCE;
    }

    public WSDLParser newParser() {
        return new DefaultWSDLParser();
    }

    public WSDLSerializer newSerializer() {
        return new DefaultWSDLSerializer();
    }

    static {
        WSDLSupportFactory wSDLSupportFactory = null;
        String string = FrameworkProperties.getInstance().getWsdlSupportFactoryClass();
        if (string == null) {
            wSDLSupportFactory = new WSDLSupportFactory();
        } else {
            try {
                Class<?> clazz = Class.forName(string);
                wSDLSupportFactory = (WSDLSupportFactory)clazz.newInstance();
                if (Log.isDebug()) {
                    Log.debug("Using WSDLSupportFactory [" + string + "]", 4);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                Log.error("Configured WSDLSupportFactory class [" + string + "] not found, falling back to default implementation");
                wSDLSupportFactory = new WSDLSupportFactory();
            }
            catch (Exception exception) {
                Log.error("Unable to create instance of configured WSDLSupportFactory class [" + string + "], falling back to default implementation");
                Log.printStackTrace(exception);
                wSDLSupportFactory = new WSDLSupportFactory();
            }
        }
        INSTANCE = wSDLSupportFactory;
    }
}

