package edu.uga.cs.lsdis.sawsdl;

import java.util.Set;

/**
 * This interface marks a WSDL type being allowed to have a
 * <code>edu.uga.cs.lsdis.sawsdl.ModelReference</code> for SAWSDL.
 * 

 *  @author : Ajith Ranabahu
 * @author : Zixin Wu
 * @author : Karthik Gomadam
 * @author : Doug Brewer
 */
public interface ModelReferenceExtensible {

	/**
	 * Add a single ModelReference to the Element.
	 * 
	 * @param modelReference The ModelReference.
	 */
	public void addModelReference(ModelReference modelReference);
	
	/**
	 * Get the first ModelReference in the list of ModelReferences.
	 * 
	 * @return The first ModelReference. Null if there are model references
	 */
	public ModelReference getModelReference();
	
	/**
	 * Get all the ModelReferences of the Element.
	 * 
	 * @return A list of ModelReferences. If there are no model references
     * returns an empty list
	 */
	public Set<ModelReference> getModelReferences();
	
	/**
	 * Set the ModelReferences of this Element.
	 * 
	 * @param refs The ModelReferences for this Element.
	 */
	public void setModelReferences(Set<ModelReference> refs);
}
