package edu.uga.cs.lsdis.sawsdl;

import java.util.List;

/**
 * Represents the SAWSDL message part. According to the specification the
 * message parts may have the lifting and lowering schema mappings
 * @author : Ajith Ranabahu
 * @author : Zixin Wu
 * @author : Karthik Gomadam
 * @author : Doug Brewer
 *
 */
public interface Part extends javax.wsdl.Part, ModelReferenceExtensible {

    /**
     * Set the lifting schema mappings
     * @param mappings List of mappings
     */
    public void setLiftingSchemaMappings(List<String> mappings);

    /**
     * get the lifting schema mappings
     * @return list of URI's
     */
    public List<String> getLiftingSchemaMappings();

    /**
     * Set the lowein schema mappings
     * @param mappings List of mappings
     */
    public void setLoweringSchemaMappings(List<String> mappings);

    /**
     * get the lowering schema mappings
     * @return list of URI's
     */
    public List<String> getLoweringSchemaMappings();



}
