package edu.uga.cs.lsdis.sawsdl;

/**
 * Represents the SAWSDL porttype
 * @author : Ajith Ranabahu
 * @author : Zixin Wu
 * @author : Karthik Gomadam
 * @author : Doug Brewer
 *
 */
public interface PortType extends javax.wsdl.PortType,ModelReferenceExtensible {
     //Some of the necessary extra methods for the porttype are added  by the ModelReferenceExtensible interface

    /**
     * Overloaded method to add a semantic operation directly
     * @see javax.wsdl.PortType#addOperation(javax.wsdl.Operation)
     * @param operation the operation object
     */
    void addOperation(Operation operation);

    /**
     * gets the semantic operation
     * @see javax.wsdl.PortType#getOperation(String, String, String)
     * @param name name of the operation
     * @param inputName  name of the input message
     * @param outputName  name of the  output message
     * @return the semantically annotated operation object
     */
    Operation getSemanticOperation(String name,
                                   String inputName,
                                   String outputName);

    /**
     * removes  a semantic operation.
     * @see javax.wsdl.PortType#removeOperation(String, String, String)
     * @param name name of the operation
     * @param inputName  name of the input message
     * @param outputName  name of the  output message
     * @return the semantically annotated operation object
     */
     Operation removeSemanticOperation(String name,
                                      String inputName,
                                      String outputName);
}


