package edu.uga.cs.lsdis.sawsdl.impl;

import edu.uga.cs.lsdis.sawsdl.ModelReference;

import java.net.URI;

/**
 * This class represents a ModelReference.
 *
 * @author : Ajith Ranabahu
 * @author : Zixin Wu
 * @author : Karthik Gomadam
 * @author : Doug Brewer
 *
 */
public class ModelReferenceImpl implements ModelReference {

    /**
     * The URI of the ontology used in the model reference
     */
    protected URI uri;
    /**
     * The parent object
     */
    protected Object parent;
    /**
     * Get the model reference URI
     * @return the URI object
     */
    public URI getURI() {
        return uri;
    }
    /**
     * set the model reference URI
     * @param uri  - The URI to be set to this model reference
     */
    public void setURI(URI uri) {
        this.uri = uri;
    }

    public String toString(){
        return uri!=null?uri.toString():null;
    }

    /**
     *  Get the parent object for this model reference
     * @return the parent object
     */
    public Object getParent() {
        return parent;
    }

    /**
     * Set the parent for this model reference
     * @param parent the parent object for this model reference
     */
    public void setParent(Object parent) {
        this.parent = parent;
    }

   
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof ModelReferenceImpl) {
            ModelReferenceImpl m = (ModelReferenceImpl) o;
            return m.uri == null ? this.uri == null : m.uri.equals(this.uri);
        } else {
            return false;
        }
    }

    public int hashCode() {
        if (this.uri == null) {
            return 0;
        } else {
            return this.uri.hashCode();
        }
    }

}
