/*
 * (c)
 */

package edu.uga.cs.lsdis.sawsdl.impl;

import edu.uga.cs.lsdis.sawsdl.ModelReference;
import edu.uga.cs.lsdis.sawsdl.Operation;

import java.util.HashSet;
import java.util.Set;


/**
 * This class represents a WSDL operation.
 * It includes information on input, output and fault
 * messages associated with usage of the operation.
 *
 * @author : Ajith Ranabahu
 * @author : Zixin Wu
 * @author : Karthik Gomadam
 * @author : Doug Brewer
 */
public class OperationImpl extends com.ibm.wsdl.OperationImpl implements  Operation{

    
    protected Set<ModelReference> modelRefs = null;


    public void addModelReference (ModelReference modelReference){
        if (this.modelRefs == null)
            modelRefs= new HashSet<ModelReference> ();
        modelRefs.add(modelReference);
    }


    /**
     * Get the modelReference of this operation.
     *
     * @return the modelReference value
     */

    public ModelReference getModelReference(){
        if(modelRefs == null)
            return null;
        return modelRefs.toArray(new ModelReference[modelRefs.size()])[0];
    }


    public Set<ModelReference> getModelReferences() {
        return modelRefs;
    }

    public void setModelReferences(Set<ModelReference> refs) {
        modelRefs = refs;
    }
}
