/*
 * (c) 
 */

package edu.uga.cs.lsdis.sawsdl.impl;

import edu.uga.cs.lsdis.sawsdl.ModelReference;
import edu.uga.cs.lsdis.sawsdl.Part;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;


/**
 * This class represents a message part and contains the part's
 * name, elementName, typeName, and any extensibility attributes.
 *
 * 
 *  @author : Ajith Ranabahu
 * @author : Zixin Wu
 * @author : Karthik Gomadam
 * @author : Doug Brewer
 */
public class PartImpl extends com.ibm.wsdl.PartImpl implements Part
{
    protected Set<ModelReference> modelReferences = new HashSet<ModelReference>();
    protected List<String> liftingSchmaMapping = new ArrayList<String>();
    protected List<String> loweringSchemaMapping = new ArrayList<String>();

    /**
     * Get the modelReference specification located by the given path.
     * @return The modelReference value
     */
    public ModelReference getModelReference(){
        if(modelReferences.size() < 0)
            return null;
        return modelReferences.toArray(new ModelReference[modelReferences.size()])[0];
    }

    /**
     * Set the modelReference specification located by the given path.
     * @param modelReference The new modelReference value
     */
    public void addModelReference(ModelReference modelReference){
        modelReferences.add(modelReference);
    }


    public Set<ModelReference> getModelReferences() {
        return modelReferences;
    }

    public void setModelReferences(Set<ModelReference> refs) {
        modelReferences = refs;
    }

    public void setLiftingSchemaMappings(List<String> mappings) {
        this.liftingSchmaMapping = mappings;
    }

    public List<String> getLiftingSchemaMappings() {
        return liftingSchmaMapping;
    }

    public void setLoweringSchemaMappings(List<String> mappings) {
        this.loweringSchemaMapping = mappings;
    }

    public List<String> getLoweringSchemaMappings() {
        return loweringSchemaMapping;
    }
}
