package edu.uga.cs.lsdis.sawsdl.impl.extensions.sawsdl;

import edu.uga.cs.lsdis.sawsdl.extensions.sawsdl.AttrExtensions;
import edu.uga.cs.lsdis.sawsdl.impl.Constants;

import javax.xml.namespace.QName;
import java.util.HashMap;
import java.util.Map;

/**
 * @author : Ajith Ranabahu
 * @author : Zixin Wu
 * @author : Karthik Gomadam
 * @author : Doug Brewer
 */
public class AttrExtensionsImpl implements AttrExtensions {

    protected QName elementType = Constants.Q_ELEM_ATTR_EXTENSIONS;
    protected Boolean required = null;
    protected String style = null;
    protected String modelRefString = null;
    protected Map attributeMap  = new HashMap();

    public void setModelRefStringValue(String modelRefValue) {
        this.modelRefString = modelRefValue;
    }

    public String getModelRefStringValue() {
        return this.modelRefString;
    }

    /**
     * Get whether or not the semantics of this extension
     * are required. Relates to the wsdl:required attribute.
     */
    public Boolean getRequired() {
        return required;
    }

    /**
     * Set the style for this SOAP binding.
     *
     * @param style the desired style
     */
    public void setStyle(String style) {
        this.style = style;
    }

    /**
     * Get the style for this SOAP binding.
     */
    public String getStyle() {
        return style;
    }

    /**
     * Set the type of this extensibility element.
     *
     * @param elementType the type
     */
    public void setElementType(QName elementType) {
        this.elementType = elementType;
    }

    /**
     * Get the type of this extensibility element.
     *
     * @return the extensibility element's type
     */
    public QName getElementType() {
        return elementType;
    }

    /**
     *
     * @param required
     */
    public void setRequired(Boolean required) {
        this.required = required;
    }

    /**
     * Get all attribute values from  the attribute extensions element
     *
     * @return a map that contains the attribute QName as the key
     *         and the value as a string. Note that this map includes the
     *         modelreference as well
     */
    public Map getAllAttributeValues() {
       return attributeMap;
    }

    /**
     * set the attribute values
     *
     * @param map a map that contains the attribute QName as the key
     *            and the value as a string
     */
    public void setAllAttributeValues(Map map) {
        this.attributeMap = map;
    }
}
