package edu.uga.cs.lsdis.sawsdl.impl.extensions.sawsdl;

import edu.uga.cs.lsdis.sawsdl.extensions.sawsdl.AttrExtensions;
import edu.uga.cs.lsdis.sawsdl.impl.Constants;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.ExtensionDeserializer;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.extensions.ExtensionSerializer;
import javax.xml.namespace.QName;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

/**
 * @author : Ajith Ranabahu
 * @author : Zixin Wu
 * @author : Karthik Gomadam
 * @author : Doug Brewer
 */
public class AttrExtensionsSerializer implements ExtensionSerializer,
        ExtensionDeserializer,
        Serializable{

    /**
     * The marshall method for the attrExtensions
     * @param parentType
     * @param elementType
     * @param extension
     * @param pw
     * @param def
     * @param extReg
     * @throws WSDLException
     */
    public void marshall(Class parentType,
                         QName elementType,
                         ExtensibilityElement extension,
                         PrintWriter pw, Definition def,
                         ExtensionRegistry extReg) throws WSDLException {
        pw.print("<");
        // get the namespace prefix from the registered namespaces
        String prefix = getSAWSDLNSPrefix(def.getNamespaces());

        if (prefix==null){
            //use the default prefix and serialize the namespace
            pw.print(Constants.PREFIX_SAWSDL);
        }else{
            pw.print(prefix);
        }

        pw.print(":"+Constants.ELEM_ATTR_EXTENSIONS);

        if (prefix==null){
            //serialize the namespace
        }

        //write the attribs
        AttrExtensions attrExt = (AttrExtensions)extension;
        Map allAttributeValues = attrExt.getAllAttributeValues();
        for (Object key:allAttributeValues.keySet()){
            QName qNameKey = (QName) key;
            String nsPrefix = qNameKey.getPrefix();
            if (nsPrefix== null || "".equals(nsPrefix)){
               nsPrefix= getNSPrefix(qNameKey.getNamespaceURI(),def.getNamespaces());
            }
            pw.print(" "+
                    (nsPrefix!=null? (nsPrefix + ":"):"") +
                    (qNameKey.getLocalPart() +"=\""+ allAttributeValues.get(key) + "\""));
        }


        pw.print(" />");
    }


    /**
     * The unmarshall method for the attr extensions
     * @param parentType
     * @param elementType
     * @param el
     * @param def
     * @param extReg
     * @return  ExtensibilityElement object
     * @throws WSDLException
     */
    public ExtensibilityElement unmarshall(Class parentType,
                                           QName elementType,
                                           Element el,
                                           Definition def,
                                           ExtensionRegistry extReg) throws WSDLException {
        AttrExtensions attrExt = (AttrExtensions)extReg.createExtension(parentType,
                elementType);
        //set the model reference value first
        String modelRefValue = el.getAttributeNS(Constants.NS_URI_SAWSDL,
                Constants.ATTR_MODELREF);
        attrExt.setModelRefStringValue(modelRefValue);

        //now create the map and set it (and all other attributes)
        Map m = new HashMap();
        NamedNodeMap attributes = el.getAttributes();
        for (int i = 0; i <attributes.getLength(); i++) {
            Attr att = (Attr)attributes.item(i);
            //attribute.getLocalName returns a null ? This may be due to a factory
            //config error down the line but lets keep this for now
            m.put(new QName(att.getNamespaceURI(),att.getLocalName()),att.getValue());
        }

        attrExt.setAllAttributeValues(m);
        return attrExt;

    }

    /**
     * get the prefix for the SAWSDL namespace
     * @param namespaceMap
     * @return the prefix of the SAWSDL namespace if
     * found or null otherwise
     */
    private String getNSPrefix(String namespace,Map namespaceMap){
        for (Object key:namespaceMap.keySet()){
            if (namespace.equals(namespaceMap.get(key))){
                return (String)key;
            }
        }

        return null;
    }

    /**
     * get the prefix for the SAWSDL namespace
     * @param namespaceMap
     * @return the prefix of the SAWSDL namespace if
     * found or null otherwise
     */
    private String getSAWSDLNSPrefix(Map namespaceMap){
        for (Object key:namespaceMap.keySet()){
            if (Constants.NS_URI_SAWSDL.equals(namespaceMap.get(key))){
                return (String)key;
            }
        }

        return null;
    }
}
