/*
 * Decompiled with CFR 0.152.
 */
package edu.uga.cs.lsdis.sawsdl.impl.util;

import edu.uga.cs.lsdis.sawsdl.Definition;
import edu.uga.cs.lsdis.sawsdl.ModelReference;
import edu.uga.cs.lsdis.sawsdl.ModelReferenceExtensible;
import edu.uga.cs.lsdis.sawsdl.WSDLSException;
import edu.uga.cs.lsdis.sawsdl.impl.ModelReferenceImpl;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelRefUtil {
    public static void valueOf(ModelReferenceImpl modelRef, String modelReferenceAsString, Definition def) throws URISyntaxException, WSDLSException {
    }

    public static ModelReference getSingleModelReferencesFromString(String modelrefsAsString, Definition def) throws URISyntaxException {
        ModelReferenceImpl modelReference = new ModelReferenceImpl();
        modelReference.setURI(new URI(modelrefsAsString));
        return modelReference;
    }

    public static String[] splitString(String modelRefString) {
        return modelRefString.trim().split("\\s+");
    }

    public static Set<ModelReference> parseModelReference(String modelReferenceString, Definition def, Object op) throws URISyntaxException, WSDLSException {
        return ModelRefUtil.parseModelReference(ModelRefUtil.splitString(modelReferenceString), def, op);
    }

    public static Set<ModelReference> parseModelReference(List modelRefs, Definition def, ModelReferenceExtensible op) throws URISyntaxException, WSDLSException {
        HashSet<ModelReference> modelReferenceList = new HashSet<ModelReference>();
        for (Object modelRef : modelRefs) {
            ModelReference currentModelReference = ModelRefUtil.getSingleModelReferencesFromString((String)modelRef, def);
            currentModelReference.setParent(op);
            modelReferenceList.add(currentModelReference);
            op.addModelReference(currentModelReference);
        }
        return modelReferenceList;
    }

    public static Set<ModelReference> parseModelReference(String[] modelRefs, Definition def, Object op) throws URISyntaxException, WSDLSException {
        HashSet<ModelReference> modelReferenceList = new HashSet<ModelReference>();
        for (String modelRef : modelRefs) {
            ModelReference currentModelReference = ModelRefUtil.getSingleModelReferencesFromString(modelRef, def);
            currentModelReference.setParent(op);
            modelReferenceList.add(currentModelReference);
            if (!(op instanceof ModelReferenceExtensible)) continue;
            ((ModelReferenceExtensible)op).addModelReference(currentModelReference);
        }
        return modelReferenceList;
    }
}

