package org.jeinnov.jeitime.api.service.utils;

import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class CalculDate {
	public CalculDate() {

	}

	public Timestamp getDateStartWeek(Date date) {

		Calendar cal = Calendar.getInstance();
		cal.setTime(date);

		int day = cal.get(Calendar.DAY_OF_WEEK);
		int intStartWeek;
		Timestamp startWeek = null;
		Date startDate;

		switch (day) {
		case 2:
			startDate = date;
			startWeek = new Timestamp(startDate.getTime());
			cal.setTime(date);
			break;

		case 3:
			intStartWeek = cal.get(Calendar.DAY_OF_MONTH) - 1;
			cal.set(Calendar.DAY_OF_MONTH, intStartWeek);
			startDate = cal.getTime();
			startWeek = new Timestamp(startDate.getTime());
			break;
		case 4:
			intStartWeek = cal.get(Calendar.DAY_OF_MONTH) - 2;
			cal.set(Calendar.DAY_OF_MONTH, intStartWeek);
			startDate = cal.getTime();
			startWeek = new Timestamp(startDate.getTime());
			break;
		case 5:
			intStartWeek = cal.get(Calendar.DAY_OF_MONTH) - 3;
			cal.set(Calendar.DAY_OF_MONTH, intStartWeek);
			startDate = cal.getTime();
			startWeek = new Timestamp(startDate.getTime());
			break;
		case 6:
			intStartWeek = cal.get(Calendar.DAY_OF_MONTH) - 4;
			cal.set(Calendar.DAY_OF_MONTH, intStartWeek);
			startDate = cal.getTime();
			startWeek = new Timestamp(startDate.getTime());
			break;
		case 7:
			intStartWeek = cal.get(Calendar.DAY_OF_MONTH) - 5;
			cal.set(Calendar.DAY_OF_MONTH, intStartWeek);
			startDate = cal.getTime();
			startWeek = new Timestamp(startDate.getTime());
			break;
		case 1:
			intStartWeek = cal.get(Calendar.DAY_OF_MONTH) - 6;
			cal.set(Calendar.DAY_OF_MONTH, intStartWeek);
			startDate = cal.getTime();
			startWeek = new Timestamp(startDate.getTime());
			break;
		}

		return startWeek;
	}

	public Timestamp getDateEndWeek(Date date) {
		Calendar cal = Calendar.getInstance();
		cal.setTime(date);

		int day = cal.get(Calendar.DAY_OF_WEEK);
		Timestamp end = null;
		int intEndWeek;
		Date endDate;

		switch (day) {
		case 2:
			intEndWeek = cal.get(Calendar.DAY_OF_MONTH) + 4;
			cal.set(Calendar.DAY_OF_MONTH, intEndWeek);
			endDate = cal.getTime();
			end = new Timestamp(endDate.getTime());
			break;
		case 3:
			intEndWeek = cal.get(Calendar.DAY_OF_MONTH) + 3;
			cal.set(Calendar.DAY_OF_MONTH, intEndWeek);
			endDate = cal.getTime();
			end = new Timestamp(endDate.getTime());
			break;
		case 4:
			intEndWeek = cal.get(Calendar.DAY_OF_MONTH) + 2;
			cal.set(Calendar.DAY_OF_MONTH, intEndWeek);
			endDate = cal.getTime();
			end = new Timestamp(endDate.getTime());
			break;
		case 5:
			intEndWeek = cal.get(Calendar.DAY_OF_MONTH) + 1;
			cal.set(Calendar.DAY_OF_MONTH, intEndWeek);
			endDate = cal.getTime();
			end = new Timestamp(endDate.getTime());
			break;
		case 6:
			endDate = date;
			end = new Timestamp(endDate.getTime());
			break;
		case 7:
			intEndWeek = cal.get(Calendar.DAY_OF_MONTH) - 1;
			cal.set(Calendar.DAY_OF_MONTH, intEndWeek);
			endDate = cal.getTime();
			end = new Timestamp(endDate.getTime());
			break;
		case 1:
			intEndWeek = cal.get(Calendar.DAY_OF_MONTH) - 2;
			cal.set(Calendar.DAY_OF_MONTH, intEndWeek);
			endDate = cal.getTime();
			end = new Timestamp(endDate.getTime());
			break;
		}
		return end;
	}

	public Timestamp getDateStartMonth(int year, int month) {

		Calendar cal = GregorianCalendar.getInstance();
		if (year == 0) {
			cal.getTime();
			year = cal.get(Calendar.YEAR);
		}

		cal.set(Calendar.YEAR, year);
		cal.set(Calendar.DAY_OF_MONTH, 01);
		cal.set(Calendar.MONTH, month);
		cal.set(Calendar.HOUR_OF_DAY, 00);
		cal.set(Calendar.MINUTE, 00);
		cal.set(Calendar.SECOND, 00);
		cal.set(Calendar.MILLISECOND, 00);

		Date dateStartMonth = cal.getTime();
		Timestamp startMonth = new Timestamp(dateStartMonth.getTime());

		return startMonth;
	}

	public Timestamp getDateEndMonth(int year, int month) {
		Calendar cal = GregorianCalendar.getInstance();
		if (year == 0) {
			cal.getTime();
			year = cal.get(Calendar.YEAR);
		}

		cal.set(Calendar.YEAR, year);
		cal.set(Calendar.DAY_OF_MONTH, 31);
		cal.set(Calendar.MONTH, month);
		cal.set(Calendar.MILLISECOND, 00);
		cal.set(Calendar.MINUTE, 00);
		cal.set(Calendar.HOUR_OF_DAY, 00);
		Date dateEndMonth = cal.getTime();
		Timestamp endMonth = new Timestamp(dateEndMonth.getTime());

		return endMonth;
	}

	public Timestamp getDateStartYear(int year) {
		Calendar cal = GregorianCalendar.getInstance();
		if (year == 0) {
			cal.getTime();
			year = cal.get(Calendar.YEAR);
		}
		cal.set(Calendar.YEAR, year);
		cal.set(Calendar.DAY_OF_MONTH, 01);
		cal.set(Calendar.MONTH, 0);
		Date dateStart = cal.getTime();
		Timestamp start = new Timestamp(dateStart.getTime());

		return start;
	}

	public Timestamp getDateEndYear(int year) {
		Calendar cal = GregorianCalendar.getInstance();
		if (year == 0) {
			cal.getTime();
			year = cal.get(Calendar.YEAR);
		}

		cal.set(Calendar.YEAR, year);
		cal.set(Calendar.DAY_OF_MONTH, 31);
		cal.set(Calendar.MONTH, 11);
		Date dateEnd = cal.getTime();
		Timestamp end = new Timestamp(dateEnd.getTime());

		return end;
	}

	public String getMonth(int numMonth) {
		String monthName = null;

		switch (numMonth) {
		case 0:
			monthName = "Janvier";
			break;
		case 1:
			monthName = "Février";
			break;
		case 2:
			monthName = "Mars";
			break;
		case 3:
			monthName = "Avril";
			break;
		case 4:
			monthName = "Mai";
			break;
		case 5:
			monthName = "Juin";
			break;
		case 6:
			monthName = "Juillet";
			break;
		case 7:
			monthName = "Août";
			break;
		case 8:
			monthName = "Septembre";
			break;
		case 9:
			monthName = "Octobre";
			break;
		case 10:
			monthName = "Novembre";
			break;
		case 11:
			monthName = "Décembre";
			break;
		}

		return monthName;
	}
}
