/*
 * Decompiled with CFR 0.152.
 */
package org.jeinnov.jeitime.api.service.bilan;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;
import org.jeinnov.jeitime.api.service.bilan.BilanException;
import org.jeinnov.jeitime.api.service.utils.InsertionSousTotaux;
import org.jeinnov.jeitime.api.service.utils.SortList;
import org.jeinnov.jeitime.api.to.bilan.RecapProjetHibernate;
import org.jeinnov.jeitime.api.to.bilan.RecapProjetTO;
import org.jeinnov.jeitime.api.to.collaborateur.CollaborateurTO;
import org.jeinnov.jeitime.api.to.projet.NomTacheTO;
import org.jeinnov.jeitime.api.to.projet.ProjetTO;
import org.jeinnov.jeitime.api.to.projet.TacheTO;
import org.jeinnov.jeitime.api.to.projet.ThematiqueTO;
import org.jeinnov.jeitime.api.to.projet.TypeTacheTO;
import org.jeinnov.jeitime.persistence.bo.projet.TacheP;
import org.jeinnov.jeitime.persistence.bo.projet.ThematiqueP;
import org.jeinnov.jeitime.persistence.dao.bilan.RecapThemaDAO;
import org.jeinnov.jeitime.persistence.dao.projet.ThematiqueDAO;
import org.jeinnov.jeitime.utils.HibernateUtil;

public class ThematiqueBilanManager
extends InsertionSousTotaux {
    private final Logger logger = Logger.getLogger(this.getClass());
    private static ThematiqueBilanManager manager;
    private RecapThemaDAO recapThemaDAO = RecapThemaDAO.getInstance();
    private SortList sortList = new SortList();

    public static ThematiqueBilanManager getInstance() {
        if (manager == null) {
            manager = new ThematiqueBilanManager();
        }
        return manager;
    }

    public List<RecapProjetTO> creerListRecapProjetThematique(int[] tablIdThem, Date dateD, Date dateF) throws BilanException {
        if (tablIdThem == null) {
            throw new BilanException("Attention aucune th\u00e9matique n'est associ\u00e9e ! ");
        }
        ArrayList<RecapProjetTO> listRecap = new ArrayList<RecapProjetTO>();
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            for (int m = 0; m < tablIdThem.length; ++m) {
                int id = tablIdThem[m];
                List listRecapHibernate = this.recapThemaDAO.creerListRecapProjetThema((org.hibernate.Session)session, id, dateD, dateF);
                List list = this.recapThemaDAO.listTacheThema((org.hibernate.Session)session, id);
                List listRecapTmp = new ArrayList();
                listRecapTmp = this.createListRecapThem(id, list, listRecapHibernate);
                listRecap.addAll(listRecapTmp);
            }
            tx.commit();
        }
        catch (RuntimeException e) {
            tx.rollback();
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        return listRecap;
    }

    public List<Object> listTacheThema(int[] tablIdThem) throws BilanException {
        if (tablIdThem == null) {
            throw new BilanException("Attention aucune th\u00e9matique n'est associ\u00e9e ! ");
        }
        ArrayList<Object> listItems = new ArrayList();
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            for (int i = 0; i < tablIdThem.length; ++i) {
                int idT = tablIdThem[i];
                List listTache = this.recapThemaDAO.listTache((org.hibernate.Session)session, idT);
                if (listTache == null || listTache.isEmpty()) {
                    ThematiqueP them = (ThematiqueP)ThematiqueDAO.getInstance().find((Serializable)Integer.valueOf(idT));
                    String nomT = them.getNomThematique();
                    listItems.add(nomT);
                    listItems.add(them.getIdThematique());
                } else {
                    List listItemsTmp = new ArrayList();
                    listItemsTmp = this.createListTache(listTache);
                    listItems.addAll(listItemsTmp);
                }
                listItems.add(idT);
            }
            tx.commit();
        }
        catch (RuntimeException e) {
            tx.rollback();
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        listItems = this.sortList.trieListItem(listItems);
        listItems = this.insertionSousTotal(listItems);
        listItems = this.insertionSousTotalProjet(listItems);
        return listItems;
    }

    public List<Object> createListTache(List<TacheP> listTache) {
        ArrayList<Object> listItems = new ArrayList<Object>();
        String nom = null;
        for (int j = 0; j < listTache.size(); ++j) {
            TypeTacheTO typeTache = null;
            NomTacheTO nomtache = new NomTacheTO(listTache.get(j).getNomTacheP().getIdNomTache(), listTache.get(j).getNomTacheP().getNomTache(), typeTache);
            TacheTO tache = new TacheTO(listTache.get(j).getIdTache(), nomtache, listTache.get(j).getBudgetprevu(), listTache.get(j).getTpsprevu(), listTache.get(j).getPriorite(), listTache.get(j).isEligible(), null);
            tache.setEligible(listTache.get(j).isEligible());
            ProjetTO proj = new ProjetTO();
            proj.setIdProjet(listTache.get(j).getProjet().getIdProjet());
            proj.setNomProjet(listTache.get(j).getProjet().getNomProjet());
            if (listTache.get(j).getProjet().getThematique() != null) {
                proj.setThematique(new ThematiqueTO(listTache.get(j).getProjet().getThematique().getIdThematique()));
                nom = listTache.get(j).getProjet().getThematique().getNomThematique();
            }
            listItems.add(nom);
            listItems.add(proj);
            listItems.add(tache);
            tache.setProjet(proj);
        }
        return listItems;
    }

    private List<RecapProjetTO> createListRecapThem(int id, List<TacheP> list, List<RecapProjetHibernate> listRecapHibernate) {
        ArrayList<RecapProjetTO> listRecap = new ArrayList<RecapProjetTO>();
        for (int j = 0; j < listRecapHibernate.size(); ++j) {
            ProjetTO projet = new ProjetTO();
            projet.setNomProjet(listRecapHibernate.get(j).getNomProjet());
            projet.setIdProjet(listRecapHibernate.get(j).getIdProjet());
            projet.setThematique(new ThematiqueTO(id));
            TypeTacheTO typeTache = null;
            NomTacheTO nomTache = new NomTacheTO(listRecapHibernate.get(j).getIdNomTache(), listRecapHibernate.get(j).getNomTache(), typeTache);
            TacheTO tache = new TacheTO(listRecapHibernate.get(j).getIdTache(), nomTache);
            CollaborateurTO collab = new CollaborateurTO(listRecapHibernate.get(j).getIdColl(), listRecapHibernate.get(j).getNomColl());
            double nbheure = 0.0;
            if (listRecapHibernate.get(j).getTotal() instanceof Double) {
                nbheure = (Double)listRecapHibernate.get(j).getTotal();
            }
            if (listRecapHibernate.get(j).getTotal() instanceof Float) {
                nbheure = ((Float)listRecapHibernate.get(j).getTotal()).floatValue();
            }
            for (TacheP t : list) {
                if (listRecapHibernate.get(j).getIdTache() != t.getIdTache()) continue;
                tache.setEligible(t.isEligible());
            }
            listRecap.add(new RecapProjetTO(projet, tache, collab, nbheure));
        }
        return listRecap;
    }
}

