/*
 * Decompiled with CFR 0.152.
 */
package org.jeinnov.jeitime.api.service.bilan;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;
import org.jeinnov.jeitime.api.service.bilan.BilanException;
import org.jeinnov.jeitime.api.service.utils.InsertionSousTotaux;
import org.jeinnov.jeitime.api.service.utils.SortList;
import org.jeinnov.jeitime.api.to.bilan.RecapProjetHibernate;
import org.jeinnov.jeitime.api.to.bilan.RecapProjetTO;
import org.jeinnov.jeitime.api.to.collaborateur.CollaborateurTO;
import org.jeinnov.jeitime.api.to.projet.NomTacheTO;
import org.jeinnov.jeitime.api.to.projet.ProjetTO;
import org.jeinnov.jeitime.api.to.projet.TacheTO;
import org.jeinnov.jeitime.api.to.projet.TypeProjetTO;
import org.jeinnov.jeitime.api.to.projet.TypeTacheTO;
import org.jeinnov.jeitime.persistence.bo.projet.TacheP;
import org.jeinnov.jeitime.persistence.bo.projet.TypeProjetP;
import org.jeinnov.jeitime.persistence.dao.bilan.RecapTypePDAO;
import org.jeinnov.jeitime.persistence.dao.projet.TypeProjetDAO;
import org.jeinnov.jeitime.utils.HibernateUtil;

public class TypeProjetBilanManager
extends InsertionSousTotaux {
    private final Logger logger = Logger.getLogger(this.getClass());
    private static TypeProjetBilanManager manager;
    private RecapTypePDAO recapTypePDAO = RecapTypePDAO.getInstance();
    private SortList sortList = new SortList();

    public static TypeProjetBilanManager getInstance() {
        if (manager == null) {
            manager = new TypeProjetBilanManager();
        }
        return manager;
    }

    public List<RecapProjetTO> creerListRecapProjet(int[] tablIdTypeP, Date dateD, Date dateF) throws BilanException {
        if (tablIdTypeP == null) {
            throw new BilanException("Attention aucun domaine n'est associ\u00e9 ! ");
        }
        ArrayList<RecapProjetTO> listRecap = new ArrayList<RecapProjetTO>();
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            for (int m = 0; m < tablIdTypeP.length; ++m) {
                int idD = tablIdTypeP[m];
                List listRecapHibernate = this.recapTypePDAO.creerListRecapProjet((org.hibernate.Session)session, idD, dateD, dateF);
                List list = this.recapTypePDAO.listTacheTypeProjet((org.hibernate.Session)session, idD);
                List listRecapTmp = new ArrayList();
                listRecapTmp = this.createListRecapTypeProjet(idD, list, listRecapHibernate);
                listRecap.addAll(listRecapTmp);
            }
            tx.commit();
        }
        catch (RuntimeException e) {
            tx.rollback();
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        return listRecap;
    }

    public List<Object> listTacheTypeProjet(int[] tablIdTypeProjet) throws BilanException {
        if (tablIdTypeProjet == null) {
            throw new BilanException("Attention aucun domaine n'est associ\u00e9 ! ");
        }
        ArrayList<Object> listItems = new ArrayList();
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            for (int i = 0; i < tablIdTypeProjet.length; ++i) {
                int idT = tablIdTypeProjet[i];
                List listTache = this.recapTypePDAO.listTache((org.hibernate.Session)session, idT);
                if (listTache == null || listTache.isEmpty()) {
                    TypeProjetP tp = (TypeProjetP)TypeProjetDAO.getInstance().find((Serializable)Integer.valueOf(idT));
                    String nomD = tp.getNomTypePro();
                    listItems.add(nomD);
                    listItems.add(tp.getIdTypePro());
                } else {
                    List listItemsTmp = new ArrayList();
                    listItemsTmp = this.createListTache(listTache);
                    listItems.addAll(listItemsTmp);
                }
                listItems.add(idT);
            }
            tx.commit();
        }
        catch (RuntimeException e) {
            tx.rollback();
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        listItems = this.sortList.trieListItem(listItems);
        listItems = this.insertionSousTotal(listItems);
        listItems = this.insertionSousTotalProjet(listItems);
        return listItems;
    }

    public List<Object> createListTache(List<TacheP> listTache) {
        ArrayList<Object> listItems = new ArrayList<Object>();
        String nom = null;
        for (int j = 0; j < listTache.size(); ++j) {
            TypeTacheTO typeTache = null;
            NomTacheTO nomtache = new NomTacheTO(listTache.get(j).getNomTacheP().getIdNomTache(), listTache.get(j).getNomTacheP().getNomTache(), typeTache);
            TacheTO tache = new TacheTO(listTache.get(j).getIdTache(), nomtache, listTache.get(j).getBudgetprevu(), listTache.get(j).getTpsprevu(), listTache.get(j).getPriorite(), listTache.get(j).isEligible(), null);
            tache.setEligible(listTache.get(j).isEligible());
            ProjetTO proj = new ProjetTO();
            proj.setIdProjet(listTache.get(j).getProjet().getIdProjet());
            proj.setNomProjet(listTache.get(j).getProjet().getNomProjet());
            if (listTache.get(j).getProjet().getTypeProjet() != null) {
                proj.setTypeProjet(new TypeProjetTO(listTache.get(j).getProjet().getTypeProjet().getIdTypePro()));
                nom = listTache.get(j).getProjet().getTypeProjet().getNomTypePro();
            }
            listItems.add(nom);
            listItems.add(proj);
            listItems.add(tache);
            tache.setProjet(proj);
        }
        return listItems;
    }

    private List<RecapProjetTO> createListRecapTypeProjet(int idTP, List<TacheP> list, List<RecapProjetHibernate> listRecapHibernate) {
        ArrayList<RecapProjetTO> listRecap = new ArrayList<RecapProjetTO>();
        for (int j = 0; j < listRecapHibernate.size(); ++j) {
            ProjetTO projet = new ProjetTO();
            projet.setNomProjet(listRecapHibernate.get(j).getNomProjet());
            projet.setIdProjet(listRecapHibernate.get(j).getIdProjet());
            projet.setTypeProjet(new TypeProjetTO(idTP));
            TypeTacheTO typeTache = null;
            NomTacheTO nomTache = new NomTacheTO(listRecapHibernate.get(j).getIdNomTache(), listRecapHibernate.get(j).getNomTache(), typeTache);
            TacheTO tache = new TacheTO(listRecapHibernate.get(j).getIdTache(), nomTache);
            CollaborateurTO collab = new CollaborateurTO(listRecapHibernate.get(j).getIdColl(), listRecapHibernate.get(j).getNomColl());
            double nbheure = 0.0;
            if (listRecapHibernate.get(j).getTotal() instanceof Double) {
                nbheure = (Double)listRecapHibernate.get(j).getTotal();
            }
            if (listRecapHibernate.get(j).getTotal() instanceof Float) {
                nbheure = ((Float)listRecapHibernate.get(j).getTotal()).floatValue();
            }
            for (TacheP t : list) {
                if (listRecapHibernate.get(j).getIdTache() != t.getIdTache()) continue;
                tache.setEligible(t.isEligible());
            }
            listRecap.add(new RecapProjetTO(projet, tache, collab, nbheure));
        }
        return listRecap;
    }
}

