/*
 * Decompiled with CFR 0.152.
 */
package org.jeinnov.jeitime.api.service.collaborateur;

import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;
import org.jeinnov.jeitime.api.service.collaborateur.CollaborateurException;
import org.jeinnov.jeitime.api.service.collaborateur.ResultTransformerCollaborateur;
import org.jeinnov.jeitime.api.service.collaborateur.RoleCollabManager;
import org.jeinnov.jeitime.api.to.collaborateur.CollaborateurTO;
import org.jeinnov.jeitime.persistence.bo.collaborateur.CollaborateurP;
import org.jeinnov.jeitime.persistence.dao.collaborateur.CollaborateurDAO;
import org.jeinnov.jeitime.utils.HibernateUtil;

public class CollaborateurManager {
    private final Logger logger = Logger.getLogger(this.getClass());
    private CollaborateurDAO collaborateurDAO = CollaborateurDAO.getInstance();
    private ResultTransformerCollaborateur resultTransformer = new ResultTransformerCollaborateur();
    private static CollaborateurManager manager;

    public static CollaborateurManager getInstance() {
        if (manager == null) {
            manager = new CollaborateurManager();
        }
        return manager;
    }

    public void init() throws CollaborateurException {
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        CollaborateurP collabP = new CollaborateurP();
        try {
            collabP = this.collaborateurDAO.getByLogin("admin");
            tx.commit();
        }
        catch (RuntimeException e) {
            tx.rollback();
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        if (collabP == null) {
            CollaborateurTO collab = new CollaborateurTO();
            collab.setLogin("admin");
            collab.setPrenomColl("admin");
            collab.setNomColl("admin");
            collab.setStatut(0);
            String password = this.passwordCrypting("admin");
            collab.setPassword(password);
            int id = this.saveOrUpdate(collab);
            RoleCollabManager.getInstance().save(0, id);
        }
    }

    public CollaborateurTO get(int id) throws CollaborateurException {
        if (id == 0) {
            throw new CollaborateurException("Attention, aucun collaborateur n'a \u00e9t\u00e9 s\u00e9lectionn\u00e9 !");
        }
        CollaborateurTO collaborateur = new CollaborateurTO();
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            CollaborateurP collabP = (CollaborateurP)this.collaborateurDAO.find((Serializable)Integer.valueOf(id));
            if (collabP == null || collabP.getIdColl() == 0) {
                throw new CollaborateurException("Attention, le collaborateur s\u00e9lectionn\u00e9 n'existe pas dans la base !");
            }
            collaborateur = this.resultTransformer.toCollaborateurTO(collabP);
            tx.commit();
        }
        catch (RuntimeException e) {
            tx.rollback();
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        return collaborateur;
    }

    public CollaborateurP getByLogin(String login) throws CollaborateurException {
        if (login == null) {
            throw new CollaborateurException("Vous n'avez pas saisie de login !");
        }
        CollaborateurP collabP = new CollaborateurP();
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            collabP = this.collaborateurDAO.getByLogin(login);
            if (collabP == null) {
                throw new CollaborateurException("Aucun collaborateur avec ce login existe dans la base !");
            }
            tx.commit();
        }
        catch (RuntimeException e) {
            tx.rollback();
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        return collabP;
    }

    public List<CollaborateurTO> getAll() {
        ArrayList<CollaborateurTO> listCollabTO = new ArrayList<CollaborateurTO>();
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            List listCollabP = this.collaborateurDAO.getAll();
            if (listCollabP != null) {
                for (CollaborateurP collabP : listCollabP) {
                    CollaborateurTO collaborateur = this.resultTransformer.toCollaborateurTO(collabP);
                    listCollabTO.add(collaborateur);
                }
            }
            tx.commit();
        }
        catch (RuntimeException e) {
            tx.rollback();
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        return listCollabTO;
    }

    public List<CollaborateurTO> getAllWithoutAdmin() {
        List listCollabTO = this.getAll();
        for (int i = 0; i < listCollabTO.size(); ++i) {
            if (!((CollaborateurTO)listCollabTO.get(i)).getLogin().equalsIgnoreCase("admin")) continue;
            listCollabTO.remove(i);
        }
        return listCollabTO;
    }

    public List<CollaborateurTO> getAllByIdEquipe(int idEquipe) {
        ArrayList<CollaborateurTO> listCollabTO = new ArrayList<CollaborateurTO>();
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            List listCollabP;
            if (idEquipe != 0 && (listCollabP = this.collaborateurDAO.getAllByIdEquipe(idEquipe)) != null) {
                for (CollaborateurP collabP : listCollabP) {
                    if (collabP.getLogin().equalsIgnoreCase("admin")) continue;
                    CollaborateurTO collaborateur = this.resultTransformer.toCollaborateurTO(collabP);
                    listCollabTO.add(collaborateur);
                }
            }
            tx.commit();
        }
        catch (RuntimeException e) {
            tx.rollback();
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        return listCollabTO;
    }

    public int saveOrUpdate(CollaborateurTO collaborateur) throws CollaborateurException {
        if (collaborateur == null) {
            throw new CollaborateurException("Attention, aucun collaborateur n'a \u00e9t\u00e9 cr\u00e9\u00e9 !");
        }
        if (collaborateur.getLogin() == null) {
            throw new CollaborateurException("Attention, aucun login n'a \u00e9t\u00e9 sp\u00e9cifi\u00e9 pour ce collaborateur !");
        }
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        CollaborateurP collabP = new CollaborateurP();
        int id = 0;
        try {
            collabP = this.collaborateurDAO.getByLogin(collaborateur.getLogin().toLowerCase());
            this.verificationAvantEnregistrement(collaborateur, collabP);
            if (collabP == null || collabP.getIdColl() == 0) {
                collabP = new CollaborateurP();
            }
            this.resultTransformer.toCollaborateurP(collaborateur, collabP);
            this.collaborateurDAO.save((Object)collabP);
            id = collabP.getIdColl();
            tx.commit();
        }
        catch (RuntimeException e) {
            tx.rollback();
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        return id;
    }

    public void delete(int id) throws CollaborateurException {
        if (id == 0) {
            throw new CollaborateurException("Aucun collaborateur n'a \u00e9t\u00e9 s\u00e9lectionn\u00e9 ! ");
        }
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            CollaborateurP c = (CollaborateurP)this.collaborateurDAO.find((Serializable)Integer.valueOf(id));
            if (c == null || c.getIdColl() == 0) {
                throw new CollaborateurException("Le collaborateur s\u00e9lectionn\u00e9 n'existe pas dans la base ");
            }
            if (c.getLogin().equalsIgnoreCase("admin")) {
                throw new CollaborateurException("Vous ne pouvez pas supprimer l'utilisateur avec le login admin ");
            }
            this.collaborateurDAO.remove((Object)c);
            tx.commit();
        }
        catch (RuntimeException e) {
            tx.rollback();
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public boolean isInLientTachUtil(int id) {
        boolean verif = true;
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            verif = this.collaborateurDAO.isInLienTachUtil(id, (org.hibernate.Session)session);
            tx.commit();
        }
        catch (RuntimeException e) {
            verif = true;
            tx.rollback();
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        return verif;
    }

    private void verificationAvantEnregistrement(CollaborateurTO c, CollaborateurP collabP) throws CollaborateurException {
        if (c.getNomColl() == null || c.getPrenomColl() == null || c.getPassword() == null) {
            throw new CollaborateurException("Attention, soit le nom du collaborateur, son pr\u00e9nom, ou son mot de passe ne sont pas renseign\u00e9s !");
        }
        if (collabP != null && collabP.getIdColl() != 0 && c.getIdColl() != collabP.getIdColl()) {
            throw new CollaborateurException("Attention, un collaborateur existe d\u00e9j\u00e0 avec ce login !");
        }
    }

    public String passwordCrypting(String password) {
        byte[] uniqueKey = password.getBytes();
        byte[] hash = null;
        try {
            hash = MessageDigest.getInstance("MD5").digest(uniqueKey);
        }
        catch (NoSuchAlgorithmException e) {
            this.logger.info((Object)"No MD5 support in this VM.");
        }
        StringBuilder hashString = new StringBuilder();
        for (int i = 0; i < hash.length; ++i) {
            String hex = Integer.toHexString(hash[i]);
            if (hex.length() == 1) {
                hashString.append('0');
                hashString.append(hex.charAt(hex.length() - 1));
                continue;
            }
            hashString.append(hex.substring(hex.length() - 2));
        }
        return hashString.toString();
    }
}

