/*
 * Decompiled with CFR 0.152.
 */
package org.jeinnov.jeitime.api.service.collaborateur;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;
import org.jeinnov.jeitime.api.service.collaborateur.CollaborateurException;
import org.jeinnov.jeitime.persistence.bo.collaborateur.CollaborateurP;
import org.jeinnov.jeitime.persistence.bo.collaborateur.Roles;
import org.jeinnov.jeitime.persistence.bo.collaborateur.RolesCollab;
import org.jeinnov.jeitime.persistence.bo.collaborateur.RolesId;
import org.jeinnov.jeitime.persistence.dao.collaborateur.CollaborateurDAO;
import org.jeinnov.jeitime.persistence.dao.collaborateur.RoleCollabDAO;
import org.jeinnov.jeitime.persistence.dao.collaborateur.RolesDAO;
import org.jeinnov.jeitime.utils.HibernateUtil;

public class RoleCollabManager {
    private final Logger logger = Logger.getLogger(this.getClass());
    private RoleCollabDAO rolesCollabDAO = RoleCollabDAO.getInstance();
    private RolesDAO rolesDAO = RolesDAO.getInstance();
    private static RoleCollabManager manager;

    public static RoleCollabManager getInstance() {
        if (manager == null) {
            manager = new RoleCollabManager();
        }
        return manager;
    }

    public void init() {
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            Roles role = this.rolesDAO.getByName("administrateur");
            if (role == null) {
                role = new Roles();
                role.setRoles("administrateur");
                this.rolesDAO.save((Object)role);
            }
            if ((role = this.rolesDAO.getByName("chef_de_projet")) == null) {
                role = new Roles();
                role.setRoles("chef_de_projet");
                this.rolesDAO.save((Object)role);
            }
            if ((role = this.rolesDAO.getByName("collaborateur")) == null) {
                role = new Roles();
                role.setRoles("collaborateur");
                this.rolesDAO.save((Object)role);
            }
            if ((role = this.rolesDAO.getByName("gestionnaire")) == null) {
                role = new Roles();
                role.setRoles("gestionnaire");
                this.rolesDAO.save((Object)role);
            }
            tx.commit();
        }
        catch (RuntimeException e) {
            tx.rollback();
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public List<RolesCollab> getByCollaborateurId(int idCollab) throws CollaborateurException {
        if (idCollab == 0) {
            throw new CollaborateurException("vous devez sp\u00e9cifier un collaborateur !");
        }
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        ArrayList<RolesCollab> listRoles = new ArrayList();
        try {
            listRoles = this.rolesCollabDAO.getByIdCollab(idCollab);
            tx.commit();
        }
        catch (RuntimeException e) {
            tx.rollback();
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        return listRoles;
    }

    public void save(int statut, int idCollab) throws CollaborateurException {
        if (idCollab == 0) {
            throw new CollaborateurException("vous devez sp\u00e9cifier un collaborateur !");
        }
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        CollaborateurP collabP = (CollaborateurP)CollaborateurDAO.getInstance().find((Serializable)Integer.valueOf(idCollab));
        if (collabP == null) {
            throw new CollaborateurException("Le collaborateur choisi n'existe pas dans la base !");
        }
        collabP = new CollaborateurP();
        collabP.setIdColl(idCollab);
        String roleName = this.getRole(statut);
        Roles role = new Roles();
        role.setRoles(roleName);
        RolesId roleId = new RolesId();
        roleId.setIdColl(idCollab);
        roleId.setRoles(roleName);
        RolesCollab rC = new RolesCollab();
        rC.setId(roleId);
        rC.setCollab(collabP);
        rC.setRole(role);
        try {
            this.rolesCollabDAO.save((Object)rC);
            tx.commit();
        }
        catch (RuntimeException e) {
            tx.rollback();
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public void update(int statut, int idCollab) throws CollaborateurException {
        if (idCollab == 0) {
            throw new CollaborateurException("vous devez sp\u00e9cifier un collaborateur !");
        }
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        List listRoles = new ArrayList();
        try {
            listRoles = this.rolesCollabDAO.getByIdCollab(idCollab);
            tx.commit();
        }
        catch (RuntimeException e) {
            tx.rollback();
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        if (listRoles == null || listRoles.isEmpty()) {
            this.save(statut, idCollab);
        } else {
            session = HibernateUtil.getSessionFactory().getCurrentSession();
            tx = session.beginTransaction();
            try {
                for (RolesCollab rolesC : listRoles) {
                    this.rolesCollabDAO.remove((Object)rolesC);
                }
                tx.commit();
            }
            catch (RuntimeException e) {
                tx.rollback();
                this.logger.error((Object)e.getMessage(), (Throwable)e);
                throw e;
            }
            this.save(statut, idCollab);
        }
    }

    public void delete(int idCollab) throws CollaborateurException {
        if (idCollab == 0) {
            throw new CollaborateurException("vous devez sp\u00e9cifier un collaborateur !");
        }
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = session.beginTransaction();
        try {
            CollaborateurP collabP = (CollaborateurP)CollaborateurDAO.getInstance().find((Serializable)Integer.valueOf(idCollab));
            if (collabP == null) {
                throw new CollaborateurException("Le collaborateur choisi n'existe pas dans la base !");
            }
            collabP = new CollaborateurP();
            collabP.setIdColl(idCollab);
            List listRoles = this.rolesCollabDAO.getByIdCollab(idCollab);
            if (listRoles != null) {
                for (RolesCollab rolesC : listRoles) {
                    this.rolesCollabDAO.remove((Object)rolesC);
                }
            }
            tx.commit();
        }
        catch (RuntimeException e) {
            tx.rollback();
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public String getRole(int statut) {
        String role = null;
        if (statut == 0) {
            role = "administrateur";
        }
        if (statut == 1) {
            role = "gestionnaire";
        }
        if (statut == 2) {
            role = "chef_de_projet";
        }
        if (statut == 3) {
            role = "collaborateur";
        }
        return role;
    }
}

