/*
 * Decompiled with CFR 0.152.
 */
package org.jeinnov.jeitime.ui.alerte;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.jeinnov.jeitime.api.service.alerte.AlerteManager;
import org.jeinnov.jeitime.api.to.alerte.AlertesTO;
import org.ow2.opensuit.core.validation.LocalizedValidationError;
import org.ow2.opensuit.core.validation.ValidationError;
import org.ow2.opensuit.core.validation.ValidationErrors;

public class AlerteUIBean {
    private AlerteManager alerteManager = AlerteManager.getInstance();
    private int annee;
    private Date dateDeb;
    private Date dateFin;
    private List<AlertesTO> allAlertes = new ArrayList();
    private static int[] ALL_MOIS = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11};
    private int mois;
    private boolean visible = false;

    public void load() {
        Calendar cal = GregorianCalendar.getInstance();
        cal.getTime();
        this.annee = cal.get(1);
    }

    public void afficheAnnee() {
        this.allAlertes = this.alerteManager.getAlertForYear(this.annee);
        this.visible = true;
    }

    public void afficheMois() {
        this.allAlertes = new ArrayList();
        this.allAlertes = this.alerteManager.getAlertForMonth(this.annee, this.mois);
        this.visible = true;
    }

    public void afficheSem() {
        this.allAlertes = new ArrayList();
        this.allAlertes = this.alerteManager.getAlertForWeek(this.dateDeb);
        this.visible = true;
    }

    public void validate() throws ValidationErrors {
        ValidationErrors errors = new ValidationErrors();
        if (this.dateDeb != null && this.dateFin != null && this.dateFin.before(this.dateDeb)) {
            errors.addItemError("alerteBean.dateFin", (ValidationError)new LocalizedValidationError("validation.date"));
        }
        if (errors.hasErrors()) {
            throw errors;
        }
    }

    public static int[] getAllMois() {
        return ALL_MOIS;
    }

    public int getAnnee() {
        return this.annee;
    }

    public void setAnnee(int annee) {
        this.annee = annee;
    }

    public Date getDateDeb() {
        return this.dateDeb;
    }

    public void setDateDeb(Date dateDeb) {
        this.dateDeb = dateDeb;
    }

    public Date getDateFin() {
        return this.dateFin;
    }

    public void setDateFin(Date dateFin) {
        this.dateFin = dateFin;
    }

    public List<AlertesTO> getAllAlertes() {
        return this.allAlertes;
    }

    public void setAllAlertes(List<AlertesTO> allAlertes) {
        this.allAlertes = allAlertes;
    }

    public int getMois() {
        return this.mois;
    }

    public void setMois(int mois) {
        this.mois = mois;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }
}

