/*
 * Decompiled with CFR 0.152.
 */
package org.jeinnov.jeitime.ui.bilan;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import org.jeinnov.jeitime.api.service.bilan.BilanException;
import org.jeinnov.jeitime.api.service.bilan.RecapProjetManager;
import org.jeinnov.jeitime.api.service.collaborateur.CollaborateurManager;
import org.jeinnov.jeitime.api.service.projet.ProjetManager;
import org.jeinnov.jeitime.api.to.bilan.RecapProjetTO;
import org.jeinnov.jeitime.api.to.bilan.SousTotal;
import org.jeinnov.jeitime.api.to.collaborateur.CollaborateurTO;
import org.jeinnov.jeitime.api.to.projet.ProjetTO;
import org.jeinnov.jeitime.api.to.projet.TacheTO;
import org.ow2.opensuit.core.error.IError;
import org.ow2.opensuit.core.error.NonLocalizedError;

public class RecapSuiviProjetUIBean {
    private int[] selectedProjet;
    private List<ProjetTO> allprojet = new ArrayList();
    private List<RecapProjetTO> listRecap = new ArrayList();
    private List<Object> items = new ArrayList();
    private List<CollaborateurTO> collaborateurs = new ArrayList();

    public void load() {
        this.allprojet = ProjetManager.getInstance().getAll();
    }

    public String nomDomaine(ProjetTO p) {
        if (p.getDomaine() == null || p.getDomaine().getNomDomaine() == null) {
            return "";
        }
        return p.getDomaine().getNomDomaine();
    }

    public String nomThema(ProjetTO p) {
        if (p.getThematique() == null || p.getThematique().getNomThema() == null) {
            return "";
        }
        return p.getThematique().getNomThema();
    }

    public void voirTableau() throws IError {
        this.collaborateurs = CollaborateurManager.getInstance().getAll();
        try {
            this.items = RecapProjetManager.getInstance().listTache(this.selectedProjet);
        }
        catch (BilanException e) {
            NonLocalizedError error = new NonLocalizedError("Attention, aucun projet n'est associ\u00e9", e.getMessage(), (Throwable)e);
            error.setType((short)0);
            throw error;
        }
        try {
            this.listRecap = RecapProjetManager.getInstance().creerListRecapSuiviProjet(this.selectedProjet);
        }
        catch (BilanException e) {
            NonLocalizedError error = new NonLocalizedError("Attention, aucun projet n'est associ\u00e9", e.getMessage(), (Throwable)e);
            error.setType((short)0);
            throw error;
        }
    }

    public String getHtmlName(Object item) {
        if (item instanceof String) {
            return "\\html\\<span class=sousTitleTable>" + item + "</span>";
        }
        if (item instanceof Integer) {
            return "Total";
        }
        if (item instanceof SousTotal) {
            return ((SousTotal)item).getNomSousTotal();
        }
        return ((TacheTO)item).getNomtache().getNomTache();
    }

    public String getValue(Object item, CollaborateurTO collab) {
        if (item instanceof String) {
            return null;
        }
        if (item instanceof Integer) {
            return this.itemsInstanceOfInteger(item, collab);
        }
        if (item instanceof SousTotal) {
            return this.itemsInstanceOfSousTotal(item, collab);
        }
        return this.itemsInstanceOfTacheTO(item, collab);
    }

    private String itemsInstanceOfInteger(Object item, CollaborateurTO collab) {
        String nb = "0";
        int idP = (Integer)item;
        double nbht = 0.0;
        for (int i = 0; i < this.listRecap.size(); ++i) {
            if (((RecapProjetTO)this.listRecap.get(i)).getCollab().getIdColl() != collab.getIdColl() || ((RecapProjetTO)this.listRecap.get(i)).getNomProjet().getIdProjet() != idP) continue;
            nbht = ((RecapProjetTO)this.listRecap.get(i)).getNbheure() + nbht;
            DecimalFormat df = new DecimalFormat();
            df.setMaximumFractionDigits(2);
            df.setMinimumFractionDigits(2);
            df.setDecimalSeparatorAlwaysShown(true);
            nb = df.format(nbht);
        }
        return nb;
    }

    private String itemsInstanceOfSousTotal(Object item, CollaborateurTO collab) {
        String nb = "0";
        int idP = ((SousTotal)item).getIdProjet();
        boolean rd = ((SousTotal)item).isRd();
        double nbht = 0.0;
        for (int i = 0; i < this.listRecap.size(); ++i) {
            if (((RecapProjetTO)this.listRecap.get(i)).getCollab().getIdColl() != collab.getIdColl() || ((RecapProjetTO)this.listRecap.get(i)).getNomProjet().getIdProjet() != idP || ((RecapProjetTO)this.listRecap.get(i)).getTache().isEligible() != rd) continue;
            nbht = ((RecapProjetTO)this.listRecap.get(i)).getNbheure() + nbht;
            DecimalFormat df = new DecimalFormat();
            df.setMaximumFractionDigits(2);
            df.setMinimumFractionDigits(2);
            df.setDecimalSeparatorAlwaysShown(true);
            nb = df.format(nbht);
        }
        return nb;
    }

    private String itemsInstanceOfTacheTO(Object item, CollaborateurTO collab) {
        int idT = ((TacheTO)item).getIdTache();
        int idCo = collab.getIdColl();
        String nb = "";
        for (int i = 0; i < this.listRecap.size(); ++i) {
            if (idT != ((RecapProjetTO)this.listRecap.get(i)).getTache().getIdTache() || idCo != ((RecapProjetTO)this.listRecap.get(i)).getCollab().getIdColl()) continue;
            double nbh = ((RecapProjetTO)this.listRecap.get(i)).getNbheure();
            DecimalFormat df = new DecimalFormat();
            df.setMaximumFractionDigits(2);
            df.setMinimumFractionDigits(2);
            df.setDecimalSeparatorAlwaysShown(true);
            nb = df.format(nbh);
        }
        return nb;
    }

    public String getTotal(Object item) {
        double nbh = 0.0;
        String total = "0";
        if (item instanceof String) {
            return null;
        }
        if (item instanceof Integer) {
            total = this.totalInstanceOfInteger(item, nbh);
            return total;
        }
        if (item instanceof SousTotal) {
            total = this.totalInstanceOfSousTotal(item);
            return total;
        }
        total = this.totalInstanceOfTacheTO(item, nbh);
        return total;
    }

    private String totalInstanceOfInteger(Object item, double nbh) {
        for (int i = 0; i < this.listRecap.size(); ++i) {
            int idP = (Integer)item;
            if (idP != ((RecapProjetTO)this.listRecap.get(i)).getNomProjet().getIdProjet()) continue;
            nbh = ((RecapProjetTO)this.listRecap.get(i)).getNbheure() + nbh;
        }
        DecimalFormat df = new DecimalFormat();
        df.setMaximumFractionDigits(2);
        df.setMinimumFractionDigits(2);
        df.setDecimalSeparatorAlwaysShown(true);
        String total = df.format(nbh);
        return total;
    }

    private String totalInstanceOfSousTotal(Object item) {
        int idP = ((SousTotal)item).getIdProjet();
        String totalTmp = null;
        boolean rd = ((SousTotal)item).isRd();
        double nbht = 0.0;
        for (int i = 0; i < this.listRecap.size(); ++i) {
            if (((RecapProjetTO)this.listRecap.get(i)).getNomProjet().getIdProjet() != idP || ((RecapProjetTO)this.listRecap.get(i)).getTache().isEligible() != rd) continue;
            nbht = ((RecapProjetTO)this.listRecap.get(i)).getNbheure() + nbht;
            DecimalFormat df = new DecimalFormat();
            df.setMaximumFractionDigits(2);
            df.setMinimumFractionDigits(2);
            df.setDecimalSeparatorAlwaysShown(true);
            totalTmp = df.format(nbht);
        }
        return totalTmp;
    }

    private String totalInstanceOfTacheTO(Object item, double nbh) {
        int idT = ((TacheTO)item).getIdTache();
        for (int i = 0; i < this.listRecap.size(); ++i) {
            if (idT != ((RecapProjetTO)this.listRecap.get(i)).getTache().getIdTache()) continue;
            nbh = ((RecapProjetTO)this.listRecap.get(i)).getNbheure() + nbh;
        }
        DecimalFormat df = new DecimalFormat();
        df.setMaximumFractionDigits(2);
        df.setMinimumFractionDigits(2);
        df.setDecimalSeparatorAlwaysShown(true);
        String total = df.format(nbh);
        return total;
    }

    public void selectAll() {
        this.selectedProjet = new int[this.allprojet.size()];
        for (int i = 0; i < this.allprojet.size(); ++i) {
            this.selectedProjet[i] = ((ProjetTO)this.allprojet.get(i)).getIdProjet();
        }
    }

    public void deSelectAll() {
        this.selectedProjet = null;
    }

    public int[] getSelectedProjet() {
        return this.selectedProjet;
    }

    public void setSelectedProjet(int[] selectedProjet) {
        this.selectedProjet = selectedProjet;
    }

    public List<ProjetTO> getAllprojet() {
        return this.allprojet;
    }

    public void setAllprojet(List<ProjetTO> allprojet) {
        this.allprojet = allprojet;
    }

    public List<Object> getItems() {
        return this.items;
    }

    public void setItems(List<Object> items) {
        this.items = items;
    }

    public List<CollaborateurTO> getCollaborateurs() {
        return this.collaborateurs;
    }

    public void setCollaborateurs(List<CollaborateurTO> collaborateurs) {
        this.collaborateurs = collaborateurs;
    }

    public List<RecapProjetTO> getListRecap() {
        return this.listRecap;
    }

    public void setListRecap(List<RecapProjetTO> listRecap) {
        this.listRecap = listRecap;
    }
}

