/*
 * Decompiled with CFR 0.152.
 */
package org.jeinnov.jeitime.ui.projet;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.jeinnov.jeitime.api.service.projet.ClientPartManager;
import org.jeinnov.jeitime.api.service.projet.ProjetException;
import org.jeinnov.jeitime.api.to.projet.ClientPartTO;
import org.ow2.opensuit.core.error.IError;
import org.ow2.opensuit.core.error.NonLocalizedError;

public class ClientPartUIBean {
    private ClientPartManager clientPartManager = ClientPartManager.getInstance();
    private int idClientPart;
    private String nomClientPart;
    private String nomContact;
    private String nomService;
    private String commentaire;
    private int type;
    private ClientPartTO selected;
    private List<ClientPartTO> allCliPart;
    private static int[] ALL_TYPES = new int[]{0, 1};

    public void loadAll() {
        this.allCliPart = new ArrayList();
        this.allCliPart = this.clientPartManager.getAll();
    }

    public void create() throws IError {
        ClientPartTO clipart = new ClientPartTO(this.idClientPart, this.nomClientPart, this.nomService, this.nomContact, this.commentaire, this.type);
        try {
            this.clientPartManager.saveOrUpdate(clipart);
        }
        catch (ProjetException e) {
            NonLocalizedError error = new NonLocalizedError("Attention : ", "Une erreur est survenue. Le client/partenaire n'a pas pu \u00eatre sauvegard\u00e9.", (Throwable)e);
            error.setType((short)0);
            throw error;
        }
        this.refresh();
    }

    public void update() throws IError {
        int id = this.selected.getIdClientPart();
        String nom = this.selected.getNomClientPart();
        String nomContactTmp = this.selected.getNomContact();
        String nomServicesTmp = this.nomService;
        String commentaireTmp = this.selected.getCommentaire();
        int typeTmp = this.selected.getType();
        ClientPartTO clipart = new ClientPartTO(id, nom, nomServicesTmp, nomContactTmp, commentaireTmp, typeTmp);
        try {
            this.clientPartManager.saveOrUpdate(clipart);
        }
        catch (ProjetException e) {
            NonLocalizedError error = new NonLocalizedError("Attention : ", "Une erreur est survenue. Le client/partenaire n'a pas pu \u00eatre sauvegard\u00e9.", (Throwable)e);
            error.setType((short)0);
            throw error;
        }
        this.refresh();
    }

    public void delete(HttpServletRequest iRequest) throws IError {
        int id = Integer.parseInt(iRequest.getParameter("ID"));
        try {
            this.clientPartManager.delete(id);
        }
        catch (ProjetException e) {
            NonLocalizedError error = new NonLocalizedError("Attention : ", "Une erreur est survenue. Le client/partenaire n'a pas pu \u00eatre supprim\u00e9.", (Throwable)e);
            error.setType((short)0);
            throw error;
        }
        this.refresh();
    }

    public void cancel() {
        this.selected = null;
    }

    public void refresh() {
        this.nomClientPart = null;
        this.nomContact = null;
        this.nomService = null;
        this.commentaire = null;
        this.allCliPart = new ArrayList();
        this.allCliPart = this.clientPartManager.getAll();
        this.selected = null;
    }

    public void select(HttpServletRequest iRequest) throws IError {
        this.selected = null;
        int id = Integer.parseInt(iRequest.getParameter("ID"));
        try {
            this.selected = this.clientPartManager.get(id);
        }
        catch (ProjetException e) {
            NonLocalizedError error = new NonLocalizedError("Attention : ", "Une erreur est survenue. Le client/partenaire n'a pas pu \u00eatre charg\u00e9.", (Throwable)e);
            error.setType((short)0);
            throw error;
        }
        this.nomService = this.selected.getNomService();
    }

    public boolean isInProject(int id) throws ProjetException {
        boolean verif = this.clientPartManager.isInProject(id);
        return verif;
    }

    public ClientPartTO getSelected() {
        return this.selected;
    }

    public static int[] getAllTypes() {
        return ALL_TYPES;
    }

    public List<ClientPartTO> getAllCliPart() {
        return this.allCliPart;
    }

    public void setAllCliPart(List<ClientPartTO> allCliPart) {
        this.allCliPart = allCliPart;
    }

    public int getIdClientPart() {
        return this.idClientPart;
    }

    public void setIdClientPart(int idClientPart) {
        this.idClientPart = idClientPart;
    }

    public String getNomClientPart() {
        return this.nomClientPart;
    }

    public void setNomClientPart(String nomClientPart) {
        this.nomClientPart = nomClientPart;
    }

    public String getNomContact() {
        return this.nomContact;
    }

    public void setNomContact(String nomContact) {
        this.nomContact = nomContact;
    }

    public String getNomService() {
        return this.nomService;
    }

    public void setNomService(String nomService) {
        this.nomService = nomService;
    }

    public String getCommentaire() {
        return this.commentaire;
    }

    public void setCommentaire(String commentaire) {
        this.commentaire = commentaire;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }
}

