/*
 * Decompiled with CFR 0.152.
 */
package org.jeinnov.jeitime.ui.projet;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.jeinnov.jeitime.api.service.projet.ContratManager;
import org.jeinnov.jeitime.api.service.projet.ProjetException;
import org.jeinnov.jeitime.api.service.projet.ProjetManager;
import org.jeinnov.jeitime.api.service.projet.TacheManager;
import org.jeinnov.jeitime.api.to.projet.ClientPartTO;
import org.jeinnov.jeitime.api.to.projet.DomaineTO;
import org.jeinnov.jeitime.api.to.projet.ProjetTO;
import org.jeinnov.jeitime.api.to.projet.TacheTO;
import org.jeinnov.jeitime.api.to.projet.ThematiqueTO;
import org.ow2.opensuit.core.error.IError;
import org.ow2.opensuit.core.error.NonLocalizedError;

public class ConsultProjetBean {
    private ProjetManager projetManager = ProjetManager.getInstance();
    private int idProjet;
    private String nomProjet;
    private Date dateDebu;
    private Date dateFin;
    private Date dateCloture;
    private Date dateFermeture;
    private String budgeprevu = "0";
    private String tpsprevu = "0";
    private String sousProjet;
    private int idTypPro;
    private String nomTypPro;
    private int idDom;
    private String nomDom;
    private int idThema;
    private String nomThem;
    private List<ClientPartTO> allCliPartSelect = new ArrayList();
    private int idCliPart;
    private int typeCli;
    private List<TacheTO> alltache;
    private ProjetTO projet;
    private int idSousProjet;
    private boolean editable;

    public void search(HttpServletRequest iRequest) throws IError, ProjetException {
        int id = Integer.parseInt(iRequest.getParameter("id"));
        try {
            this.projet = this.projetManager.get(id);
        }
        catch (ProjetException e) {
            NonLocalizedError error = new NonLocalizedError("Attention : ", "Une erreur est survenue, le projet n'a pas pu \u00eatre charg\u00e9", (Throwable)e);
            error.setType((short)0);
            throw error;
        }
        this.allCliPartSelect = ContratManager.getInstance().getClientPartByProjectIdInContrat(id);
        this.idProjet = this.projet.getIdProjet();
        this.nomProjet = this.projet.getNomProjet();
        this.dateDebu = this.projet.getDateDeb();
        this.dateFin = this.projet.getDateFin();
        this.budgeprevu = String.valueOf(this.projet.getBudgeprevu());
        this.tpsprevu = String.valueOf(this.projet.getTpsprevu());
        this.idTypPro = this.projet.getTypeProjet().getIdTypeProj();
        this.nomTypPro = this.projet.getTypeProjet().getNomTypePro();
        ProjetTO proj = this.projet.getProjet();
        if (proj != null) {
            this.idSousProjet = this.projet.getProjet().getIdProjet();
            this.sousProjet = this.projet.getProjet().getNomProjet();
        } else {
            this.idSousProjet = 0;
            this.sousProjet = "Aucun Projet n'est rattach\u00e9";
        }
        ThematiqueTO thema = this.projet.getThematique();
        if (thema != null) {
            this.idThema = this.projet.getThematique().getIdThema();
            this.nomThem = this.projet.getThematique().getNomThema();
        } else {
            this.idThema = 0;
            this.nomThem = "Aucune Th\u00e9matique n'est rattach\u00e9e";
        }
        DomaineTO dom = this.projet.getDomaine();
        if (dom != null) {
            this.idDom = this.projet.getDomaine().getIdDomaine();
            this.nomDom = this.projet.getDomaine().getNomDomaine();
        } else {
            this.idDom = 0;
            this.nomDom = "Aucun Domaine n'est rattach\u00e9";
        }
        this.alltache = TacheManager.getInstance().getAllTacheInProject(id);
        this.calculBudget(this.alltache);
    }

    public void calculBudget(List<TacheTO> alltaches) {
        this.budgeprevu = null;
        this.tpsprevu = null;
        this.alltache = alltaches;
        float budget = 0.0f;
        for (int i = 0; i < this.alltache.size(); ++i) {
            budget += ((TacheTO)this.alltache.get(i)).getBudgetprevu();
        }
        this.budgeprevu = String.valueOf(budget);
        float tmps = 0.0f;
        for (int i = 0; i < this.alltache.size(); ++i) {
            tmps += ((TacheTO)this.alltache.get(i)).getTpsprevu();
        }
        this.tpsprevu = String.valueOf(tmps);
    }

    public ProjetManager getProjetManager() {
        return this.projetManager;
    }

    public void setProjetManager(ProjetManager projetManager) {
        this.projetManager = projetManager;
    }

    public int getIdProjet() {
        return this.idProjet;
    }

    public void setIdProjet(int idProjet) {
        this.idProjet = idProjet;
    }

    public String getNomProjet() {
        return this.nomProjet;
    }

    public void setNomProjet(String nomProjet) {
        this.nomProjet = nomProjet;
    }

    public Date getDateDebu() {
        return this.dateDebu;
    }

    public void setDateDebu(Date dateDebu) {
        this.dateDebu = dateDebu;
    }

    public Date getDateFin() {
        return this.dateFin;
    }

    public void setDateFin(Date dateFin) {
        this.dateFin = dateFin;
    }

    public Date getDateCloture() {
        return this.dateCloture;
    }

    public void setDateCloture(Date dateCloture) {
        this.dateCloture = dateCloture;
    }

    public Date getDateFermeture() {
        return this.dateFermeture;
    }

    public void setDateFermeture(Date dateFermeture) {
        this.dateFermeture = dateFermeture;
    }

    public String getBudgeprevu() {
        return this.budgeprevu;
    }

    public void setBudgeprevu(String budgeprevu) {
        this.budgeprevu = budgeprevu;
    }

    public String getTpsprevu() {
        return this.tpsprevu;
    }

    public void setTpsprevu(String tpsprevu) {
        this.tpsprevu = tpsprevu;
    }

    public String getSousProjet() {
        return this.sousProjet;
    }

    public void setSousProjet(String sousProjet) {
        this.sousProjet = sousProjet;
    }

    public int getIdTypPro() {
        return this.idTypPro;
    }

    public void setIdTypPro(int idTypPro) {
        this.idTypPro = idTypPro;
    }

    public String getNomTypPro() {
        return this.nomTypPro;
    }

    public void setNomTypPro(String nomTypPro) {
        this.nomTypPro = nomTypPro;
    }

    public int getIdDom() {
        return this.idDom;
    }

    public void setIdDom(int idDom) {
        this.idDom = idDom;
    }

    public String getNomDom() {
        return this.nomDom;
    }

    public void setNomDom(String nomDom) {
        this.nomDom = nomDom;
    }

    public int getIdThema() {
        return this.idThema;
    }

    public void setIdThema(int idThema) {
        this.idThema = idThema;
    }

    public String getNomThem() {
        return this.nomThem;
    }

    public void setNomThem(String nomThem) {
        this.nomThem = nomThem;
    }

    public List<ClientPartTO> getAllCliPartSelect() {
        return this.allCliPartSelect;
    }

    public void setAllCliPartSelect(List<ClientPartTO> allCliPartSelect) {
        this.allCliPartSelect = allCliPartSelect;
    }

    public int getIdCliPart() {
        return this.idCliPart;
    }

    public void setIdCliPart(int idCliPart) {
        this.idCliPart = idCliPart;
    }

    public int getTypeCli() {
        return this.typeCli;
    }

    public void setTypeCli(int typeCli) {
        this.typeCli = typeCli;
    }

    public List<TacheTO> getAlltache() {
        return this.alltache;
    }

    public void setAlltache(List<TacheTO> alltache) {
        this.alltache = alltache;
    }

    public ProjetTO getProjet() {
        return this.projet;
    }

    public void setProjet(ProjetTO projet) {
        this.projet = projet;
    }

    public int getIdSousProjet() {
        return this.idSousProjet;
    }

    public void setIdSousProjet(int idSousProjet) {
        this.idSousProjet = idSousProjet;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }
}

