/*
 * Decompiled with CFR 0.152.
 */
package org.jeinnov.jeitime.ui.projet;

import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.jeinnov.jeitime.api.service.projet.NomTacheManager;
import org.jeinnov.jeitime.api.service.projet.ProjetException;
import org.jeinnov.jeitime.api.service.projet.TacheManager;
import org.jeinnov.jeitime.api.service.projet.TypeTacheManager;
import org.jeinnov.jeitime.api.to.projet.NomTacheTO;
import org.jeinnov.jeitime.api.to.projet.ProjetTO;
import org.jeinnov.jeitime.api.to.projet.TacheTO;
import org.jeinnov.jeitime.api.to.projet.TypeTacheTO;
import org.ow2.opensuit.core.error.IError;
import org.ow2.opensuit.core.error.NonLocalizedError;

public class TacheUIBean {
    private final Logger logger = Logger.getLogger(this.getClass());
    private TypeTacheManager typeTacheManager = TypeTacheManager.getInstance();
    private NomTacheManager nomTacheManager = NomTacheManager.getInstance();
    private TacheManager tacheManager = TacheManager.getInstance();
    private int idTache;
    private String budgetprevu = "0";
    private String tpsprevu = "0";
    private int priorite;
    private boolean eligible;
    private boolean modif = false;
    private boolean visible = true;
    private TypeTacheTO type;
    private List<TypeTacheTO> alltype;
    private int idType;
    private String nomType;
    private NomTacheTO nom;
    private List<NomTacheTO> allnom;
    private int idNom;
    private String nomTache;
    private TacheTO tache;
    private List<TacheTO> alltache;
    private int[] selectedTache;
    private static int[] ALL_PRIORITE = new int[]{0, 1, 2};

    public void load(HttpServletRequest iRequest) throws IError {
        this.alltype = new ArrayList();
        TypeTacheTO aucunType = new TypeTacheTO();
        aucunType.setIdTypTach(0);
        aucunType.setNomTypTach("aucun \u00e9l\u00e9ment s\u00e9lectionn\u00e9");
        this.alltype = this.typeTacheManager.getAll();
        this.alltype.add(0, aucunType);
        this.idType = 0;
        this.budgetprevu = "0";
        this.tpsprevu = "0";
        int id = Integer.parseInt(iRequest.getParameter("id"));
        try {
            this.alltache = this.tacheManager.getAllTacheInProject(id);
        }
        catch (ProjetException e) {
            NonLocalizedError error = new NonLocalizedError("Attention : ", "Une erreur est survenue", (Throwable)e);
            error.setType((short)0);
            throw error;
        }
        this.visible = true;
    }

    public void select(HttpServletRequest iRequest) throws ProjetException {
        this.idTache = Integer.parseInt(iRequest.getParameter("ID"));
        this.tache = this.tacheManager.get(this.idTache);
        this.idType = this.tache.getNomtache().getTypeTache().getIdTypTach();
        this.idNom = this.tache.getNomtache().getIdNomTache();
        this.budgetprevu = String.valueOf(this.tache.getBudgetprevu());
        this.tpsprevu = String.valueOf(this.tache.getTpsprevu());
        this.priorite = this.tache.getPriorite();
        this.eligible = this.tache.isEligible();
        this.allnom = this.nomTacheManager.getAllByIdTypeTache(this.idType);
        this.visible = false;
        this.modif = true;
    }

    public void createOrUpdate(int idProjet) throws IError, ProjetException {
        if (this.idTache != 0) {
            this.modif = false;
            this.visible = true;
        }
        this.tache = null;
        NumberFormat nf = NumberFormat.getInstance(Locale.FRANCE);
        float budget = 0.0f;
        float tmps = 0.0f;
        try {
            budget = Float.parseFloat(this.budgetprevu);
        }
        catch (Exception e) {
            try {
                budget = nf.parse(this.budgetprevu).floatValue();
            }
            catch (ParseException pe) {
                this.logger.error((Object)pe.getMessage(), (Throwable)pe);
            }
        }
        try {
            tmps = Float.parseFloat(this.tpsprevu);
        }
        catch (Exception e) {
            try {
                tmps = nf.parse(this.tpsprevu).floatValue();
            }
            catch (ParseException pe) {
                this.logger.error((Object)pe.getMessage(), (Throwable)pe);
            }
        }
        this.type = this.typeTacheManager.get(this.idType);
        this.nomType = this.type.getNomTypTach();
        this.type = new TypeTacheTO(this.idType, this.nomType);
        try {
            this.nom = this.nomTacheManager.get(this.idNom);
        }
        catch (ProjetException e) {
            NonLocalizedError error = new NonLocalizedError("Attention : ", "Une erreur est survenue. Aucun nom de t\u00e2che n'est sp\u00e9cifi\u00e9", (Throwable)e);
            error.setType((short)0);
            throw error;
        }
        this.nomTache = this.nom.getNomTache();
        this.nom = new NomTacheTO(this.idNom, this.nomTache, this.type);
        ProjetTO projetTO = new ProjetTO();
        projetTO.setIdProjet(idProjet);
        this.tache = new TacheTO(this.idTache, this.nom, budget, tmps, this.priorite, this.eligible, projetTO);
        try {
            this.tacheManager.saveOrUpdate(this.tache);
        }
        catch (ProjetException e) {
            NonLocalizedError error = new NonLocalizedError("Attention : ", "Une erreur est survenue la t\u00e2che n'a pas \u00e9t\u00e9 sauvegard\u00e9. Cette t\u00e2che existe peut-\u00eatre d\u00e9j\u00e0 pour ce projet.", (Throwable)e);
            error.setType((short)0);
            throw error;
        }
        try {
            this.alltache = this.tacheManager.getAllTacheInProject(idProjet);
        }
        catch (ProjetException e) {
            NonLocalizedError error = new NonLocalizedError("Attention : ", "Une erreur est survenue, lors de la r\u00e9cup\u00e9ration des t\u00e2ches du projet", (Throwable)e);
            error.setType((short)0);
            throw error;
        }
        this.cancel();
    }

    public void cancel() {
        this.idType = 0;
        this.allnom = null;
        this.modif = false;
        this.visible = true;
        this.idTache = 0;
        this.tache = null;
        this.budgetprevu = "0";
        this.tpsprevu = "0";
        this.priorite = 0;
        this.eligible = false;
    }

    public void selectNomtache(int idTyp) throws ProjetException {
        this.allnom = idTyp == 0 ? null : this.nomTacheManager.getAllByIdTypeTache(idTyp);
        if (this.allnom == null || this.allnom.isEmpty()) {
            this.allnom = null;
        }
    }

    public void deselectTache(HttpServletRequest iRequest) throws IError {
        int id = Integer.parseInt(iRequest.getParameter("id"));
        for (int i = 0; i < this.alltache.size(); ++i) {
            if (((TacheTO)this.alltache.get(i)).getIdTache() != id) continue;
            this.alltache.remove(i);
            break;
        }
        try {
            this.tacheManager.delete(id);
        }
        catch (ProjetException e) {
            NonLocalizedError error = new NonLocalizedError("Attention : ", "Une erreur est survenue", (Throwable)e);
            error.setType((short)0);
            throw error;
        }
    }

    public boolean isInLienTach(int id) throws ProjetException {
        boolean verif = this.tacheManager.isInLienTachUtil(id);
        return verif;
    }

    public void selectAll() {
        this.selectedTache = new int[this.alltache.size()];
        for (int i = 0; i < this.alltache.size(); ++i) {
            this.selectedTache[i] = ((TacheTO)this.alltache.get(i)).getIdTache();
        }
    }

    public void deSelectAll() {
        this.selectedTache = null;
    }

    public int getIdTache() {
        return this.idTache;
    }

    public void setIdTache(int idTache) {
        this.idTache = idTache;
    }

    public String getBudgetprevu() {
        return this.budgetprevu;
    }

    public void setBudgetprevu(String budgetprevu) {
        this.budgetprevu = budgetprevu;
    }

    public String getTpsprevu() {
        return this.tpsprevu;
    }

    public void setTpsprevu(String tpsprevu) {
        this.tpsprevu = tpsprevu;
    }

    public int getPriorite() {
        return this.priorite;
    }

    public void setPriorite(int priorite) {
        this.priorite = priorite;
    }

    public boolean isEligible() {
        return this.eligible;
    }

    public void setEligible(boolean eligible) {
        this.eligible = eligible;
    }

    public TypeTacheTO getType() {
        return this.type;
    }

    public void setType(TypeTacheTO type) {
        this.type = type;
    }

    public List<TypeTacheTO> getAlltype() {
        return this.alltype;
    }

    public void setAlltype(List<TypeTacheTO> alltype) {
        this.alltype = alltype;
    }

    public int getIdType() {
        return this.idType;
    }

    public void setIdType(int idType) {
        this.idType = idType;
    }

    public NomTacheTO getNom() {
        return this.nom;
    }

    public void setNom(NomTacheTO nom) {
        this.nom = nom;
    }

    public List<NomTacheTO> getAllnom() {
        return this.allnom;
    }

    public void setAllnom(List<NomTacheTO> allnom) {
        this.allnom = allnom;
    }

    public int getIdNom() {
        return this.idNom;
    }

    public void setIdNom(int idNom) {
        this.idNom = idNom;
    }

    public static int[] getAllPriorite() {
        return ALL_PRIORITE;
    }

    public TacheTO getTache() {
        return this.tache;
    }

    public void setTache(TacheTO tache) {
        this.tache = tache;
    }

    public int[] getSelectedTache() {
        return this.selectedTache;
    }

    public void setSelectedTache(int[] selectedTache) {
        this.selectedTache = selectedTache;
    }

    public List<TacheTO> getAlltache() {
        return this.alltache;
    }

    public void setAlltache(List<TacheTO> alltache) {
        this.alltache = alltache;
    }

    public boolean isModif() {
        return this.modif;
    }

    public void setModif(boolean modif) {
        this.modif = modif;
    }

    public boolean isVisible() {
        return this.visible;
    }
}

