/*
 * Decompiled with CFR 0.152.
 */
package org.jeinnov.jeitime.ws;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import javax.jws.WebService;
import org.apache.log4j.Logger;
import org.hibernate.classic.Session;
import org.hibernate.dialect.Dialect;
import org.hibernate.jdbc.Work;
import org.hibernate.tool.hbm2ddl.DatabaseMetadata;
import org.jeinnov.jeitime.ws.DatabaseManager;
import org.jeinnov.jeitime.ws.HibernateUtil;

@WebService
public class DatabaseManagerImpl
implements DatabaseManager {
    private final Logger logger = Logger.getLogger(this.getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDatabaseSchema() throws Exception {
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        session.beginTransaction();
        try {
            session.doWork(new Work(){

                public void execute(Connection con) throws SQLException {
                    Dialect dialect = Dialect.getDialect((Properties)HibernateUtil.getConfiguration().getProperties());
                    DatabaseMetadata metadata = new DatabaseMetadata(con, dialect);
                    String[] sql = HibernateUtil.getConfiguration().generateSchemaUpdateScript(dialect, metadata);
                    DatabaseManagerImpl.this.executeSchemaScript(con, sql);
                }
            });
        }
        finally {
            session.getTransaction().commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dropDatabaseSchema() throws Exception {
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        session.beginTransaction();
        try {
            session.doWork(new Work(){

                public void execute(Connection con) throws SQLException {
                    Dialect dialect = Dialect.getDialect((Properties)HibernateUtil.getConfiguration().getProperties());
                    String[] sql = HibernateUtil.getConfiguration().generateDropSchemaScript(dialect);
                    DatabaseManagerImpl.this.executeSchemaScript(con, sql);
                }
            });
        }
        finally {
            session.getTransaction().commit();
        }
    }

    @Override
    public void initUserAndRole() {
        this.createRole();
        this.createUser();
        this.createRoleForUser();
    }

    private void createRole() {
        String querySelect = "select * from ROLES r where r.roles ='administrateur' ";
        String queryInsert = "insert into ROLES (roles) values ('administrateur');";
        this.createDataInDatabase(querySelect, queryInsert);
        querySelect = "select * from ROLES r where r.roles ='collaborateur' ";
        queryInsert = "insert into ROLES (roles) values ('collaborateur');";
        this.createDataInDatabase(querySelect, queryInsert);
        querySelect = "select * from ROLES r where r.roles ='chef_de_projet'";
        queryInsert = "insert into ROLES (roles) values ('chef_de_projet');";
        this.createDataInDatabase(querySelect, queryInsert);
        querySelect = "select * from ROLES r where r.roles ='gestionnaire'  ";
        queryInsert = "insert into ROLES (roles) values ('gestionnaire');";
        this.createDataInDatabase(querySelect, queryInsert);
    }

    private void createUser() {
        String querySelect = "select * from COLLABORATEUR c where c.login ='admin'";
        String queryInsert = "insert into COLLABORATEUR (CHARGEANN,CONTRAT,LOGIN,NBHEURANN,NBHEUREHEB,NBHEURJEUDI,NBHEURLUNDI,NBHEURMARDI,NBHEUREMEN,NBHEURMERCREDI,NBHEURVENDREDI,NOMCOLL,PASSWORD,PRENOMCOLL,SALAIRANN,STATUT) values (0,0,'admin',0,0,0,0,0,0,0,0,'admin','21232f297a57a5a743894a0e4a801fc3','admin',0,0);";
        this.createDataInDatabase(querySelect, queryInsert);
    }

    private void createRoleForUser() {
        String querySelect = "select * from ROLECOLLAB  where idcoll =1 ";
        String queryInsert = "insert into ROLECOLLAB (IDCOLL,ROLES) values (1,'administrateur');";
        this.createDataInDatabase(querySelect, queryInsert);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createDataInDatabase(final String querySelect, final String queryInsert) {
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        session.beginTransaction();
        try {
            session.doWork(new Work(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void execute(Connection con) throws SQLException {
                    Statement stt = con.createStatement(1004, 1008);
                    try {
                        ResultSet rs = stt.executeQuery(querySelect);
                        if (!rs.first()) {
                            stt.executeUpdate(queryInsert);
                        }
                    }
                    catch (RuntimeException e) {
                        DatabaseManagerImpl.this.logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                    finally {
                        con.commit();
                        stt.close();
                    }
                }
            });
        }
        finally {
            session.getTransaction().commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeSchemaScript(Connection con, String[] sql) throws SQLException {
        if (sql != null && sql.length > 0) {
            boolean oldAutoCommit = con.getAutoCommit();
            if (!oldAutoCommit) {
                con.setAutoCommit(true);
            }
            try {
                Statement stmt = con.createStatement();
                try {
                    for (String sqlStmt : sql) {
                        this.executeSchemaStatement(stmt, sqlStmt);
                    }
                }
                finally {
                    stmt.close();
                }
            }
            finally {
                if (!oldAutoCommit) {
                    con.setAutoCommit(false);
                }
            }
        }
    }

    protected void executeSchemaStatement(Statement stmt, String sql) throws SQLException {
        try {
            stmt.executeUpdate(sql);
        }
        catch (SQLException ex) {
            this.logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }
}

