/*
 * Decompiled with CFR 0.152.
 */
package org.choreos.services;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.jws.WebParam;
import javax.jws.WebService;
import org.choreos.services.DemoParticipant;
import org.choreos.services.client.airline.AirlineService;
import org.choreos.services.client.airport.AirportService;
import org.choreos.services.client.airport.AmenityType;
import org.choreos.services.client.groundtransportationcompany.BookingOrder;
import org.choreos.services.client.groundtransportationcompany.GroundTransportationCompanyService;
import org.choreos.services.client.hotel.HotelService;
import org.choreos.services.client.hotel.ScenarioException_Exception;
import org.choreos.services.client.standandgatemanagement.StandandgatemanagementService;
import org.choreos.services.client.travelagency.Request;
import org.choreos.services.client.travelagency.TravelAgencyService;
import org.choreos.services.client.weatherforecastservice.GeographicalArea;
import org.choreos.services.client.weatherforecastservice.Weather;
import org.choreos.services.client.weatherforecastservice.WeatherForecastServiceService;
import org.choreos.services.data.AvailableAmenity;
import org.choreos.services.data.BookingReceipt;
import org.choreos.services.exceptions.ScenarioException;
import org.choreos.services.interfaces.BookAmenitySink;
import org.choreos.services.interfaces.RequestAmenitiesSink;
import org.choreos.services.interfaces.WarnUnexpectedArrival;

@WebService
public class AirlineGroundStaffMID
extends DemoParticipant
implements BookAmenitySink,
RequestAmenitiesSink,
WarnUnexpectedArrival {
    private int nbBookingReceiptCalls = 0;
    private int nbAmeniyReceiptCalls = 0;
    private boolean keepForTheNight = false;

    @Override
    public void putBookingReceipt(BookingReceipt bookingReceipt) throws ScenarioException {
        System.out.println(this.id + ".putBookingReceipt() called");
        ++this.nbBookingReceiptCalls;
    }

    @Override
    public void putAmenity(AvailableAmenity availableAmenity) throws ScenarioException {
        System.out.println(this.id + ".putAmenity() called");
        ++this.nbAmeniyReceiptCalls;
        if (this.keepForTheNight) {
            PutAmenityThread t = new PutAmenityThread(1000L);
            t.start();
        }
    }

    @Override
    public void warnArrival(@WebParam(name="flightNumber") String flightNumber, @WebParam(name="passengers") List<String> passengers) throws ScenarioException {
        System.out.println(this.id + ".warnArrival() called");
        try {
            WarnThread t = new WarnThread(2000L, flightNumber, passengers);
            t.start();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new ScenarioException();
        }
    }

    public int getNbBookingReceiptCalls() {
        return this.nbBookingReceiptCalls;
    }

    public void setNbBookingReceiptCalls(int nbBookingReceiptCalls) {
        this.nbBookingReceiptCalls = nbBookingReceiptCalls;
    }

    public int getNbAmeniyReceiptCalls() {
        return this.nbAmeniyReceiptCalls;
    }

    public class RequestAmenitiesAirport
    extends Thread {
        private AirportService as;

        public RequestAmenitiesAirport() throws MalformedURLException {
            this.as = new AirportService(new URL((String)AirlineGroundStaffMID.this.invocationAddresses.get("airport") + "?wsdl"));
        }

        @Override
        public void run() {
            ArrayList<AmenityType> amenities = new ArrayList<AmenityType>();
            AmenityType at1 = new AmenityType();
            at1.setTypeName("at1");
            amenities.add(at1);
            try {
                this.as.getAirportPort().request(amenities);
            }
            catch (org.choreos.services.client.airport.ScenarioException_Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e.fillInStackTrace());
            }
        }
    }

    public class RequestAmenitiesStandAndGateManagement
    extends Thread {
        private StandandgatemanagementService as;

        public RequestAmenitiesStandAndGateManagement() throws MalformedURLException {
            this.as = new StandandgatemanagementService(new URL((String)AirlineGroundStaffMID.this.invocationAddresses.get("standandgatemanagement") + "?wsdl"));
        }

        @Override
        public void run() {
            ArrayList<org.choreos.services.client.standandgatemanagement.AmenityType> amenities = new ArrayList<org.choreos.services.client.standandgatemanagement.AmenityType>();
            org.choreos.services.client.standandgatemanagement.AmenityType at1 = new org.choreos.services.client.standandgatemanagement.AmenityType();
            at1.setTypeName("at1");
            amenities.add(at1);
            try {
                this.as.getStandandgatemanagementPort().request(amenities);
            }
            catch (org.choreos.services.client.standandgatemanagement.ScenarioException_Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e.fillInStackTrace());
            }
        }
    }

    public class RequestAmenitiesAirlineGroundStaffMID
    extends Thread {
        private AirlineService as;

        public RequestAmenitiesAirlineGroundStaffMID() throws MalformedURLException {
            this.as = new AirlineService(new URL((String)AirlineGroundStaffMID.this.invocationAddresses.get("airline") + "?wsdl"));
        }

        @Override
        public void run() {
            ArrayList<org.choreos.services.client.airline.AmenityType> amenities = new ArrayList<org.choreos.services.client.airline.AmenityType>();
            org.choreos.services.client.airline.AmenityType at = new org.choreos.services.client.airline.AmenityType();
            at.setTypeName("at1");
            amenities.add(at);
            try {
                this.as.getAirlinePort().request(amenities);
            }
            catch (org.choreos.services.client.airline.ScenarioException_Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e.fillInStackTrace());
            }
        }
    }

    public class PutAmenityThread
    extends Thread {
        private long beginSleep;

        public PutAmenityThread(long beginSleep) {
            this.beginSleep = beginSleep;
        }

        @Override
        public void run() {
            try {
                Thread.sleep(this.beginSleep);
                HotelService hotel = new HotelService(new URL((String)AirlineGroundStaffMID.this.invocationAddresses.get("hotel") + "?wsdl"));
                org.choreos.services.client.hotel.BookingOrder order = new org.choreos.services.client.hotel.BookingOrder();
                for (int i = 0; i < 3; ++i) {
                    String hotelBookResponse = hotel.getHotelPort().book(order);
                    System.out.println("Hotel book response : " + hotelBookResponse);
                }
                GroundTransportationCompanyService transport = new GroundTransportationCompanyService(new URL((String)AirlineGroundStaffMID.this.invocationAddresses.get("groundtransportationcompany") + "?wsdl"));
                String transportBookResponse = transport.getGroundTransportationCompanyPort().book(new BookingOrder());
                System.out.println("Ground transportation response : " + transportBookResponse);
            }
            catch (InterruptedException e) {
                throw new RuntimeException();
            }
            catch (MalformedURLException e) {
                throw new RuntimeException();
            }
            catch (ScenarioException_Exception e) {
                throw new RuntimeException();
            }
            catch (org.choreos.services.client.groundtransportationcompany.ScenarioException_Exception e) {
                throw new RuntimeException();
            }
        }
    }

    public class WarnThread
    extends Thread {
        private long beginSleep;
        private String flightNumber;
        private List<String> passengers;

        public WarnThread(long beginSleep, String flightNumber, List<String> passengers) {
            this.beginSleep = beginSleep;
            this.flightNumber = flightNumber;
            this.passengers = passengers;
        }

        @Override
        public void run() {
            try {
                Thread.sleep(this.beginSleep);
                TravelAgencyService ts = new TravelAgencyService(new URL((String)AirlineGroundStaffMID.this.invocationAddresses.get("travelagency") + "?wsdl"));
                for (int i = 0; i < 3; ++i) {
                    ts.getTravelAgencyPort().warnArrival(this.flightNumber, this.passengers);
                }
                WeatherForecastServiceService weather = new WeatherForecastServiceService(new URL((String)AirlineGroundStaffMID.this.invocationAddresses.get("weatherforecastservice") + "?wsdl"));
                GeographicalArea where = new GeographicalArea();
                Weather wResult = weather.getWeatherForecastServicePort().getWeatherAt(null, where);
                int temp = 0;
                int humidity = 0;
                if (wResult != null) {
                    temp = wResult.getTemperatureC();
                    humidity = wResult.getHumidityPerc();
                }
                System.out.println("Temperature (C) : " + temp);
                System.out.println("Humidity (%) : " + humidity);
                if (humidity > 70 && temp < 15) {
                    AirlineGroundStaffMID.this.keepForTheNight = true;
                    System.out.println("<+> Keep passengers for the night.");
                    Request reqHotels = new Request();
                    ArrayList<org.choreos.services.client.travelagency.AmenityType> amenities = new ArrayList<org.choreos.services.client.travelagency.AmenityType>();
                    org.choreos.services.client.travelagency.AmenityType at1 = new org.choreos.services.client.travelagency.AmenityType();
                    at1.setTypeName("amenity1");
                    amenities.add(at1);
                    org.choreos.services.client.travelagency.AmenityType at2 = new org.choreos.services.client.travelagency.AmenityType();
                    at2.setTypeName("amenity2");
                    amenities.add(at2);
                    for (int i = 0; i < 3; ++i) {
                        String reqResponse = ts.getTravelAgencyPort().request(amenities);
                        System.out.println("Req response : " + reqResponse);
                    }
                } else {
                    System.out.println("<+> Put passengers in transit.");
                    RequestAmenitiesAirlineGroundStaffMID r1 = new RequestAmenitiesAirlineGroundStaffMID();
                    RequestAmenitiesStandAndGateManagement r2 = new RequestAmenitiesStandAndGateManagement();
                    RequestAmenitiesAirport r3 = new RequestAmenitiesAirport();
                    r1.start();
                    r2.start();
                    r3.start();
                }
            }
            catch (org.choreos.services.client.travelagency.ScenarioException_Exception e) {
                throw new RuntimeException();
            }
            catch (org.choreos.services.client.weatherforecastservice.ScenarioException_Exception e) {
                throw new RuntimeException();
            }
            catch (MalformedURLException e) {
                throw new RuntimeException();
            }
            catch (InterruptedException e) {
                throw new RuntimeException();
            }
        }
    }
}

