/*
 * Decompiled with CFR 0.152.
 */
package org.choreos.services.backends.airline;

import java.io.IOException;
import org.choreos.services.Airline;
import org.choreos.services.backends.airline.WarnDelegate;
import org.ws4d.java.DPWSFramework;
import org.ws4d.java.client.DefaultClient;
import org.ws4d.java.communication.CommunicationBinding;
import org.ws4d.java.communication.HTTPBinding;
import org.ws4d.java.communication.TimeoutException;
import org.ws4d.java.communication.connection.ip.IPAddress;
import org.ws4d.java.service.DefaultDevice;
import org.ws4d.java.service.DefaultService;
import org.ws4d.java.service.InvocationException;
import org.ws4d.java.service.InvokeDelegate;
import org.ws4d.java.service.LocalService;
import org.ws4d.java.service.Operation;
import org.ws4d.java.service.OperationStub;
import org.ws4d.java.service.Service;
import org.ws4d.java.service.parameter.ParameterValue;
import org.ws4d.java.service.reference.ServiceReference;
import org.ws4d.java.structures.Iterator;
import org.ws4d.java.types.EndpointReference;
import org.ws4d.java.types.QName;
import org.ws4d.java.types.URI;
import org.ws4d.java.util.Log;
import org.ws4d.java.util.ParameterUtil;

public class AirTrafficEventingClient
extends DefaultService {
    public static final String NAMESPACE = "http://services.choreos.org/backends/AirTrafficEventingClient/";
    public static final String NAME_SERVICE = "AirTrafficEventingClient";
    public static final int port = 12317;
    protected DefaultDevice device;

    protected AirTrafficEventingClient(Airline airline, String myIPAddress, String XSBIPAddress) throws IOException, TimeoutException, InvocationException {
        super(-1);
        String urlResolver = "http://" + XSBIPAddress + ":" + 12320 + "/" + "AirTrafficEventingClientResolver";
        EndpointReference epr = new EndpointReference(new URI(urlResolver));
        DefaultClient client = new DefaultClient();
        ServiceReference servRef = client.getServiceReference(epr, "DPWS");
        Service serviceProxy = servRef.getService();
        Operation op = serviceProxy.getAnyOperation(new QName("lateBinding", NAMESPACE), "resolve");
        ParameterValue input = op.createInputValue();
        String myUrl = "http://" + myIPAddress + ":" + 12317 + "/" + NAME_SERVICE;
        ParameterUtil.setString((ParameterValue)input, (String)"address", (String)myUrl);
        op.invoke(input);
        this.setServiceId(new URI(NAMESPACE, "/" + NAME_SERVICE));
        HTTPBinding serviceBinding = new HTTPBinding(new IPAddress(myIPAddress), 12317, NAME_SERVICE);
        this.addBinding((CommunicationBinding)serviceBinding);
        this.setServiceId(new URI(NAMESPACE, "/AirTrafficEventingClient"));
        this.defineService(airline);
        HTTPBinding deviceBinding = new HTTPBinding(new IPAddress(myIPAddress), 12317, "AirTrafficEventingDevice");
        this.device = new DefaultDevice(-1);
        this.device.addBinding((CommunicationBinding)deviceBinding);
        this.device.addService((LocalService)this);
    }

    protected void defineService(Airline airline) throws IOException {
        this.define(new URI("local:/backends/AirTrafficEventingClient.wsdl"));
        Iterator iter = this.getOperations();
        while (iter.hasNext()) {
            OperationStub currentOp = (OperationStub)iter.next();
            String name = currentOp.getName();
            if (!name.equals("WarnReroute")) continue;
            currentOp.setDelegate((InvokeDelegate)new WarnDelegate(airline));
        }
    }

    public void startAirTrafficEventing() throws IOException {
        this.device.start();
    }

    public void stopAirTrafficEventing() throws IOException {
        this.device.stop();
    }

    public static AirTrafficEventingClient newInstance(Airline airline, String myIPAddress, String XSBIPAddress) throws IOException, TimeoutException, InvocationException {
        DPWSFramework.start((String[])new String[0]);
        Log.setLogLevel((int)3);
        return new AirTrafficEventingClient(airline, myIPAddress, XSBIPAddress);
    }
}

