/*
 * Decompiled with CFR 0.152.
 */
package org.choreos.services.backends.hotel;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.rmi.MarshalledObject;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.ExportException;
import java.util.ArrayList;
import net.jini.core.entry.Entry;
import net.jini.core.entry.UnusableEntryException;
import net.jini.core.event.RemoteEvent;
import net.jini.core.event.RemoteEventListener;
import net.jini.core.event.UnknownEventException;
import net.jini.core.transaction.TransactionException;
import net.jini.jeri.BasicILFactory;
import net.jini.jeri.BasicJeriExporter;
import net.jini.jeri.InvocationLayerFactory;
import net.jini.jeri.ServerEndpoint;
import net.jini.jeri.tcp.TcpServerEndpoint;
import net.jini.space.JavaSpace05;
import net.jini.space.MatchSet;
import org.choreos.services.backends.hotel.JavaspaceFinder;
import org.choreos.services.backends.hotel.RoomState;

public class HotelRoomPool
implements Serializable,
Runnable {
    protected transient JavaSpace05 space;
    protected transient boolean running = true;

    public HotelRoomPool(boolean async) throws Exception {
        JavaspaceFinder finder = new JavaspaceFinder();
        this.space = finder.searchJavaspace("jini://127.0.0.1");
        if (async) {
            RoomState roomTemplate = new RoomState();
            RoomPoolListener listener = new RoomPoolListener();
            this.space.notify((Entry)roomTemplate, null, listener.getTheStub(), Long.MAX_VALUE, new MarshalledObject<String>("roomPool"));
        }
    }

    @Override
    public void run() {
        while (this.running) {
            try {
                this.getRoomStates();
                Thread.currentThread();
                Thread.sleep(4000L);
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
            catch (UnusableEntryException e) {
                e.printStackTrace();
            }
            catch (TransactionException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public Thread startRoomPool() {
        Thread th = new Thread(this);
        th.start();
        return th;
    }

    public void stopRoomPool() {
        this.running = false;
    }

    public void getRoomStates() throws RemoteException, UnusableEntryException, TransactionException, InterruptedException {
        System.out.println("Room pool state:");
        RoomState roomTemplate = new RoomState();
        ArrayList<RoomState> entries = new ArrayList<RoomState>();
        entries.add(roomTemplate);
        MatchSet output = this.space.contents(entries, null, Long.MAX_VALUE, Long.MAX_VALUE);
        RoomState result = (RoomState)output.next();
        while (result != null) {
            System.out.println("-> Room " + result.getNumRoom() + " is reserved");
            result = (RoomState)output.next();
        }
    }

    public JavaSpace05 getSpace() {
        return this.space;
    }

    public static void main(String[] args) {
        try {
            HotelRoomPool pool = new HotelRoomPool(false);
            pool.startRoomPool();
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
            String line = reader.readLine();
            while (!line.equals("quit")) {
                line = reader.readLine();
            }
            pool.stopRoomPool();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected class RoomPoolListener
    implements RemoteEventListener {
        private RemoteEventListener theStub;
        private String ID;

        public RoomPoolListener() throws ExportException {
            BasicJeriExporter mydefaultexporter = new BasicJeriExporter((ServerEndpoint)TcpServerEndpoint.getInstance((int)0), (InvocationLayerFactory)new BasicILFactory(), false, true);
            this.theStub = (RemoteEventListener)mydefaultexporter.export((Remote)((Object)this));
        }

        public void notify(RemoteEvent event) throws UnknownEventException, RemoteException {
            try {
                System.out.println("some room have been reserved, consult the room pool...");
                HotelRoomPool.this.getRoomStates();
            }
            catch (UnusableEntryException e) {
                e.printStackTrace();
            }
            catch (TransactionException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }

        public RemoteEventListener getTheStub() {
            return this.theStub;
        }

        public void setTheStub(RemoteEventListener theStub) {
            this.theStub = theStub;
        }

        public String getID() {
            return this.ID;
        }

        public void setID(String iD) {
            this.ID = iD;
        }
    }
}

