/*
 * Decompiled with CFR 0.152.
 */
package starter;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.choreos.services.AirlineGroundStaffMID;
import org.choreos.services.backends.airline.DummyAirTrafficEventingConsumer;
import org.choreos.services.backends.hotel.DummyHotelRoomPoolClient;
import org.choreos.services.exceptions.ScenarioException;
import org.choreos.services.util.AddressesProperties;
import starter.AirlineGroundStaffMIDStarter;
import starter.AirlineStarter;
import starter.AirtportStarter;
import starter.GroundTransportationCompanyStarter;
import starter.HotelStarter;
import starter.StandAndGateManagementStarter;
import starter.TravelAgencyStarter;
import starter.WeatherForecastServiceStarter;

public class Starter {
    private DummyAirTrafficEventingConsumer consumer;
    private DummyHotelRoomPoolClient rommPoolClient;
    private AirlineStarter airlineStarter;
    private AirlineGroundStaffMIDStarter airlineGroundStaffMIDStarter;
    private AirtportStarter airtportStarter;
    private GroundTransportationCompanyStarter groundStarter;
    private HotelStarter hotelStarter;
    private StandAndGateManagementStarter standAndGateManagementStarter;
    private TravelAgencyStarter travelAgencyStarter;
    private WeatherForecastServiceStarter weatherStarter;
    private int temp;
    private int humidity;
    private String choreID;
    private Map<String, String> realServicesAddressesProp;
    private HashMap<String, String> invocationAddressesProps;
    private String XSBIPAddress;

    public Starter(int temp, int humidity, String choreID, Map<String, String> realAddresses, HashMap<String, String> invocationAddresses, String XSBIPAddress) {
        this.temp = temp;
        this.humidity = humidity;
        this.choreID = choreID;
        this.realServicesAddressesProp = realAddresses;
        this.invocationAddressesProps = invocationAddresses;
        this.XSBIPAddress = XSBIPAddress;
    }

    public Map<String, String> getProp() {
        return this.realServicesAddressesProp;
    }

    public void setInvocationAddressesProp(HashMap<String, String> invocAddresses) {
        this.airlineStarter.getServiceAirline().setChoreographyContext(invocAddresses);
        this.airlineGroundStaffMIDStarter.getservice().setChoreographyContext(invocAddresses);
        this.airtportStarter.getservice().setChoreographyContext(invocAddresses);
        this.groundStarter.getservice().setChoreographyContext(invocAddresses);
        this.hotelStarter.getservice().setChoreographyContext(invocAddresses);
        this.standAndGateManagementStarter.getservice().setChoreographyContext(invocAddresses);
        this.travelAgencyStarter.getservice().setChoreographyContext(invocAddresses);
        this.weatherStarter.getservice().setChoreographyContext(invocAddresses);
    }

    public void stop() throws IOException {
        this.consumer.stopConsumer();
        this.rommPoolClient.stopRoomPoolClient();
        this.airlineStarter.getEndpointAirline().stop();
        this.airlineGroundStaffMIDStarter.getEndpoint().stop();
        this.airtportStarter.getEndpoint().stop();
        this.groundStarter.getEndpoint().stop();
        this.hotelStarter.getEndpoint().stop();
        this.standAndGateManagementStarter.getEndpoint().stop();
        this.travelAgencyStarter.getEndpoint().stop();
        this.weatherStarter.getEndpoint().stop();
    }

    public void start() throws Exception {
        this.consumer = new DummyAirTrafficEventingConsumer(false);
        this.consumer.startConsumer();
        this.rommPoolClient = DummyHotelRoomPoolClient.newInstance(null);
        this.rommPoolClient.startRoomPoolClient();
        Thread.currentThread();
        Thread.sleep(1000L);
        AddressesProperties ap = new AddressesProperties();
        if (this.realServicesAddressesProp == null) {
            this.realServicesAddressesProp = AddressesProperties.toMap(AddressesProperties.getOriginalAddressesProperties());
        }
        if (this.invocationAddressesProps == null) {
            this.invocationAddressesProps = AddressesProperties.toMap(AddressesProperties.getDistributedAddressesProperties());
        }
        if (this.choreID != null) {
            this.invocationAddressesProps.put("choreID", this.choreID);
        }
        try {
            this.airlineGroundStaffMIDStarter = new AirlineGroundStaffMIDStarter(this.realServicesAddressesProp.get("airlinegroundstaffmid"), this.invocationAddressesProps);
            this.airtportStarter = new AirtportStarter(this.realServicesAddressesProp.get("airport"), this.invocationAddressesProps);
            this.groundStarter = new GroundTransportationCompanyStarter(this.realServicesAddressesProp.get("groundtransportationcompany"), this.invocationAddressesProps);
            this.hotelStarter = new HotelStarter(this.realServicesAddressesProp.get("hotel"), this.invocationAddressesProps, this.XSBIPAddress);
            this.standAndGateManagementStarter = new StandAndGateManagementStarter(this.realServicesAddressesProp.get("standandgatemanagement"), this.invocationAddressesProps);
            this.travelAgencyStarter = new TravelAgencyStarter(this.realServicesAddressesProp.get("travelagency"), this.invocationAddressesProps);
            this.weatherStarter = new WeatherForecastServiceStarter(this.realServicesAddressesProp.get("weatherforecastservice"), this.invocationAddressesProps, this.temp, this.humidity);
            this.airlineStarter = new AirlineStarter(this.realServicesAddressesProp.get("airline"), this.invocationAddressesProps, this.XSBIPAddress);
            System.out.println(this.invocationAddressesProps);
            this.setInvocationAddressesProp(this.invocationAddressesProps);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception(e);
        }
    }

    public AirlineGroundStaffMID getServiceAirlineGroundStaffMID() {
        return this.airlineGroundStaffMIDStarter.getservice();
    }

    public void startRequest(List<String> passengers) throws ScenarioException {
        this.airlineStarter.getServiceAirline().warnReroute("AF1234", passengers);
    }

    public static void main(String[] args) {
        Starter s = new Starter(35, 50, "1234", null, null, "127.0.0.1");
        try {
            s.start();
            System.in.read();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String buildAddressFromContext(String host, String port, String choreID, String endpoint, String suffix) {
        String res = "http://";
        res = res + host + ":" + port + "/";
        res = res + suffix;
        res = res + endpoint;
        if (choreID != null) {
            res = res + choreID;
        }
        return res;
    }
}

