/*
 * Decompiled with CFR 0.152.
 */
package com.trg.search.jpa;

import com.trg.search.BaseSearchProcessor;
import com.trg.search.Field;
import com.trg.search.ISearch;
import com.trg.search.InternalUtil;
import com.trg.search.MetadataUtil;
import com.trg.search.SearchResult;
import com.trg.search.SearchUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.NonUniqueResultException;
import javax.persistence.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPASearchProcessor
extends BaseSearchProcessor {
    private static Logger logger = LoggerFactory.getLogger(JPASearchProcessor.class);

    public JPASearchProcessor(MetadataUtil mdu) {
        super(QLTYPE_EQL, mdu);
    }

    public List search(EntityManager entityManager, ISearch search) {
        if (search == null) {
            return null;
        }
        return this.search(entityManager, search.getSearchClass(), search);
    }

    public List search(EntityManager entityManager, Class<?> searchClass, ISearch search) {
        if (searchClass == null || search == null) {
            return null;
        }
        ArrayList<Object> paramList = new ArrayList<Object>();
        String ql = this.generateQL(searchClass, search, paramList);
        Query query = entityManager.createQuery(ql);
        this.addParams(query, paramList);
        this.addPaging(query, search);
        return this.transformResults(query.getResultList(), search);
    }

    public int count(EntityManager entityManager, ISearch search) {
        if (search == null) {
            return 0;
        }
        return this.count(entityManager, search.getSearchClass(), search);
    }

    public int count(EntityManager entityManager, Class<?> searchClass, ISearch search) {
        if (searchClass == null || search == null) {
            return 0;
        }
        ArrayList<Object> paramList = new ArrayList<Object>();
        String ql = this.generateRowCountQL(searchClass, search, paramList);
        if (ql == null) {
            return 1;
        }
        Query query = entityManager.createQuery(ql);
        this.addParams(query, paramList);
        return ((Number)query.getSingleResult()).intValue();
    }

    public SearchResult searchAndCount(EntityManager entityManager, ISearch search) {
        if (search == null) {
            return null;
        }
        return this.searchAndCount(entityManager, search.getSearchClass(), search);
    }

    public SearchResult searchAndCount(EntityManager entityManager, Class<?> searchClass, ISearch search) {
        if (searchClass == null || search == null) {
            return null;
        }
        SearchResult result = new SearchResult();
        result.setResult(this.search(entityManager, searchClass, search));
        if (search.getMaxResults() > 0) {
            result.setTotalCount(this.count(entityManager, searchClass, search));
        } else {
            result.setTotalCount(result.getResult().size() + SearchUtil.calcFirstResult(search));
        }
        return result;
    }

    public Object searchUnique(EntityManager entityManager, ISearch search) throws NonUniqueResultException {
        if (search == null) {
            return null;
        }
        return this.searchUnique(entityManager, search.getSearchClass(), search);
    }

    public Object searchUnique(EntityManager entityManager, Class<?> entityClass, ISearch search) throws NonUniqueResultException {
        if (search == null) {
            return null;
        }
        ArrayList<Object> paramList = new ArrayList<Object>();
        String ql = this.generateQL(entityClass, search, paramList);
        Query query = entityManager.createQuery(ql);
        this.addParams(query, paramList);
        try {
            return this.transformResult(query.getSingleResult(), search);
        }
        catch (NoResultException ex) {
            return this.transformResult(null, search);
        }
    }

    private void addParams(Query query, List<Object> params) {
        StringBuilder debug = null;
        int i = 1;
        for (Object o : params) {
            if (logger.isDebugEnabled()) {
                if (debug == null) {
                    debug = new StringBuilder();
                } else {
                    debug.append("\n\t");
                }
                debug.append("p");
                debug.append(i);
                debug.append(": ");
                debug.append(InternalUtil.paramDisplayString(o));
            }
            query.setParameter("p" + Integer.toString(i++), o);
        }
        if (debug != null && debug.length() != 0) {
            logger.debug(debug.toString());
        }
    }

    private void addPaging(Query query, ISearch search) {
        int firstResult = SearchUtil.calcFirstResult(search);
        if (firstResult > 0) {
            query.setFirstResult(firstResult);
        }
        if (search.getMaxResults() > 0) {
            query.setMaxResults(search.getMaxResults());
        }
    }

    private Object transformResult(Object result, ISearch search) {
        ArrayList<Object> results = new ArrayList<Object>(1);
        results.add(result);
        return this.transformResults(results, search).get(0);
    }

    private List transformResults(List results, ISearch search) {
        if (results.size() == 0) {
            return results;
        }
        int resultMode = search.getResultMode();
        if (resultMode == 0) {
            int count = 0;
            for (Field field : search.getFields()) {
                if (field.getKey() != null && !field.getKey().equals("")) {
                    resultMode = 3;
                    break;
                }
                ++count;
            }
            if (resultMode == 0) {
                resultMode = count > 1 ? 1 : 4;
            }
        }
        switch (resultMode) {
            case 1: {
                if (!(results.get(0) instanceof Object[])) {
                    ArrayList<Object[]> rArray = new ArrayList<Object[]>(results.size());
                    for (Object result : results) {
                        rArray.add(new Object[]{result});
                    }
                    return rArray;
                }
                return results;
            }
            case 2: {
                ArrayList rList = new ArrayList(results.size());
                if (results.get(0) instanceof Object[]) {
                    for (Object result : results) {
                        ArrayList list = new ArrayList(((E)result).length);
                        for (Object o : result) {
                            list.add(o);
                        }
                        rList.add(list);
                    }
                } else {
                    for (Object result : results) {
                        ArrayList list = new ArrayList(1);
                        list.add(result);
                        rList.add(list);
                    }
                }
                return rList;
            }
            case 3: {
                ArrayList<String> keyList = new ArrayList<String>();
                for (Field field : search.getFields()) {
                    if (field.getKey() != null && !field.getKey().equals("")) {
                        keyList.add(field.getKey());
                        continue;
                    }
                    keyList.add(field.getProperty());
                }
                ArrayList rMap = new ArrayList(results.size());
                if (results.get(0) instanceof Object[]) {
                    for (Object[] result : results) {
                        HashMap<String, Object> map = new HashMap<String, Object>();
                        for (int i = 0; i < keyList.size(); ++i) {
                            String key = (String)keyList.get(i);
                            if (key == null) continue;
                            map.put(key, result[i]);
                        }
                        rMap.add(map);
                    }
                } else if (keyList.size() == 1) {
                    for (Object result : results) {
                        HashMap map = new HashMap();
                        if (keyList.get(0) != null) {
                            map.put(keyList.get(0), result);
                        }
                        rMap.add(map);
                    }
                } else {
                    throw new RuntimeException("Unexpected condition: a single object was returned from the query for each record, but the Search expects multiple.");
                }
                return rMap;
            }
        }
        return results;
    }
}

