/*
 * Decompiled with CFR 0.152.
 */
package edu.uga.cs.lsdis.sawsdl.impl.xml;

import com.ibm.wsdl.util.xml.DOMUtils;
import edu.uga.cs.lsdis.sawsdl.Definition;
import edu.uga.cs.lsdis.sawsdl.Operation;
import edu.uga.cs.lsdis.sawsdl.Part;
import edu.uga.cs.lsdis.sawsdl.PortType;
import edu.uga.cs.lsdis.sawsdl.WSDLSException;
import edu.uga.cs.lsdis.sawsdl.extensions.sawsdl.AttrExtensions;
import edu.uga.cs.lsdis.sawsdl.impl.Constants;
import edu.uga.cs.lsdis.sawsdl.impl.util.ModelRefUtil;
import java.net.URISyntaxException;
import java.util.List;
import javax.wsdl.WSDLException;
import org.w3c.dom.Element;

public class WSDLReaderImpl
extends com.ibm.wsdl.xml.WSDLReaderImpl {
    protected Part parsePart(Element partEl, javax.wsdl.Definition def) throws WSDLException {
        Part semanticPart = (Part)super.parsePart(partEl, def);
        String modelReference = DOMUtils.getAttributeNS((Element)partEl, (String)"http://www.w3.org/2007/01/sawsdl#", (String)"modelReference");
        if (modelReference != null) {
            try {
                ModelRefUtil.parseModelReference(modelReference, (Definition)def, (Object)semanticPart);
            }
            catch (URISyntaxException e) {
                throw new WSDLSException("PARSER_ERROR", "failure parsing model reference in Message Part", e);
            }
        }
        return semanticPart;
    }

    protected javax.wsdl.Operation parseOperation(Element opEl, javax.wsdl.PortType portType, javax.wsdl.Definition def) throws WSDLException {
        Operation op = (Operation)super.parseOperation(opEl, portType, def);
        String modelReference = this.getOperationModelReference(op);
        if (modelReference != null) {
            try {
                ModelRefUtil.parseModelReference(modelReference, (Definition)def, (Object)op);
            }
            catch (URISyntaxException e) {
                throw new WSDLSException("PARSER_ERROR", "failure parsing model reference in Operation", e);
            }
        }
        return op;
    }

    private String getOperationModelReference(Operation op) {
        List extensibilityElements = op.getExtensibilityElements();
        for (Object extensibilityElement : extensibilityElements) {
            if (!(extensibilityElement instanceof AttrExtensions)) continue;
            AttrExtensions attrExtensions = (AttrExtensions)extensibilityElement;
            return attrExtensions.getModelRefStringValue();
        }
        return null;
    }

    protected javax.wsdl.PortType parsePortType(Element portTypeEl, javax.wsdl.Definition def) throws WSDLException {
        PortType portType = (PortType)super.parsePortType(portTypeEl, def);
        List modelReference = (List)portType.getExtensionAttribute(Constants.Q_ATTR_MODELREF);
        if (modelReference != null && !modelReference.isEmpty()) {
            try {
                ModelRefUtil.parseModelReference(modelReference, (Definition)def, portType);
            }
            catch (URISyntaxException e) {
                throw new WSDLSException("PARSER_ERROR", "failure parsing model reference in Porttype", e);
            }
        }
        return portType;
    }
}

