/*
 * Decompiled with CFR 0.152.
 */
package org.choreos.services;

import com.ebmwebsourcing.easycommons.research.util.SOAException;
import com.ebmwebsourcing.easycommons.research.util.dom.DOMUtil;
import com.ebmwebsourcing.easycommons.research.util.jaxb.SOAJAXBContext;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPException;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPHandler;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import javax.jws.WebParam;
import javax.jws.WebService;
import javax.xml.parsers.ParserConfigurationException;
import org.choreos.services.DemoParticipant;
import org.choreos.services.client.airport.AmenityType;
import org.choreos.services.client.hotel.BookingOrder;
import org.choreos.services.client.weatherforecastservice.ObjectFactory;
import org.choreos.services.data.AvailableAmenity;
import org.choreos.services.data.BookingReceipt;
import org.choreos.services.exceptions.ScenarioException;
import org.choreos.services.interfaces.BookAmenitySink;
import org.choreos.services.interfaces.RequestAmenitiesSink;
import org.choreos.services.interfaces.WarnUnexpectedArrival;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

@WebService
public class AirlineGroundStaffMID
extends DemoParticipant
implements BookAmenitySink,
RequestAmenitiesSink,
WarnUnexpectedArrival {
    private int nbBookingReceiptCalls = 0;
    private int nbAmeniyReceiptCalls = 0;
    private boolean keepForTheNight = false;
    private long latency = 10000L;

    @Override
    public void putBookingReceipt(BookingReceipt bookingReceipt) throws ScenarioException {
        System.out.println(this.id + ".putBookingReceipt() called");
        ++this.nbBookingReceiptCalls;
    }

    @Override
    public void putAmenity(AvailableAmenity availableAmenity) throws ScenarioException {
        System.out.println("NB AMENITIES ++");
        System.out.println(this.id + ".putAmenity() called");
        ++this.nbAmeniyReceiptCalls;
        if (this.keepForTheNight) {
            PutAmenityThread t = new PutAmenityThread(1000L);
            t.start();
        }
    }

    @Override
    public void warnArrival(@WebParam(name="flightNumber") String flightNumber, @WebParam(name="passengers") List<String> passengers) throws ScenarioException {
        System.out.println(this.id + ".warnArrival() called");
        try {
            Thread.sleep(this.latency);
            WarnThread t = new WarnThread(2000L, flightNumber, passengers);
            t.start();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new ScenarioException();
        }
    }

    public int getNbBookingReceiptCalls(String get) {
        return this.nbBookingReceiptCalls;
    }

    public void setNbBookingReceiptCalls(int nbBookingReceiptCalls) {
        this.nbBookingReceiptCalls = nbBookingReceiptCalls;
    }

    public int getNbAmeniyReceiptCalls(String get) {
        return this.nbAmeniyReceiptCalls;
    }

    public long getLatency() {
        return this.latency;
    }

    public void setLatency(long latency) {
        this.latency = latency;
    }

    static {
        try {
            SOAJAXBContext.getInstance().addOtherObjectFactory(new Class[]{ObjectFactory.class});
        }
        catch (SOAException e) {
            System.err.println(e.getLocalizedMessage());
        }
    }

    public class RequestAmenitiesAirport
    extends Thread {
        private String airportService;

        public RequestAmenitiesAirport() throws MalformedURLException {
            this.airportService = (String)AirlineGroundStaffMID.this.invocationAddresses.get("airport");
        }

        @Override
        public void run() {
            ArrayList<AmenityType> amenities = new ArrayList<AmenityType>();
            AmenityType at1 = new AmenityType();
            at1.setTypeName("at1");
            amenities.add(at1);
            try {
                InputStream req6URL = Thread.currentThread().getContextClassLoader().getResourceAsStream("requests/req6.xml");
                Document req = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().parse(req6URL);
                DemoParticipant.ss.sendSoapRequest(req, this.airportService, null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public class RequestAmenitiesStandAndGateManagement
    extends Thread {
        private String standAddress;

        public RequestAmenitiesStandAndGateManagement() throws MalformedURLException {
            this.standAddress = (String)AirlineGroundStaffMID.this.invocationAddresses.get("standandgatemanagement");
        }

        @Override
        public void run() {
            ArrayList<org.choreos.services.client.standandgatemanagement.AmenityType> amenities = new ArrayList<org.choreos.services.client.standandgatemanagement.AmenityType>();
            org.choreos.services.client.standandgatemanagement.AmenityType at1 = new org.choreos.services.client.standandgatemanagement.AmenityType();
            at1.setTypeName("at1");
            amenities.add(at1);
            try {
                InputStream req6URL = Thread.currentThread().getContextClassLoader().getResourceAsStream("requests/req6.xml");
                Document req = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().parse(req6URL);
                DemoParticipant.ss.sendSoapRequest(req, this.standAddress, null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public class RequestAmenitiesAirlineGroundStaffMID
    extends Thread {
        String airlineServiceAddress;

        public RequestAmenitiesAirlineGroundStaffMID() throws MalformedURLException {
            this.airlineServiceAddress = (String)AirlineGroundStaffMID.this.invocationAddresses.get("airline");
        }

        @Override
        public void run() {
            ArrayList<org.choreos.services.client.airline.AmenityType> amenities = new ArrayList<org.choreos.services.client.airline.AmenityType>();
            org.choreos.services.client.airline.AmenityType at = new org.choreos.services.client.airline.AmenityType();
            at.setTypeName("at1");
            amenities.add(at);
            try {
                InputStream req5URL = Thread.currentThread().getContextClassLoader().getResourceAsStream("requests/req5.xml");
                Document req = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().parse(req5URL);
                DemoParticipant.ss.sendSoapRequest(req, this.airlineServiceAddress, null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public class PutAmenityThread
    extends Thread {
        private long beginSleep;

        public PutAmenityThread(long beginSleep) {
            this.beginSleep = beginSleep;
        }

        @Override
        public void run() {
            try {
                Thread.sleep(this.beginSleep);
                BookingOrder order = new BookingOrder();
                for (int i = 0; i < 3; ++i) {
                    InputStream req7URL = Thread.currentThread().getContextClassLoader().getResourceAsStream("requests/req7.xml");
                    Document req = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().parse(req7URL);
                    Document respDom = DemoParticipant.ss.sendSoapRequest(req, (String)AirlineGroundStaffMID.this.invocationAddresses.get("hotel"), null);
                    System.out.println("Hotel book response : " + XMLPrettyPrinter.prettyPrint((Document)respDom));
                }
                InputStream req8URL = Thread.currentThread().getContextClassLoader().getResourceAsStream("requests/req8.xml");
                Document req = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().parse(req8URL);
                Document respDom = DemoParticipant.ss.sendSoapRequest(req, (String)AirlineGroundStaffMID.this.invocationAddresses.get("groundtransportationcompany"), null);
                System.out.println("Ground transportation response : " + XMLPrettyPrinter.prettyPrint((Document)respDom));
            }
            catch (InterruptedException e) {
                throw new RuntimeException();
            }
            catch (MalformedURLException e) {
                throw new RuntimeException();
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
            }
            catch (SOAPException e) {
                e.printStackTrace();
            }
        }
    }

    public class WarnThread
    extends Thread {
        private long beginSleep;
        private String flightNumber;
        private List<String> passengers;

        public WarnThread(long beginSleep, String flightNumber, List<String> passengers) {
            this.beginSleep = beginSleep;
            this.flightNumber = flightNumber;
            this.passengers = passengers;
        }

        @Override
        public void run() {
            try {
                Thread.sleep(this.beginSleep);
                System.out.println("WarnThread ... calling Weather");
                InputStream req2URL = Thread.currentThread().getContextClassLoader().getResourceAsStream("requests/req2.xml");
                if (req2URL == null) {
                    System.out.println("Req2URL is null !!!");
                }
                Document req = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().parse(req2URL);
                DemoParticipant.ss.sendSoapRequest(req, (String)AirlineGroundStaffMID.this.invocationAddresses.get("travelagency"), null);
                req2URL.close();
                InputStream req3URL = Thread.currentThread().getContextClassLoader().getResourceAsStream("requests/req3.xml");
                Document reqw = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().parse(req3URL);
                Document res = DemoParticipant.ss.sendSoapRequest(reqw, (String)AirlineGroundStaffMID.this.invocationAddresses.get("weatherforecastservice"), null);
                Node nodeToAdopt = SOAPHandler.getBody((Document)res).getElementsByTagNameNS("http://services.choreos.org/", "getWeatherAtResponse").item(0);
                Document resWeather = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
                Node adoptedNode = resWeather.adoptNode(nodeToAdopt);
                resWeather.appendChild(adoptedNode);
                System.out.println("WEATHER : " + XMLPrettyPrinter.prettyPrint((Document)resWeather));
                Node nodeHum = resWeather.getFirstChild().getFirstChild().getNextSibling().getFirstChild().getNextSibling();
                System.out.println(nodeHum.getNodeName());
                System.out.println("hum ? " + nodeHum.getTextContent());
                System.out.println("temp ? " + nodeHum.getNextSibling().getNextSibling().getTextContent());
                int temp = 10;
                int humidity = 90;
                System.out.println("Temperature (C) : " + temp);
                System.out.println("Humidity (%) : " + humidity);
                if (humidity > 5 && temp < 15) {
                    AirlineGroundStaffMID.this.keepForTheNight = true;
                    System.out.println("<+> Keep passengers for the night.");
                    for (int i = 0; i < 3; ++i) {
                        InputStream req4URL = Thread.currentThread().getContextClassLoader().getResourceAsStream("requests/req4.xml");
                        req = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().parse(req4URL);
                        Document reqResponseDom = DemoParticipant.ss.sendSoapRequest(req, (String)AirlineGroundStaffMID.this.invocationAddresses.get("travelagency"), null);
                        String reqResponse = XMLPrettyPrinter.prettyPrint((Document)reqResponseDom);
                        System.out.println("Req response : " + reqResponse);
                    }
                } else {
                    System.out.println("<+> Put passengers in transit.");
                    RequestAmenitiesAirlineGroundStaffMID r1 = new RequestAmenitiesAirlineGroundStaffMID();
                    RequestAmenitiesStandAndGateManagement r2 = new RequestAmenitiesStandAndGateManagement();
                    RequestAmenitiesAirport r3 = new RequestAmenitiesAirport();
                    r1.start();
                    r2.start();
                    r3.start();
                }
            }
            catch (MalformedURLException e) {
                throw new RuntimeException();
            }
            catch (InterruptedException e) {
                throw new RuntimeException();
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
            }
            catch (SOAPException e) {
                e.printStackTrace();
            }
        }
    }
}

