/*
 * Decompiled with CFR 0.152.
 */
package org.choreos.services.backends.hotel;

import com.sun.jini.config.Config;
import java.net.URL;
import java.rmi.RMISecurityManager;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.PrivilegedExceptionAction;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import net.jini.config.Configuration;
import net.jini.config.NoSuchEntryException;

public class SecurityPolicyLoader {
    static final String COMPONENT = "org.rioproject.tools.ui";

    public static void applyPolicy(Configuration config) throws Exception {
        PrivilegedExceptionAction createViewer = new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                SecurityPolicyLoader.load("javaspace.policy");
                return null;
            }
        };
        try {
            LoginContext loginContext = (LoginContext)Config.getNonNullEntry((Configuration)config, (String)COMPONENT, (String)"loginContext", LoginContext.class);
            loginContext.login();
            Subject.doAsPrivileged(loginContext.getSubject(), createViewer, null);
        }
        catch (NoSuchEntryException ex) {
            createViewer.run();
        }
    }

    public static void load(String policyName) {
        Policy.setPolicy(new Policy(){

            @Override
            public PermissionCollection getPermissions(CodeSource codesource) {
                Permissions perms = new Permissions();
                perms.add(new AllPermission());
                return perms;
            }

            @Override
            public void refresh() {
            }
        });
        if (System.getSecurityManager() != null) {
            return;
        }
        System.setSecurityManager(new RMISecurityManager());
        try {
            URL policy = SecurityPolicyLoader.class.getResource(policyName);
            if (policy == null) {
                System.err.println("Warning: can't find [" + policy + "] resource");
            } else {
                String policyString = policy.toString();
                System.setProperty("java.security.policy", policyString);
            }
            System.getSecurityManager().checkPermission(new RuntimePermission("getClassLoader"));
        }
        catch (SecurityException uh_oh) {
            uh_oh.printStackTrace();
            System.err.println("(aborting)");
            System.exit(1);
        }
    }
}

