/*
 * Decompiled with CFR 0.152.
 */
package org.choreos.services.backends.hotel;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.choreos.services.backends.hotel.BookingOrderDelegate;
import org.choreos.services.backends.hotel.HotelRoomPoolClient;
import org.ws4d.java.DPWSFramework;
import org.ws4d.java.communication.CommunicationBinding;
import org.ws4d.java.communication.HTTPBinding;
import org.ws4d.java.communication.connection.ip.IPAddress;
import org.ws4d.java.communication.connection.ip.PlatformIPNetworkDetection;
import org.ws4d.java.service.DefaultDevice;
import org.ws4d.java.service.DefaultService;
import org.ws4d.java.service.InvokeDelegate;
import org.ws4d.java.service.LocalService;
import org.ws4d.java.service.OperationStub;
import org.ws4d.java.structures.HashMap;
import org.ws4d.java.structures.Iterator;
import org.ws4d.java.types.URI;
import org.ws4d.java.util.Log;

public class DummyHotelRoomPoolClient
extends DefaultService
implements HotelRoomPoolClient {
    public static final String NAMESPACE = "http://services.choreos.org/backends/HotelRoomPoolClient/";
    public static final String NAME_SERVICE = "HotelRoomPoolClient";
    protected DefaultDevice device;
    protected String urlLocator;

    protected DummyHotelRoomPoolClient(String urlLocator) throws Exception {
        super(-1);
        this.urlLocator = urlLocator;
        this.device = new DefaultDevice(-1);
        this.setServiceId(new URI(NAMESPACE, "/" + NAME_SERVICE));
        this.defineService(urlLocator);
        this.device.addService((LocalService)this);
        Iterator it = PlatformIPNetworkDetection.getInstance().getAddresses();
        while (it.hasNext()) {
            HashMap.Entry ip = (HashMap.Entry)it.next();
            IPAddress current = (IPAddress)ip.getValue();
            if (current.isIPv6()) continue;
            HTTPBinding serviceBinding = new HTTPBinding(current, 12318, NAME_SERVICE);
            this.addBinding((CommunicationBinding)serviceBinding);
            HTTPBinding deviceBinding = new HTTPBinding(current, 12318, "DummyHotelRoomPoolClientDevice");
            this.device.addBinding((CommunicationBinding)deviceBinding);
        }
    }

    @Override
    public boolean hasJavaspace() {
        return this.urlLocator != null;
    }

    protected void defineService(String urlLocator) throws Exception {
        URI wsdlURI = new URI("local:/backends/HotelRoomPoolClient.wsdl");
        System.out.println("WSDL URI " + wsdlURI);
        this.define(wsdlURI);
        Iterator iter = this.getOperations();
        while (iter.hasNext()) {
            OperationStub currentOp = (OperationStub)iter.next();
            String name = currentOp.getName();
            if (!name.equals("BookingOrder")) continue;
            currentOp.setDelegate((InvokeDelegate)new BookingOrderDelegate(urlLocator));
        }
    }

    @Override
    public void startRoomPoolClient() throws IOException {
        this.device.start();
    }

    @Override
    public void stopRoomPoolClient() throws IOException {
        this.device.stop();
    }

    public static DummyHotelRoomPoolClient newInstance(String urlLocator) throws Exception {
        DPWSFramework.start((String[])new String[0]);
        Log.setLogLevel((int)3);
        return new DummyHotelRoomPoolClient(urlLocator);
    }

    public static void main(String[] args) {
        try {
            DummyHotelRoomPoolClient dummyClient = DummyHotelRoomPoolClient.newInstance("jini://127.0.0.1");
            dummyClient.startRoomPoolClient();
            System.out.println("Type quit for exiting");
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
            String line = reader.readLine();
            while (!line.equals("quit")) {
                line = reader.readLine();
            }
            dummyClient.stopRoomPoolClient();
            System.exit(1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

