/*
 * Decompiled with CFR 0.152.
 */
package org.choreos.services.backends.hotel;

import org.ws4d.java.DPWSFramework;
import org.ws4d.java.client.DefaultClient;
import org.ws4d.java.communication.TimeoutException;
import org.ws4d.java.service.InvocationException;
import org.ws4d.java.service.Operation;
import org.ws4d.java.service.Service;
import org.ws4d.java.service.parameter.ParameterValue;
import org.ws4d.java.service.reference.ServiceReference;
import org.ws4d.java.types.EndpointReference;
import org.ws4d.java.types.QName;
import org.ws4d.java.types.URI;
import org.ws4d.java.util.Log;
import org.ws4d.java.util.ParameterUtil;

public class HotelBookCallback {
    protected int room = 1;
    protected String xsbIPAddress;

    public HotelBookCallback() {
        DPWSFramework.start((String[])new String[0]);
        Log.setLogLevel((int)3);
    }

    public void stopCallback() {
        DPWSFramework.stop();
    }

    public void invokeRoomPoolBackend() throws TimeoutException, InvocationException {
        System.out.println("Send room reservation to the room pool");
        String url = "http://" + this.xsbIPAddress + ":12318/HotelRoomPoolClient";
        EndpointReference epr = new EndpointReference(new URI(url));
        DefaultClient client = new DefaultClient();
        ServiceReference servRef = client.getServiceReference(epr, "DPWS");
        Service serviceProxy = servRef.getService();
        Operation operation = serviceProxy.getAnyOperation(new QName("HotelRoomPoolClientPT", "http://services.choreos.org/backends/HotelRoomPoolClient/"), "BookingOrder");
        ParameterValue input = operation.createInputValue();
        ParameterUtil.setString((ParameterValue)input, (String)"room", (String)Integer.toString(this.room));
        operation.invoke(input);
        ++this.room;
    }

    public int getRoom() {
        return this.room;
    }

    public void setRoom(int room) {
        this.room = room;
    }

    public String getXsbIPAddress() {
        return this.xsbIPAddress;
    }

    public void setXsbIPAddress(String xsbIPAddress) {
        this.xsbIPAddress = xsbIPAddress;
    }

    public static void main(String[] args) {
        HotelBookCallback callback = new HotelBookCallback();
        callback.setXsbIPAddress("127.0.0.1");
        try {
            callback.invokeRoomPoolBackend();
        }
        catch (TimeoutException e) {
            e.printStackTrace();
        }
        catch (InvocationException e) {
            e.printStackTrace();
        }
    }
}

