/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.attachment;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.ws4d.java.attachment.Attachment;
import org.ws4d.java.attachment.AttachmentException;
import org.ws4d.java.types.InternetMediaType;
import org.ws4d.java.util.IDGenerator;

public abstract class AbstractAttachment
implements Attachment {
    static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    static final InputStream EMPTY_STREAM = new ByteArrayInputStream(EMPTY_BYTE_ARRAY);
    static final String[] EMPTY_STRING_ARRAY = new String[0];
    private String contentId;
    private InternetMediaType contentType;
    private String transferEncoding;
    protected AttachmentException readInException;

    static InternetMediaType maskContentType(String string) {
        return string == null || "".equals(string) ? null : new InternetMediaType(string);
    }

    protected AbstractAttachment(InternetMediaType internetMediaType) {
        this(IDGenerator.getUUID(), internetMediaType);
    }

    protected AbstractAttachment(String string) {
        this(IDGenerator.getUUID(), AbstractAttachment.maskContentType(string));
    }

    protected AbstractAttachment(String string, InternetMediaType internetMediaType) {
        this(string, internetMediaType, "binary");
    }

    protected AbstractAttachment(String string, String string2) {
        this(string, AbstractAttachment.maskContentType(string2), "binary");
    }

    protected AbstractAttachment(String string, InternetMediaType internetMediaType, String string2) {
        this.contentId = string;
        this.contentType = internetMediaType;
        this.transferEncoding = string2;
    }

    protected AbstractAttachment(String string, String string2, String string3) {
        this(string, AbstractAttachment.maskContentType(string2), string3);
    }

    public boolean isAvailable() {
        return true;
    }

    public String getContentId() {
        return this.contentId;
    }

    public InternetMediaType getContentType() throws AttachmentException {
        if (this.readInException != null) {
            throw this.readInException;
        }
        return this.contentType;
    }

    public String getTransferEncoding() throws AttachmentException {
        if (this.readInException != null) {
            throw this.readInException;
        }
        return this.transferEncoding;
    }

    void setContentId(String string) {
        this.contentId = string;
    }

    void setContentType(InternetMediaType internetMediaType) {
        this.contentType = internetMediaType;
    }

    void setTransferEncoding(String string) {
        this.transferEncoding = string;
    }

    void setReadInException(AttachmentException attachmentException) {
        this.readInException = attachmentException;
    }
}

