/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.attachment;

import java.io.IOException;
import java.io.InputStream;
import org.ws4d.java.DPWSFramework;
import org.ws4d.java.attachment.AttachmentException;
import org.ws4d.java.attachment.AttachmentFactory;
import org.ws4d.java.attachment.IncomingAttachment;
import org.ws4d.java.communication.ContextID;
import org.ws4d.java.structures.DataStructure;
import org.ws4d.java.structures.HashSet;
import org.ws4d.java.structures.Iterator;
import org.ws4d.java.structures.ReadOnlyIterator;
import org.ws4d.java.types.InternetMediaType;
import org.ws4d.java.util.Log;

public abstract class AttachmentStore {
    public static final int POLICY_MEM_BUFFER = 1;
    public static final int POLICY_EXT_STORAGE = 2;
    private static final String ATTACHMENT_STORE_IMPLEMENTATION_CLASS = "org.ws4d.java.attachment.DefaultAttachmentStore";
    private static AttachmentStore instance;
    private static int storePolicy;
    private static final DataStructure STREAMING_MEDIA_TYPES;

    public static AttachmentStore getInstance() throws AttachmentException {
        if (DPWSFramework.hasModule(32)) {
            if (instance == null) {
                try {
                    Class<?> clazz = Class.forName(ATTACHMENT_STORE_IMPLEMENTATION_CLASS);
                    instance = (AttachmentStore)clazz.newInstance();
                }
                catch (Exception exception) {
                    throw new AttachmentException("Unable to create AttachmentStore instance: " + exception);
                }
            }
            return instance;
        }
        throw new AttachmentException("Cannot initialize attachment store. Attachment is not supported.");
    }

    public static boolean exists() {
        return instance != null;
    }

    public static int getStorePolicy() {
        return storePolicy;
    }

    public static void setStorePolicy(int n) {
        if (n != 1 && n != 2) {
            Log.error("Unknown attachment store policy, resetting to POLICY_MEM_BUFFER");
            n = 1;
        }
        storePolicy = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean addStreamingMediaType(InternetMediaType internetMediaType) {
        if (internetMediaType != null) {
            DataStructure dataStructure = STREAMING_MEDIA_TYPES;
            synchronized (dataStructure) {
                return STREAMING_MEDIA_TYPES.add(internetMediaType);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean removeStreamingMediaType(InternetMediaType internetMediaType) {
        if (internetMediaType != null) {
            DataStructure dataStructure = STREAMING_MEDIA_TYPES;
            synchronized (dataStructure) {
                return STREAMING_MEDIA_TYPES.remove(internetMediaType);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isStreamingMediaType(InternetMediaType internetMediaType) {
        if (internetMediaType != null) {
            DataStructure dataStructure = STREAMING_MEDIA_TYPES;
            synchronized (dataStructure) {
                return STREAMING_MEDIA_TYPES.contains(internetMediaType);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Iterator getStreamingMediaTypes() {
        HashSet hashSet;
        DataStructure dataStructure = STREAMING_MEDIA_TYPES;
        synchronized (dataStructure) {
            hashSet = new HashSet(STREAMING_MEDIA_TYPES);
        }
        return new ReadOnlyIterator(hashSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetStreamingMediaTypes() {
        DataStructure dataStructure = STREAMING_MEDIA_TYPES;
        synchronized (dataStructure) {
            STREAMING_MEDIA_TYPES.clear();
        }
    }

    public abstract IncomingAttachment resolve(ContextID var1, String var2) throws AttachmentException;

    public abstract void store(ContextID var1, String var2, String var3, String var4, InputStream var5);

    public abstract boolean isAvailable(ContextID var1, String var2);

    public abstract void cleanup();

    static {
        storePolicy = 2;
        STREAMING_MEDIA_TYPES = new HashSet();
        try {
            AttachmentFactory attachmentFactory = DPWSFramework.getAttachmentFactory();
            Iterator iterator = attachmentFactory.getStreamingMediaTypes();
            while (iterator.hasNext()) {
                AttachmentStore.addStreamingMediaType(new InternetMediaType(iterator.next().toString()));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

