/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.attachment;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.ws4d.java.DPWSFramework;
import org.ws4d.java.attachment.AbstractAttachment;
import org.ws4d.java.attachment.AttachmentException;
import org.ws4d.java.attachment.AttachmentStore;
import org.ws4d.java.attachment.FileAttachment;
import org.ws4d.java.attachment.IncomingAttachment;
import org.ws4d.java.attachment.InputStreamAttachment;
import org.ws4d.java.attachment.MemoryAttachment;
import org.ws4d.java.communication.ContextID;
import org.ws4d.java.configuration.AttachmentProperties;
import org.ws4d.java.io.fs.FileSystem;
import org.ws4d.java.structures.HashMap;
import org.ws4d.java.structures.Iterator;
import org.ws4d.java.types.InternetMediaType;
import org.ws4d.java.util.Log;
import org.ws4d.java.util.ObjectPool;

public class DefaultAttachmentStore
extends AttachmentStore {
    private static final AttachmentProperties PROPS = AttachmentProperties.getInstance();
    private static final ObjectPool BUFFERS = new ObjectPool(new ObjectPool.InstanceCreator(){

        public Object createInstance() {
            return new byte[PROPS.getReadBufferSize()];
        }
    }, 1);
    private final HashMap attachments = new HashMap();
    private final HashMap lockKeys = new HashMap();
    private final FileSystem fs;

    static int readOut(InputStream inputStream, OutputStream outputStream) throws IOException {
        try {
            return DefaultAttachmentStore.readOut(inputStream, -1, outputStream);
        }
        catch (AttachmentException attachmentException) {
            throw new IOException(attachmentException.getMessage());
        }
    }

    static int readOut(InputStream inputStream, OutputStream outputStream, byte[] byArray) throws IOException {
        try {
            return DefaultAttachmentStore.readOut(inputStream, -1, outputStream, byArray);
        }
        catch (AttachmentException attachmentException) {
            throw new IOException(attachmentException.getMessage());
        }
    }

    static int readOut(InputStream inputStream, int n, OutputStream outputStream) throws AttachmentException, IOException {
        return DefaultAttachmentStore.readOut(inputStream, n, outputStream, (byte[])BUFFERS.acquire());
    }

    private static int readOut(InputStream inputStream, int n, OutputStream outputStream, byte[] byArray) throws AttachmentException, IOException {
        try {
            int n2 = 0;
            int n3 = inputStream.read(byArray);
            AttachmentException attachmentException = null;
            while (n3 > 0) {
                if (n > 0 && (n2 += n3) > n && attachmentException == null) {
                    attachmentException = new AttachmentException("Attachment size exceeds maximum allowed limit (" + n + ")");
                }
                if (attachmentException == null) {
                    outputStream.write(byArray, 0, n3);
                }
                n3 = inputStream.read(byArray);
            }
            outputStream.flush();
            if (attachmentException == null) {
                int n4 = n2;
                return n4;
            }
            throw attachmentException;
        }
        finally {
            BUFFERS.release(byArray);
        }
    }

    public DefaultAttachmentStore() {
        FileSystem fileSystem = null;
        try {
            fileSystem = DPWSFramework.getLocalFileSystem();
            fileSystem.deleteFile(PROPS.getStorePath());
        }
        catch (IOException iOException) {
            Log.error("No local file system available, attachment store policy POLICY_EXT_STORAGE will not work.");
        }
        this.fs = fileSystem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(ContextID contextID, String string, String string2, String string3, InputStream inputStream) {
        Object object;
        Object object2;
        Object object3;
        AbstractAttachment abstractAttachment;
        InternetMediaType internetMediaType;
        int n = DefaultAttachmentStore.getStorePolicy();
        if (n == 2 && this.fs == null) {
            n = 1;
            Log.warn("No platform support available for requested store policy POLICY_EXT_STORAGE, reverting to POLICY_MEM_BUFFER");
        }
        if (DefaultAttachmentStore.isStreamingMediaType(internetMediaType = new InternetMediaType(string2))) {
            abstractAttachment = new InputStreamAttachment(inputStream);
        } else if (n == 2) {
            object3 = PROPS.getStorePath() + this.fs.fileSeparator() + System.currentTimeMillis() + "_" + this.fs.escapeFileName(contextID.getInstanceId() + ":" + contextID.getMessageNumber() + ":" + string);
            try {
                object2 = this.fs.writeFile((String)object3);
                DefaultAttachmentStore.readOut(inputStream, PROPS.getMaxAttachmentSize(), (OutputStream)object2);
                ((OutputStream)object2).flush();
                ((OutputStream)object2).close();
                abstractAttachment = new FileAttachment((String)object3, false);
            }
            catch (AttachmentException attachmentException) {
                this.fs.deleteFile((String)object3);
                abstractAttachment = new MemoryAttachment(attachmentException);
            }
            catch (IOException iOException) {
                object = new AttachmentException("Reading from stream or writing into attachment store failed: " + iOException);
                Log.error(((Throwable)object).toString());
                abstractAttachment = new MemoryAttachment((AttachmentException)object);
            }
        } else {
            try {
                object3 = new ByteArrayOutputStream();
                DefaultAttachmentStore.readOut(inputStream, PROPS.getMaxMemBufferSize(), (OutputStream)object3);
                ((ByteArrayOutputStream)object3).close();
                abstractAttachment = new MemoryAttachment(((ByteArrayOutputStream)object3).toByteArray());
            }
            catch (AttachmentException attachmentException) {
                abstractAttachment = new MemoryAttachment(attachmentException);
            }
            catch (IOException iOException) {
                object2 = new AttachmentException("Reading from stream failed: " + iOException);
                Log.error(((Throwable)object2).toString());
                abstractAttachment = new MemoryAttachment((AttachmentException)object2);
            }
        }
        abstractAttachment.setContentId(string);
        abstractAttachment.setContentType(internetMediaType);
        abstractAttachment.setTransferEncoding(string3);
        object3 = new StoreKey(contextID, string);
        object2 = null;
        object = this.attachments;
        synchronized (object) {
            this.attachments.put(object3, abstractAttachment);
            object2 = (StoreKey)this.lockKeys.remove(object3);
        }
        if (object2 != null) {
            ((StoreKey)object2).notifyWaiters();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAvailable(ContextID contextID, String string) {
        StoreKey storeKey = new StoreKey(contextID, string);
        HashMap hashMap = this.attachments;
        synchronized (hashMap) {
            return this.attachments.containsKey(storeKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IncomingAttachment resolve(ContextID contextID, String string) throws AttachmentException {
        StoreKey storeKey;
        IncomingAttachment incomingAttachment;
        StoreKey storeKey2 = new StoreKey(contextID, string);
        Object object = this.attachments;
        synchronized (object) {
            incomingAttachment = (IncomingAttachment)this.attachments.get(storeKey2);
            if (incomingAttachment == null) {
                storeKey = (StoreKey)this.lockKeys.get(storeKey2);
                if (storeKey == null) {
                    storeKey = storeKey2;
                    this.lockKeys.put(storeKey, storeKey);
                }
            } else {
                return incomingAttachment;
            }
        }
        object = storeKey;
        synchronized (object) {
            while (storeKey.waiting) {
                try {
                    storeKey.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        object = this.attachments;
        synchronized (object) {
            incomingAttachment = (IncomingAttachment)this.attachments.get(storeKey2);
        }
        if (incomingAttachment == null) {
            throw new AttachmentException("Attachment not found for " + contextID + " and content ID " + string);
        }
        return incomingAttachment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() {
        if (this.fs != null) {
            this.fs.deleteFile(PROPS.getStorePath());
            HashMap hashMap = this.attachments;
            synchronized (hashMap) {
                this.attachments.clear();
                Iterator iterator = this.lockKeys.values().iterator();
                while (iterator.hasNext()) {
                    ((StoreKey)iterator.next()).notifyWaiters();
                }
                this.lockKeys.clear();
            }
        }
    }

    private static class StoreKey {
        final ContextID context;
        final String cid;
        int hashCode;
        public volatile boolean waiting = true;

        StoreKey(ContextID contextID, String string) {
            this.context = contextID;
            this.cid = string;
            this.hashCode = 31 + string.hashCode();
            this.hashCode = 31 * this.hashCode + contextID.hashCode();
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            StoreKey storeKey = (StoreKey)object;
            if (!this.cid.equals(storeKey.cid)) {
                return false;
            }
            return this.context.equals(storeKey.context);
        }

        public synchronized void notifyWaiters() {
            this.waiting = false;
            this.notifyAll();
        }
    }
}

