/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.attachment;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.ws4d.java.DPWSFramework;
import org.ws4d.java.attachment.AbstractAttachment;
import org.ws4d.java.attachment.AttachmentException;
import org.ws4d.java.attachment.DefaultAttachmentStore;
import org.ws4d.java.attachment.OutgoingAttachment;
import org.ws4d.java.attachment.interfaces.incoming.IncomingFileAttachment;
import org.ws4d.java.configuration.AttachmentProperties;
import org.ws4d.java.io.fs.FileSystem;
import org.ws4d.java.types.InternetMediaType;
import org.ws4d.java.util.IDGenerator;
import org.ws4d.java.util.Log;

class FileAttachment
extends AbstractAttachment
implements IncomingFileAttachment,
OutgoingAttachment {
    private static final FileSystem FS;
    private static final OutputStream NIRVANA;
    private String filePath;
    private boolean local;

    FileAttachment(String string) {
        this(string, (InternetMediaType)null);
    }

    FileAttachment(String string, InternetMediaType internetMediaType) {
        this(string, IDGenerator.getUUID(), internetMediaType);
    }

    FileAttachment(String string, String string2) {
        this(string, IDGenerator.getUUID(), string2);
    }

    FileAttachment(String string, String string2, InternetMediaType internetMediaType) {
        super(string2, internetMediaType);
        this.filePath = string;
        this.local = true;
    }

    FileAttachment(String string, String string2, String string3) {
        this(string, string2, FileAttachment.maskContentType(string3));
    }

    FileAttachment(String string, boolean bl) {
        super((InternetMediaType)null);
        this.filePath = string;
        this.local = bl;
    }

    public final int getType() throws AttachmentException {
        return 3;
    }

    public InputStream getInputStream() throws AttachmentException, IOException {
        if (this.readInException != null) {
            throw this.readInException;
        }
        return FS.readFile(this.filePath);
    }

    public long size() throws AttachmentException {
        if (this.readInException != null) {
            throw this.readInException;
        }
        return FS.fileSize(this.filePath);
    }

    public byte[] getBytes() throws AttachmentException, IOException {
        if (this.readInException != null) {
            throw this.readInException;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DefaultAttachmentStore.readOut(FS.readFile(this.filePath), AttachmentProperties.getInstance().getMaxMemBufferSize(), byteArrayOutputStream);
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public void dispose() {
        if (this.local) {
            return;
        }
        try {
            FS.deleteFile(this.filePath);
        }
        catch (Exception exception) {
            Log.warn("Unable to delete attachment file \"" + this.filePath + "\" on dispose: " + exception);
            Log.printStackTrace(exception);
        }
    }

    public void serialize(OutputStream outputStream) throws IOException {
        DefaultAttachmentStore.readOut(FS.readFile(this.filePath), outputStream);
    }

    public boolean isLocal() {
        return this.local;
    }

    public String getFilePath() throws AttachmentException {
        if (this.readInException != null) {
            throw this.readInException;
        }
        return this.filePath;
    }

    public boolean move(String string) throws AttachmentException {
        if (this.readInException != null) {
            throw this.readInException;
        }
        boolean bl = FS.renameFile(this.filePath, string);
        this.filePath = string;
        this.local = true;
        return bl;
    }

    public void save(String string) throws AttachmentException, IOException {
        if (this.readInException != null) {
            throw this.readInException;
        }
        InputStream inputStream = FS.readFile(this.filePath);
        OutputStream outputStream = FS.writeFile(string);
        DefaultAttachmentStore.readOut(inputStream, outputStream);
        outputStream.flush();
        outputStream.close();
    }

    static {
        FileSystem fileSystem;
        NIRVANA = new OutputStream(){

            public void write(int n) throws IOException {
            }

            public void write(byte[] byArray) throws IOException {
            }

            public void write(byte[] byArray, int n, int n2) throws IOException {
            }
        };
        try {
            fileSystem = DPWSFramework.getLocalFileSystem();
        }
        catch (IOException iOException) {
            Log.error("No local file system available, file attachments cannot be used: " + iOException);
            Log.printStackTrace(iOException);
            fileSystem = new FileSystem(){

                public OutputStream writeFile(String string) throws IOException {
                    return NIRVANA;
                }

                public boolean renameFile(String string, String string2) {
                    return true;
                }

                public InputStream readFile(String string) throws IOException {
                    return AbstractAttachment.EMPTY_STREAM;
                }

                public String[] listFiles(String string) {
                    return AbstractAttachment.EMPTY_STRING_ARRAY;
                }

                public String fileSeparator() {
                    return "";
                }

                public String escapeFileName(String string) {
                    return string;
                }

                public boolean deleteFile(String string) {
                    return true;
                }

                public long fileSize(String string) {
                    return 0L;
                }

                public boolean fileExists(String string) {
                    return true;
                }

                public long lastModified(String string) {
                    return 0L;
                }
            };
        }
        FS = fileSystem;
    }
}

