/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.attachment;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.ws4d.java.attachment.AbstractAttachment;
import org.ws4d.java.attachment.AttachmentException;
import org.ws4d.java.attachment.IncomingAttachment;
import org.ws4d.java.attachment.interfaces.outgoing.OutgoingOutputStreamAttachment;
import org.ws4d.java.types.InternetMediaType;
import org.ws4d.java.util.IDGenerator;
import org.ws4d.java.util.Log;

class OutputStreamAttachment
extends AbstractAttachment
implements IncomingAttachment,
OutgoingOutputStreamAttachment {
    private StreamAttachmentOutputStream out = new StreamAttachmentOutputStream();

    OutputStreamAttachment(InternetMediaType internetMediaType) {
        this(IDGenerator.getUUID(), internetMediaType);
    }

    OutputStreamAttachment(String string) {
        this(IDGenerator.getUUID(), OutputStreamAttachment.maskContentType(string));
    }

    OutputStreamAttachment(String string, InternetMediaType internetMediaType) {
        this(string, internetMediaType, "binary");
    }

    OutputStreamAttachment(String string, String string2) {
        this(string, OutputStreamAttachment.maskContentType(string2), "binary");
    }

    OutputStreamAttachment(String string, InternetMediaType internetMediaType, String string2) {
        super(string, internetMediaType, string2);
    }

    public int getType() throws AttachmentException {
        return 4;
    }

    public byte[] getBytes() throws AttachmentException, IOException {
        throw new AttachmentException("This attachment does not allow to read bytes. No byte array available.");
    }

    public InputStream getInputStream() throws AttachmentException, IOException {
        throw new AttachmentException("This attachment does not allow to read bytes. No input stream available.");
    }

    public long size() throws AttachmentException {
        throw new AttachmentException("This attachment does not allow to read bytes. No size available.");
    }

    public boolean isLocal() {
        return true;
    }

    public String getFilePath() throws AttachmentException {
        throw new AttachmentException("file system operations not supported for stream attachments");
    }

    public void save(String string) throws AttachmentException, IOException {
        throw new AttachmentException("file system operations not supported for stream attachments");
    }

    public boolean move(String string) throws AttachmentException {
        throw new AttachmentException("file system operations not supported for stream attachments");
    }

    public void dispose() {
        if (this.out == null) {
            return;
        }
        try {
            this.out.close();
        }
        catch (IOException iOException) {
            Log.warn("Unable to close attachment output stream on dispose: " + iOException);
            Log.printStackTrace(iOException);
        }
        this.out = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serialize(OutputStream outputStream) throws IOException {
        if (this.out == null) {
            throw new IOException("Cannot serialize because this OutputStreamAttachment has already been disposed.");
        }
        this.out.setOutputStream(outputStream);
        StreamAttachmentOutputStream streamAttachmentOutputStream = this.out;
        synchronized (streamAttachmentOutputStream) {
            while (this.out != null && this.out.isWriteable()) {
                try {
                    this.out.wait();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
        }
    }

    public synchronized OutputStream getOutputStream() {
        return this.out;
    }

    public class StreamAttachmentOutputStream
    extends OutputStream {
        private volatile OutputStream out = null;
        private volatile boolean closed = false;

        public synchronized boolean isWriteable() {
            return this.out != null;
        }

        private void waitForOut() throws IOException {
            while (this.out == null && !this.closed) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
            if (this.closed) {
                throw new IOException("Cannot write because this StreamAttachmentOutputStream has already been closed.");
            }
        }

        public synchronized void write(int n) throws IOException {
            this.waitForOut();
            this.out.write(n);
        }

        public synchronized void write(byte[] byArray) throws IOException {
            this.waitForOut();
            this.out.write(byArray);
        }

        public synchronized void write(byte[] byArray, int n, int n2) throws IOException {
            this.waitForOut();
            this.out.write(byArray, n, n2);
        }

        public synchronized void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.closed = true;
            if (this.out != null) {
                this.out.flush();
                this.out = null;
            }
            this.notifyAll();
        }

        public synchronized void flush() throws IOException {
            if (this.closed) {
                throw new IOException("Cannot flush because this StreamAttachmentOutputStream has already been closed.");
            }
            if (this.out == null) {
                return;
            }
            this.out.flush();
        }

        synchronized void setOutputStream(OutputStream outputStream) {
            if (!this.closed) {
                this.out = outputStream;
            }
            this.notifyAll();
        }
    }
}

