/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.client;

import org.ws4d.java.client.SearchCallback;
import org.ws4d.java.client.SearchManager;
import org.ws4d.java.client.SearchParameter;
import org.ws4d.java.communication.CommunicationManagerRegistry;
import org.ws4d.java.communication.DefaultResponseCallback;
import org.ws4d.java.communication.ProtocolData;
import org.ws4d.java.communication.ResponseCallback;
import org.ws4d.java.communication.TimeoutException;
import org.ws4d.java.configuration.DispatchingProperties;
import org.ws4d.java.dispatch.OutDispatcher;
import org.ws4d.java.message.FaultMessage;
import org.ws4d.java.message.InvokeMessage;
import org.ws4d.java.message.Message;
import org.ws4d.java.service.InvocationException;
import org.ws4d.java.service.parameter.ParameterValue;
import org.ws4d.java.service.reference.DeviceReference;
import org.ws4d.java.service.reference.ServiceReference;
import org.ws4d.java.types.QName;
import org.ws4d.java.types.QNameSet;
import org.ws4d.java.types.URI;
import org.ws4d.java.types.XAddressInfo;
import org.ws4d.java.util.Log;
import org.ws4d.java.util.TimedEntry;
import org.ws4d.java.util.WatchDog;

public class InvokeUtil {
    public static void invokeAnyOneWay(String string, ParameterValue parameterValue) {
        InvokeUtil.invokeOneWay(InvokeUtil.discover(string), string, parameterValue);
    }

    public static ParameterValue invokeAny(String string, ParameterValue parameterValue) throws InvocationException, TimeoutException {
        return InvokeUtil.invoke(InvokeUtil.discover(string), string, parameterValue, true);
    }

    public static void invokeOneWay(URI uRI, String string, ParameterValue parameterValue) {
        try {
            InvokeUtil.invoke(uRI, string, parameterValue, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static ParameterValue invoke(URI uRI, String string, ParameterValue parameterValue) throws InvocationException, TimeoutException {
        return InvokeUtil.invoke(uRI, string, parameterValue, true);
    }

    private static ParameterValue invoke(URI uRI, String string, ParameterValue parameterValue, boolean bl) throws InvocationException, TimeoutException {
        InvokeMessage invokeMessage = new InvokeMessage(string, CommunicationManagerRegistry.getDefault());
        XAddressInfo xAddressInfo = new XAddressInfo(uRI, CommunicationManagerRegistry.getDefault());
        invokeMessage.setTargetXAddressInfo(xAddressInfo);
        invokeMessage.setContent(parameterValue);
        MyResponseCallBack myResponseCallBack = new MyResponseCallBack(xAddressInfo);
        OutDispatcher.getInstance().send(invokeMessage, xAddressInfo, (ResponseCallback)myResponseCallBack);
        if (bl) {
            return myResponseCallBack.waitForMe();
        }
        return null;
    }

    private static URI discover(String string) {
        int n = string.lastIndexOf(47);
        String string2 = string.substring(0, n);
        n = string2.lastIndexOf(47);
        String string3 = string2.substring(0, n);
        String string4 = string2.substring(n + 1, string2.length());
        QName qName = new QName(string4, string3);
        SearchParameter searchParameter = new SearchParameter();
        searchParameter.setServiceTypes(new QNameSet(qName));
        MySearchCallback mySearchCallback = new MySearchCallback();
        SearchManager.searchService(searchParameter, mySearchCallback);
        return mySearchCallback.waitForMe();
    }

    private static class MyResponseCallBack
    extends DefaultResponseCallback {
        private volatile boolean pending = true;
        private ParameterValue response = null;
        private InvocationException invocationException = null;
        private TimeoutException timeoutException = null;

        MyResponseCallBack(XAddressInfo xAddressInfo) {
            super(xAddressInfo);
        }

        public synchronized void handle(Message message, InvokeMessage invokeMessage, ProtocolData protocolData) {
            this.response = invokeMessage.getContent();
            this.unsync();
        }

        public synchronized void handle(Message message, FaultMessage faultMessage, ProtocolData protocolData) {
            this.invocationException = new InvocationException(faultMessage);
            this.unsync();
        }

        public synchronized void handleTransmissionException(Message message, Exception exception, ProtocolData protocolData) {
            Log.error("Transmission error: " + exception);
            this.unsync();
        }

        public synchronized void handleMalformedResponseException(Message message, Exception exception, ProtocolData protocolData) {
            Log.error("Malformed response: " + exception);
            this.unsync();
        }

        public synchronized void handleTimeout(Message message) {
            Log.error("Request timeout: " + message);
            this.timeoutException = new TimeoutException("Invocation timeout");
            this.unsync();
        }

        synchronized ParameterValue waitForMe() throws InvocationException, TimeoutException {
            while (this.pending) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    Log.printStackTrace(interruptedException);
                }
            }
            if (this.timeoutException != null) {
                throw this.timeoutException;
            }
            if (this.invocationException != null) {
                throw this.invocationException;
            }
            return this.response;
        }

        private void unsync() {
            this.pending = false;
            this.notify();
        }
    }

    private static class MySearchCallback
    extends TimedEntry
    implements SearchCallback {
        private volatile boolean pending = true;
        private URI address = null;

        private MySearchCallback() {
        }

        public void deviceFound(DeviceReference deviceReference, SearchParameter searchParameter) {
        }

        public synchronized void serviceFound(ServiceReference serviceReference, SearchParameter searchParameter) {
            try {
                this.address = serviceReference.getPreferredXAddress();
                this.unsync();
            }
            catch (TimeoutException timeoutException) {
                Log.error("Unable to obtain transport addres of service: " + timeoutException);
            }
        }

        protected synchronized void timedOut() {
            Log.error("Service discovery timeout.");
            this.unsync();
        }

        synchronized URI waitForMe() {
            WatchDog.getInstance().register(this, DispatchingProperties.getInstance().getMatchWaitTime());
            while (this.pending) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    Log.printStackTrace(interruptedException);
                }
            }
            WatchDog.getInstance().unregister(this);
            return this.address;
        }

        private void unsync() {
            this.pending = false;
            this.notify();
        }
    }
}

