/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.communication;

import java.io.IOException;
import org.ws4d.java.communication.CommunicationManager;
import org.ws4d.java.concurrency.LockSupport;
import org.ws4d.java.concurrency.Lockable;
import org.ws4d.java.structures.ArrayList;
import org.ws4d.java.structures.DataStructure;
import org.ws4d.java.structures.HashMap;
import org.ws4d.java.structures.Iterator;
import org.ws4d.java.structures.ReadOnlyIterator;
import org.ws4d.java.util.Log;

public abstract class CommunicationManagerRegistry {
    public static final String DEFAULT_CM_PACKAGE = "org.ws4d.java.communication";
    public static final String DEFAULT_CM_SUFFIX = "CommunicationManager";
    public static final String[] DEFAULT_COMMUNICATION_MANAGERS = new String[]{"DPWS"};
    private static final HashMap COM_MANAGERS = new HashMap(5);
    private static final Lockable lockSupport = new LockSupport();

    public static String getDefault() {
        return DEFAULT_COMMUNICATION_MANAGERS.length > 0 ? DEFAULT_COMMUNICATION_MANAGERS[0] : CommunicationManager.ID_NULL;
    }

    public static void loadAll() {
        for (int i = 0; i < DEFAULT_COMMUNICATION_MANAGERS.length; ++i) {
            CommunicationManagerRegistry.load(DEFAULT_COMMUNICATION_MANAGERS[i]);
        }
    }

    public static void load(String string) {
        CommunicationManagerRegistry.loadInternal(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CommunicationManager getManager(String string) {
        lockSupport.sharedLock();
        try {
            CommunicationManager communicationManager = (CommunicationManager)COM_MANAGERS.get(string);
            return communicationManager;
        }
        finally {
            lockSupport.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Iterator getLoadedManagers() {
        lockSupport.sharedLock();
        try {
            ArrayList arrayList = new ArrayList(COM_MANAGERS.size());
            ((DataStructure)arrayList).addAll(COM_MANAGERS.values());
            ReadOnlyIterator readOnlyIterator = new ReadOnlyIterator(arrayList);
            return readOnlyIterator;
        }
        finally {
            lockSupport.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startAll() {
        lockSupport.sharedLock();
        try {
            Iterator iterator = COM_MANAGERS.values().iterator();
            while (iterator.hasNext()) {
                CommunicationManager communicationManager = (CommunicationManager)iterator.next();
                try {
                    communicationManager.start();
                    if (!Log.isDebug()) continue;
                    Log.debug("Communication Manager " + communicationManager.getCommunicationManagerId() + " started.", 1);
                }
                catch (IOException iOException) {
                    Log.error("Unable to start Communication Manager " + communicationManager.getCommunicationManagerId() + ": " + iOException);
                }
            }
        }
        finally {
            lockSupport.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stopAll() {
        lockSupport.sharedLock();
        try {
            Iterator iterator = COM_MANAGERS.values().iterator();
            while (iterator.hasNext()) {
                CommunicationManager communicationManager = (CommunicationManager)iterator.next();
                communicationManager.stop();
            }
            lockSupport.exclusiveLock();
            try {
                COM_MANAGERS.clear();
            }
            finally {
                lockSupport.releaseExclusiveLock();
            }
        }
        finally {
            lockSupport.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void killAll() {
        lockSupport.sharedLock();
        try {
            Iterator iterator = COM_MANAGERS.values().iterator();
            while (iterator.hasNext()) {
                CommunicationManager communicationManager = (CommunicationManager)iterator.next();
                communicationManager.kill();
            }
        }
        finally {
            lockSupport.releaseSharedLock();
        }
        lockSupport.exclusiveLock();
        try {
            COM_MANAGERS.clear();
        }
        finally {
            lockSupport.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadInternal(String string) {
        lockSupport.exclusiveLock();
        try {
            if (string == CommunicationManager.ID_NULL || COM_MANAGERS.containsKey(string)) {
                return;
            }
            if (Log.isDebug()) {
                Log.debug("Loading Communication Manager " + string + "...", 1);
            }
            String string2 = "org.ws4d.java.communication." + string + DEFAULT_CM_SUFFIX;
            try {
                Class<?> clazz = Class.forName(string2);
                CommunicationManager communicationManager = (CommunicationManager)clazz.newInstance();
                communicationManager.init();
                COM_MANAGERS.put(string, communicationManager);
                if (Log.isDebug()) {
                    Log.debug("Communication Manager " + string + " initialized.", 1);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                Log.error("Unable to find class " + string2);
            }
            catch (IllegalAccessException illegalAccessException) {
                Log.error("Can not access class or default constructor of class " + string2);
            }
            catch (InstantiationException instantiationException) {
                Log.error("Unable to create instance of class " + string2);
            }
        }
        finally {
            lockSupport.releaseExclusiveLock();
        }
    }

    private CommunicationManagerRegistry() {
    }
}

