/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.communication.DPWS2006;

import org.ws4d.java.communication.CommunicationUtil;
import org.ws4d.java.communication.DPWS2006.DefaultConstantsHelper2006;
import org.ws4d.java.communication.DPWS2009.DefaultConstantsHelper2009;
import org.ws4d.java.constants.ConstantsHelper;
import org.ws4d.java.constants.DPWSConstants;
import org.ws4d.java.constants.DPWSConstants2006;
import org.ws4d.java.constants.WSAConstants2006;
import org.ws4d.java.io.xml.ElementHandlerRegistry;
import org.ws4d.java.message.FaultMessage;
import org.ws4d.java.message.Message;
import org.ws4d.java.message.SOAPHeader;
import org.ws4d.java.message.discovery.ByeMessage;
import org.ws4d.java.message.discovery.HelloMessage;
import org.ws4d.java.message.discovery.ProbeMatch;
import org.ws4d.java.message.discovery.ProbeMatchesMessage;
import org.ws4d.java.message.discovery.ProbeMessage;
import org.ws4d.java.message.discovery.ResolveMatchesMessage;
import org.ws4d.java.message.discovery.ResolveMessage;
import org.ws4d.java.message.eventing.SubscribeMessage;
import org.ws4d.java.message.metadata.GetMessage;
import org.ws4d.java.message.metadata.GetMetadataMessage;
import org.ws4d.java.message.metadata.GetMetadataResponseMessage;
import org.ws4d.java.message.metadata.GetResponseMessage;
import org.ws4d.java.structures.Iterator;
import org.ws4d.java.types.AttributedURI;
import org.ws4d.java.types.DiscoveryData;
import org.ws4d.java.types.EndpointReference;
import org.ws4d.java.types.QNameSet;
import org.ws4d.java.types.ServiceId;
import org.ws4d.java.util.Log;

public class DefaultDPWSCommunicatonUtil
implements CommunicationUtil {
    private static DefaultDPWSCommunicatonUtil instance = null;

    public ConstantsHelper getHelper(int n) {
        ConstantsHelper constantsHelper = null;
        if (n == -1) {
            n = 0;
        }
        switch (n) {
            case 0: {
                constantsHelper = new DefaultConstantsHelper2009();
                break;
            }
            case 1: {
                constantsHelper = new DefaultConstantsHelper2006();
            }
        }
        return constantsHelper;
    }

    public static synchronized DefaultDPWSCommunicatonUtil getInstance() {
        if (instance == null) {
            ElementHandlerRegistry.getRegistry().registerElementHandler(ServiceId.QNAME, new ServiceId());
            instance = new DefaultDPWSCommunicatonUtil();
        }
        return instance;
    }

    public Message changeOutgoingMessage(int n, Message message) {
        switch (message.getType()) {
            case 1: {
                return this.changeOutgoingMessage(n, (HelloMessage)message);
            }
            case 2: {
                return this.changeOutgoingMessage(n, (ByeMessage)message);
            }
            case 3: {
                return this.changeOutgoingMessage(n, (ProbeMessage)message);
            }
            case 4: {
                return this.changeOutgoingMessage(n, (ProbeMatchesMessage)message);
            }
            case 5: {
                return this.changeOutgoingMessage(n, (ResolveMessage)message);
            }
            case 6: {
                return this.changeOutgoingMessage(n, (ResolveMatchesMessage)message);
            }
            case 101: {
                return this.changeOutgoingMessage(n, (GetMessage)message);
            }
            case 102: {
                return this.changeOutgoingMessage(n, (GetResponseMessage)message);
            }
            case 201: {
                return this.changeOutgoingMessage(n, (GetMetadataMessage)message);
            }
            case 202: {
                return this.changeOutgoingMessage(n, (GetMetadataResponseMessage)message);
            }
            case 301: {
                return this.changeOutgoingMessage(n, (SubscribeMessage)message);
            }
            case 500: {
                return this.changeOutgoingMessage(n, (FaultMessage)message);
            }
        }
        return message;
    }

    private Message changeOutgoingMessage(int n, HelloMessage helloMessage) {
        if (1 == n) {
            helloMessage.getHeader().setAction(new AttributedURI("http://schemas.xmlsoap.org/ws/2005/04/discovery/Hello"));
            if (helloMessage.getHeader().getTo() != null) {
                helloMessage.getHeader().setTo(new AttributedURI("urn:schemas-xmlsoap-org:ws:2005:04:discovery"));
            }
            this.changeTypesTo2006(helloMessage.getTypes());
        } else if (0 == n) {
            this.changeTypesTo2009(helloMessage.getTypes());
        }
        return helloMessage;
    }

    private Message changeOutgoingMessage(int n, ByeMessage byeMessage) {
        if (1 == n) {
            byeMessage.getHeader().setAction(new AttributedURI("http://schemas.xmlsoap.org/ws/2005/04/discovery/Bye"));
            if (byeMessage.getHeader().getTo() != null) {
                byeMessage.getHeader().setTo(new AttributedURI("urn:schemas-xmlsoap-org:ws:2005:04:discovery"));
            }
            this.changeTypesTo2006(byeMessage.getTypes());
        } else if (0 == n) {
            this.changeTypesTo2009(byeMessage.getTypes());
        }
        return byeMessage;
    }

    private Message changeOutgoingMessage(int n, ProbeMessage probeMessage) {
        if (1 == n) {
            probeMessage.getHeader().setAction(new AttributedURI("http://schemas.xmlsoap.org/ws/2005/04/discovery/Probe"));
            probeMessage.getHeader().setTo(new AttributedURI("urn:schemas-xmlsoap-org:ws:2005:04:discovery"));
        }
        return probeMessage;
    }

    private Message changeOutgoingMessage(int n, ProbeMatchesMessage probeMatchesMessage) {
        block5: {
            block4: {
                if (1 != n) break block4;
                probeMatchesMessage.getHeader().setAction(new AttributedURI("http://schemas.xmlsoap.org/ws/2005/04/discovery/ProbeMatches"));
                if (probeMatchesMessage.getHeader().getTo() != null) {
                    probeMatchesMessage.getHeader().setTo(new AttributedURI(WSAConstants2006.WSA_ANONYMOUS));
                }
                if (probeMatchesMessage.getProbeMatchCount() <= 0) break block5;
                Iterator iterator = probeMatchesMessage.getProbeMatches().iterator();
                while (iterator.hasNext()) {
                    ProbeMatch probeMatch = (ProbeMatch)iterator.next();
                    this.changeTypesTo2006(probeMatch.getTypes());
                }
                break block5;
            }
            if (0 == n && probeMatchesMessage.getProbeMatchCount() > 0) {
                Iterator iterator = probeMatchesMessage.getProbeMatches().iterator();
                while (iterator.hasNext()) {
                    ProbeMatch probeMatch = (ProbeMatch)iterator.next();
                    this.changeTypesTo2009(probeMatch.getTypes());
                }
            }
        }
        return probeMatchesMessage;
    }

    private Message changeOutgoingMessage(int n, ResolveMessage resolveMessage) {
        if (1 == n) {
            resolveMessage.getHeader().setAction(new AttributedURI("http://schemas.xmlsoap.org/ws/2005/04/discovery/Resolve"));
            resolveMessage.getHeader().setTo(new AttributedURI("urn:schemas-xmlsoap-org:ws:2005:04:discovery"));
        }
        return resolveMessage;
    }

    private Message changeOutgoingMessage(int n, ResolveMatchesMessage resolveMatchesMessage) {
        if (1 == n) {
            resolveMatchesMessage.getHeader().setAction(new AttributedURI("http://schemas.xmlsoap.org/ws/2005/04/discovery/ResolveMatches"));
            if (resolveMatchesMessage.getHeader().getTo() != null) {
                resolveMatchesMessage.getHeader().setTo(new AttributedURI(WSAConstants2006.WSA_ANONYMOUS));
            }
            if (resolveMatchesMessage.getResolveMatch() != null) {
                this.changeTypesTo2006(resolveMatchesMessage.getResolveMatch().getTypes());
            }
        } else if (0 == n && resolveMatchesMessage.getResolveMatch() != null) {
            this.changeTypesTo2009(resolveMatchesMessage.getResolveMatch().getTypes());
        }
        return resolveMatchesMessage;
    }

    private Message changeOutgoingMessage(int n, GetMessage getMessage) {
        if (1 == n) {
            getMessage.getHeader().setReplyTo(new EndpointReference(WSAConstants2006.WSA_ANONYMOUS));
        }
        return getMessage;
    }

    private Message changeOutgoingMessage(int n, GetResponseMessage getResponseMessage) {
        if (1 == n) {
            if (getResponseMessage.getHeader().getTo() != null) {
                getResponseMessage.getHeader().setTo(new AttributedURI(WSAConstants2006.WSA_ANONYMOUS));
            }
            this.changeTypesTo2006(getResponseMessage.getHost().getTypes());
            getResponseMessage.getHost().addUnknownElement(ServiceId.QNAME, DPWSConstants2006.DPWS_DEVICE_SERVICEID);
        } else if (0 == n) {
            this.changeTypesTo2009(getResponseMessage.getHost().getTypes());
        }
        return getResponseMessage;
    }

    public Message changeOutgoingMessage(int n, GetMetadataMessage getMetadataMessage) {
        if (1 == n) {
            GetMessage getMessage = new GetMessage(getMetadataMessage.getHeader().getCommunicationManagerID());
            this.copyOutgoingHeader(getMessage.getHeader(), getMetadataMessage);
            getMessage.setProtocolInfo(getMetadataMessage.getProtocolInfo());
            this.copyOutgoingInheritAttributes(getMessage, getMetadataMessage);
            getMessage.getHeader().setAction(new AttributedURI("http://schemas.xmlsoap.org/ws/2004/09/transfer/Get"));
            getMessage.getHeader().setReplyTo(new EndpointReference(WSAConstants2006.WSA_ANONYMOUS));
            return getMessage;
        }
        return getMetadataMessage;
    }

    private Message changeOutgoingMessage(int n, GetMetadataResponseMessage getMetadataResponseMessage) {
        if (1 == n) {
            getMetadataResponseMessage.getHeader().setAction(new AttributedURI("http://schemas.xmlsoap.org/ws/2004/09/transfer/GetResponse"));
        }
        return getMetadataResponseMessage;
    }

    private Message changeOutgoingMessage(int n, SubscribeMessage subscribeMessage) {
        if (1 == n) {
            subscribeMessage.getFilter().setDialect(DPWSConstants2006.DPWS_URI_FILTER_EVENTING_ACTION);
        }
        return subscribeMessage;
    }

    private Message changeOutgoingMessage(int n, FaultMessage faultMessage) {
        if (1 == n) {
            faultMessage.getHeader().setAction(new AttributedURI(DefaultConstantsHelper2006.getInstance().getWSAActionAddressingFault()));
            faultMessage.setSubcode(DefaultConstantsHelper2006.getInstance().getWSAFaultMessageAddressingHeaderRequired());
        }
        return faultMessage;
    }

    public Message copyOutgoingMessage(Message message) {
        if (message instanceof HelloMessage) {
            return this.copyOutgoingMessage((HelloMessage)message);
        }
        if (message instanceof ByeMessage) {
            return this.copyOutgoingMessage((ByeMessage)message);
        }
        if (message instanceof ProbeMessage) {
            return this.copyOutgoingMessage((ProbeMessage)message);
        }
        if (message instanceof ResolveMessage) {
            return this.copyOutgoingMessage((ResolveMessage)message);
        }
        if (message instanceof GetMessage) {
            return this.copyOutgoingMessage((GetMessage)message);
        }
        if (Log.isWarn()) {
            Log.warn("CopyOutgoingMessage(...) does not support messages of type " + message.getClass().getName());
        }
        return message;
    }

    private DiscoveryData copyDiscoveryData(DiscoveryData discoveryData) {
        QNameSet qNameSet = new QNameSet(discoveryData.getTypes());
        DiscoveryData discoveryData2 = new DiscoveryData(discoveryData);
        discoveryData2.setTypes(qNameSet);
        return discoveryData2;
    }

    private Message copyOutgoingMessage(HelloMessage helloMessage) {
        HelloMessage helloMessage2 = new HelloMessage(this.copyDiscoveryData(helloMessage.getDiscoveryData()), helloMessage.getHeader().getCommunicationManagerID());
        this.copyOutgoingHeader(helloMessage2.getHeader(), helloMessage);
        this.copyOutgoingInheritAttributes(helloMessage2, helloMessage);
        return helloMessage2;
    }

    private Message copyOutgoingMessage(ByeMessage byeMessage) {
        ByeMessage byeMessage2 = new ByeMessage(this.copyDiscoveryData(byeMessage.getDiscoveryData()), byeMessage.getHeader().getCommunicationManagerID());
        this.copyOutgoingHeader(byeMessage2.getHeader(), byeMessage);
        this.copyOutgoingInheritAttributes(byeMessage2, byeMessage);
        return byeMessage2;
    }

    private Message copyOutgoingMessage(ProbeMessage probeMessage) {
        ProbeMessage probeMessage2 = new ProbeMessage(probeMessage.getHeader().getCommunicationManagerID());
        this.copyOutgoingHeader(probeMessage2.getHeader(), probeMessage);
        probeMessage2.setTypes(probeMessage.getTypes());
        probeMessage2.setScopes(probeMessage.getScopes());
        probeMessage2.setDirected(probeMessage.isDirected());
        this.copyOutgoingInheritAttributes(probeMessage2, probeMessage);
        return probeMessage2;
    }

    private Message copyOutgoingMessage(ResolveMessage resolveMessage) {
        ResolveMessage resolveMessage2 = new ResolveMessage(resolveMessage.getHeader().getCommunicationManagerID());
        this.copyOutgoingHeader(resolveMessage2.getHeader(), resolveMessage);
        resolveMessage2.setEndpointReference(resolveMessage.getEndpointReference());
        this.copyOutgoingInheritAttributes(resolveMessage2, resolveMessage);
        return resolveMessage2;
    }

    private Message copyOutgoingMessage(GetMessage getMessage) {
        GetMessage getMessage2 = new GetMessage(getMessage.getHeader().getCommunicationManagerID());
        this.copyOutgoingHeader(getMessage2.getHeader(), getMessage);
        getMessage2.getHeader().setReplyTo(new EndpointReference(WSAConstants2006.WSA_ANONYMOUS));
        this.copyOutgoingInheritAttributes(getMessage2, getMessage);
        return getMessage2;
    }

    private void copyOutgoingHeader(SOAPHeader sOAPHeader, Message message) {
        EndpointReference endpointReference;
        sOAPHeader.setAction(new AttributedURI(message.getAction().toString()));
        sOAPHeader.setMessageId(message.getMessageId());
        AttributedURI attributedURI = message.getRelatesTo();
        if (attributedURI != null) {
            sOAPHeader.setRelatesTo(new AttributedURI(attributedURI.toString()));
        }
        if ((endpointReference = message.getReplyTo()) != null) {
            sOAPHeader.setReplyTo(new EndpointReference(endpointReference.getAddress()));
        }
        if ((attributedURI = message.getTo()) != null) {
            sOAPHeader.setTo(new AttributedURI(message.getTo().toString()));
        }
        sOAPHeader.setAppSequence(message.getAppSequence());
        sOAPHeader.setReferenceParameters(message.getHeader().getReferenceParameters());
        sOAPHeader.setSignature(message.getHeader().getSignature());
        sOAPHeader.setValidated(message.getHeader().isValidated());
    }

    private void copyOutgoingInheritAttributes(Message message, Message message2) {
        message.setInbound(message2.isInbound());
        message.setTargetXAddressInfo(message2.getTargetXAddressInfo());
        message.setSecure(message2.isSecure());
        message.setCertificate(message2.getCertificate());
        message.setPrivateKey(message2.getPrivateKey());
    }

    public void changeIncomingProbe(ProbeMessage probeMessage) {
        this.changeTypesTo2009(probeMessage.getTypes());
    }

    private void changeTypesTo2009(QNameSet qNameSet) {
        if (qNameSet.contains(DPWSConstants2006.DPWS_QN_DEVICETYPE) && !qNameSet.contains(DPWSConstants.DPWS_QN_DEVICETYPE)) {
            qNameSet.remove(DPWSConstants2006.DPWS_QN_DEVICETYPE);
            qNameSet.add(DPWSConstants.DPWS_QN_DEVICETYPE);
        }
    }

    private void changeTypesTo2006(QNameSet qNameSet) {
        if (qNameSet != null && qNameSet.contains(DPWSConstants.DPWS_QN_DEVICETYPE) && !qNameSet.contains(DPWSConstants2006.DPWS_QN_DEVICETYPE)) {
            qNameSet.remove(DPWSConstants.DPWS_QN_DEVICETYPE);
            qNameSet.add(DPWSConstants2006.DPWS_QN_DEVICETYPE);
        }
    }
}

