/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.communication;

import org.ws4d.java.communication.ProtocolDomain;
import org.ws4d.java.communication.connection.ip.IPAddress;
import org.ws4d.java.communication.connection.ip.NetworkInterface;

public class DPWSDomain
implements ProtocolDomain {
    private final String[] ids = new String[2];
    private final NetworkInterface iface;
    private final IPAddress ipAddress;
    private final boolean supportsMulticast;
    private final boolean isUp;

    private static boolean arraysEqual(Object[] objectArray, Object[] objectArray2) {
        if (objectArray == objectArray2) {
            return true;
        }
        if (objectArray == null) {
            return objectArray2 == null;
        }
        if (objectArray2 == null) {
            return false;
        }
        int n = objectArray.length;
        int n2 = objectArray2.length;
        if (n != n2) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if ((objectArray[i] == null || objectArray[i].equals(objectArray2[i])) && (objectArray[i] != null || objectArray2[i] == null)) continue;
            return false;
        }
        return true;
    }

    private static int hashCode(Object[] objectArray) {
        int n = 31;
        if (objectArray == null) {
            return 0;
        }
        int n2 = 1;
        for (int i = 0; i < objectArray.length; ++i) {
            n2 = n * n2 + (objectArray[i] == null ? 0 : objectArray[i].hashCode());
        }
        return n2;
    }

    public DPWSDomain(NetworkInterface networkInterface, IPAddress iPAddress, boolean bl, boolean bl2) {
        this.ids[0] = networkInterface.getName();
        this.ids[1] = iPAddress.getAddressWithoutNicId();
        this.iface = networkInterface;
        this.ipAddress = iPAddress;
        this.supportsMulticast = bl;
        this.isUp = bl2;
    }

    public DPWSDomain(NetworkInterface networkInterface, IPAddress iPAddress) {
        this(networkInterface, iPAddress, true, true);
    }

    public String toString() {
        return this.getHostAddress() + " - " + this.getInterfaceName();
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + DPWSDomain.hashCode(this.ids);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        DPWSDomain dPWSDomain = (DPWSDomain)object;
        return DPWSDomain.arraysEqual(this.ids, dPWSDomain.ids);
    }

    public String[] getDomainIds() {
        return this.ids;
    }

    public String getCommunicationManagerId() {
        return "DPWS";
    }

    public String getInterfaceName() {
        return this.ids[0];
    }

    public String getHostAddress() {
        return this.ids[1];
    }

    public NetworkInterface getIface() {
        return this.iface;
    }

    public IPAddress getIPAddress() {
        return this.ipAddress;
    }

    public boolean supportsMulticast() {
        return this.supportsMulticast;
    }

    public boolean isUp() {
        return this.isUp;
    }
}

