/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.communication;

import org.ws4d.java.communication.IncomingMessageListener;
import org.ws4d.java.communication.ProtocolData;
import org.ws4d.java.message.FaultMessage;
import org.ws4d.java.message.InvokeMessage;
import org.ws4d.java.message.Message;
import org.ws4d.java.message.SOAPException;
import org.ws4d.java.message.discovery.ByeMessage;
import org.ws4d.java.message.discovery.HelloMessage;
import org.ws4d.java.message.discovery.ProbeMatchesMessage;
import org.ws4d.java.message.discovery.ProbeMessage;
import org.ws4d.java.message.discovery.ResolveMatchesMessage;
import org.ws4d.java.message.discovery.ResolveMessage;
import org.ws4d.java.message.eventing.GetStatusMessage;
import org.ws4d.java.message.eventing.GetStatusResponseMessage;
import org.ws4d.java.message.eventing.RenewMessage;
import org.ws4d.java.message.eventing.RenewResponseMessage;
import org.ws4d.java.message.eventing.SubscribeMessage;
import org.ws4d.java.message.eventing.SubscribeResponseMessage;
import org.ws4d.java.message.eventing.SubscriptionEndMessage;
import org.ws4d.java.message.eventing.UnsubscribeMessage;
import org.ws4d.java.message.eventing.UnsubscribeResponseMessage;
import org.ws4d.java.message.metadata.GetMessage;
import org.ws4d.java.message.metadata.GetMetadataMessage;
import org.ws4d.java.message.metadata.GetMetadataResponseMessage;
import org.ws4d.java.message.metadata.GetResponseMessage;
import org.ws4d.java.service.OperationDescription;
import org.ws4d.java.util.Log;

public class DefaultIncomingMessageListener
implements IncomingMessageListener {
    private static void logRequest(Message message) {
        Log.info("Unhandled request: " + message);
    }

    private static SOAPException actionNotSupportedException(Message message) {
        DefaultIncomingMessageListener.logRequest(message);
        return new SOAPException(FaultMessage.createActionNotSupportedFault(message));
    }

    public void handle(HelloMessage helloMessage, ProtocolData protocolData) {
        DefaultIncomingMessageListener.logRequest(helloMessage);
    }

    public void handle(ByeMessage byeMessage, ProtocolData protocolData) {
        DefaultIncomingMessageListener.logRequest(byeMessage);
    }

    public ProbeMatchesMessage handle(ProbeMessage probeMessage, ProtocolData protocolData) throws SOAPException {
        DefaultIncomingMessageListener.logRequest(probeMessage);
        if (probeMessage.isDirected()) {
            ProbeMatchesMessage probeMatchesMessage = new ProbeMatchesMessage(probeMessage.getHeader().getCommunicationManagerID());
            probeMatchesMessage.setResponseTo(probeMessage);
            return probeMatchesMessage;
        }
        return null;
    }

    public ResolveMatchesMessage handle(ResolveMessage resolveMessage, ProtocolData protocolData) {
        DefaultIncomingMessageListener.logRequest(resolveMessage);
        return null;
    }

    public GetResponseMessage handle(GetMessage getMessage, ProtocolData protocolData) throws SOAPException {
        throw DefaultIncomingMessageListener.actionNotSupportedException(getMessage);
    }

    public GetMetadataResponseMessage handle(GetMetadataMessage getMetadataMessage, ProtocolData protocolData) throws SOAPException {
        throw DefaultIncomingMessageListener.actionNotSupportedException(getMetadataMessage);
    }

    public SubscribeResponseMessage handle(SubscribeMessage subscribeMessage, ProtocolData protocolData) throws SOAPException {
        throw DefaultIncomingMessageListener.actionNotSupportedException(subscribeMessage);
    }

    public GetStatusResponseMessage handle(GetStatusMessage getStatusMessage, ProtocolData protocolData) throws SOAPException {
        throw DefaultIncomingMessageListener.actionNotSupportedException(getStatusMessage);
    }

    public RenewResponseMessage handle(RenewMessage renewMessage, ProtocolData protocolData) throws SOAPException {
        throw DefaultIncomingMessageListener.actionNotSupportedException(renewMessage);
    }

    public UnsubscribeResponseMessage handle(UnsubscribeMessage unsubscribeMessage, ProtocolData protocolData) throws SOAPException {
        throw DefaultIncomingMessageListener.actionNotSupportedException(unsubscribeMessage);
    }

    public void handle(SubscriptionEndMessage subscriptionEndMessage, ProtocolData protocolData) {
        DefaultIncomingMessageListener.logRequest(subscriptionEndMessage);
    }

    public InvokeMessage handle(InvokeMessage invokeMessage, ProtocolData protocolData) throws SOAPException {
        throw DefaultIncomingMessageListener.actionNotSupportedException(invokeMessage);
    }

    public OperationDescription getOperation(String string) {
        return null;
    }
}

