/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.communication;

import org.ws4d.java.DPWSFramework;
import org.ws4d.java.communication.CommunicationManager;
import org.ws4d.java.communication.CommunicationManagerRegistry;
import org.ws4d.java.communication.ProtocolDomain;
import org.ws4d.java.structures.ArrayList;
import org.ws4d.java.structures.DataStructure;
import org.ws4d.java.structures.HashMap;
import org.ws4d.java.structures.HashSet;
import org.ws4d.java.structures.Iterator;
import org.ws4d.java.util.Log;

public final class Discovery {
    private static final DataStructure DEFAULT_OUTPUT_DOMAINS = new HashSet();
    private static final HashMap DOMAIN_CACHE = new HashMap();
    static DataStructure domains = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataStructure getDefaultOutputDomains() {
        DataStructure dataStructure = DEFAULT_OUTPUT_DOMAINS;
        synchronized (dataStructure) {
            return new HashSet(DEFAULT_OUTPUT_DOMAINS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addDefaultOutputDomain(ProtocolDomain protocolDomain) {
        if (protocolDomain == null) {
            return;
        }
        DataStructure dataStructure = DEFAULT_OUTPUT_DOMAINS;
        synchronized (dataStructure) {
            DEFAULT_OUTPUT_DOMAINS.add(protocolDomain);
        }
        if (Log.isDebug()) {
            Log.debug("Output Discovery over " + protocolDomain.getCommunicationManagerId() + ", " + protocolDomain, 4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeDefaultOutputDomain(ProtocolDomain protocolDomain) {
        if (protocolDomain == null) {
            return;
        }
        DataStructure dataStructure = DEFAULT_OUTPUT_DOMAINS;
        synchronized (dataStructure) {
            DEFAULT_OUTPUT_DOMAINS.remove(protocolDomain);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearDefaultOutputDomains() {
        DataStructure dataStructure = DEFAULT_OUTPUT_DOMAINS;
        synchronized (dataStructure) {
            DEFAULT_OUTPUT_DOMAINS.clear();
        }
    }

    public static DataStructure getAllAvailableDomains() {
        Object object;
        ArrayList arrayList = new ArrayList();
        Iterator iterator = CommunicationManagerRegistry.getLoadedManagers();
        while (iterator.hasNext()) {
            object = (CommunicationManager)iterator.next();
            ((DataStructure)arrayList).addAll(object.getAvailableDomains());
        }
        if (Log.isDebug() && !domains.equals(arrayList)) {
            Log.debug("-------------------------------------------", 4);
            iterator = ((DataStructure)arrayList).iterator();
            while (iterator.hasNext()) {
                object = (ProtocolDomain)iterator.next();
                Log.debug("Found Protocol Domain: " + object.getCommunicationManagerId() + ", " + object.toString(), 4);
            }
            Log.debug("-------------------------------------------", 4);
        }
        if (domains == null || domains.size() == 0) {
            domains = arrayList;
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProtocolDomain getDomain(String string, String string2) {
        if (string == null) {
            return null;
        }
        HashMap hashMap = DOMAIN_CACHE;
        synchronized (hashMap) {
            ProtocolDomain protocolDomain = (ProtocolDomain)DOMAIN_CACHE.get(string + (string2 == null ? "" : string2));
            if (protocolDomain != null) {
                return protocolDomain;
            }
            CommunicationManager communicationManager = DPWSFramework.getCommunicationManager(string);
            if (communicationManager == null) {
                Log.warn("No communication manager found for protocol ID " + string);
                return null;
            }
            DataStructure dataStructure = communicationManager.getAvailableDomains();
            if (dataStructure == null || dataStructure.isEmpty()) {
                Log.warn("Communication manager for protocol ID " + string + " has no available domains");
                return null;
            }
            Iterator iterator = dataStructure.iterator();
            while (iterator.hasNext()) {
                protocolDomain = (ProtocolDomain)iterator.next();
                String[] stringArray = protocolDomain.getDomainIds();
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!stringArray[i].equals(string2)) continue;
                    DOMAIN_CACHE.put(string + string2, protocolDomain);
                    return protocolDomain;
                }
            }
        }
        Log.warn("No protocol domain found with domain ID " + string2);
        return null;
    }

    private Discovery() {
    }
}

