/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.communication;

import org.ws4d.java.communication.ProtocolData;
import org.ws4d.java.communication.ResponseCallback;
import org.ws4d.java.message.FaultMessage;
import org.ws4d.java.message.InvokeMessage;
import org.ws4d.java.message.Message;
import org.ws4d.java.message.discovery.ProbeMatchesMessage;
import org.ws4d.java.message.discovery.ResolveMatchesMessage;
import org.ws4d.java.message.eventing.GetStatusResponseMessage;
import org.ws4d.java.message.eventing.RenewResponseMessage;
import org.ws4d.java.message.eventing.SubscribeResponseMessage;
import org.ws4d.java.message.eventing.UnsubscribeResponseMessage;
import org.ws4d.java.message.metadata.GetMetadataResponseMessage;
import org.ws4d.java.message.metadata.GetResponseMessage;
import org.ws4d.java.service.OperationDescription;
import org.ws4d.java.types.XAddressInfo;

public class FaultAwareResponseCallback
implements ResponseCallback {
    private final ResponseCallback callback;
    private final int supportedVersionsCount;
    private volatile boolean responseReceived = false;
    private int receivedFaultCount = 0;
    private XAddressInfo targetXAddressInfo = null;

    FaultAwareResponseCallback(XAddressInfo xAddressInfo, ResponseCallback responseCallback, int n) {
        this.targetXAddressInfo = xAddressInfo;
        this.callback = responseCallback;
        this.supportedVersionsCount = n;
    }

    public synchronized void handle(Message message, ProbeMatchesMessage probeMatchesMessage, ProtocolData protocolData) {
        this.responseReceived = true;
        this.callback.handle(message, probeMatchesMessage, protocolData);
    }

    public synchronized void handle(Message message, ResolveMatchesMessage resolveMatchesMessage, ProtocolData protocolData) {
        this.responseReceived = true;
        this.callback.handle(message, resolveMatchesMessage, protocolData);
    }

    public synchronized void handle(Message message, GetResponseMessage getResponseMessage, ProtocolData protocolData) {
        this.responseReceived = true;
        this.callback.handle(message, getResponseMessage, protocolData);
    }

    public synchronized void handle(Message message, GetMetadataResponseMessage getMetadataResponseMessage, ProtocolData protocolData) {
        this.responseReceived = true;
        this.callback.handle(message, getMetadataResponseMessage, protocolData);
    }

    public synchronized void handle(Message message, SubscribeResponseMessage subscribeResponseMessage, ProtocolData protocolData) {
        this.responseReceived = true;
        this.callback.handle(message, subscribeResponseMessage, protocolData);
    }

    public synchronized void handle(Message message, GetStatusResponseMessage getStatusResponseMessage, ProtocolData protocolData) {
        this.responseReceived = true;
        this.callback.handle(message, getStatusResponseMessage, protocolData);
    }

    public synchronized void handle(Message message, RenewResponseMessage renewResponseMessage, ProtocolData protocolData) {
        this.responseReceived = true;
        this.callback.handle(message, renewResponseMessage, protocolData);
    }

    public synchronized void handle(Message message, UnsubscribeResponseMessage unsubscribeResponseMessage, ProtocolData protocolData) {
        this.responseReceived = true;
        this.callback.handle(message, unsubscribeResponseMessage, protocolData);
    }

    public synchronized void handle(Message message, InvokeMessage invokeMessage, ProtocolData protocolData) {
        this.responseReceived = true;
        this.callback.handle(message, invokeMessage, protocolData);
    }

    public synchronized void handle(Message message, FaultMessage faultMessage, ProtocolData protocolData) {
        if (!this.responseReceived && ++this.receivedFaultCount == this.supportedVersionsCount) {
            this.callback.handle(message, faultMessage, protocolData);
        }
    }

    public synchronized void handleTimeout(Message message) {
        this.responseReceived = true;
        this.callback.handleTimeout(message);
    }

    public synchronized void handleTransmissionException(Message message, Exception exception, ProtocolData protocolData) {
        this.responseReceived = true;
        this.callback.handleTransmissionException(message, exception, protocolData);
    }

    public synchronized void handleMalformedResponseException(Message message, Exception exception, ProtocolData protocolData) {
        this.responseReceived = true;
        this.callback.handleMalformedResponseException(message, exception, protocolData);
    }

    public OperationDescription getOperation() {
        return this.callback != null ? this.callback.getOperation() : null;
    }

    public void setTargetAddress(XAddressInfo xAddressInfo) {
        this.targetXAddressInfo = xAddressInfo;
    }

    public XAddressInfo getTargetAddress() {
        return this.targetXAddressInfo;
    }
}

