/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.communication;

import org.ws4d.java.communication.CommunicationBinding;
import org.ws4d.java.communication.connection.ip.IPAddress;
import org.ws4d.java.communication.connection.ip.IPNetworkDetection;
import org.ws4d.java.types.URI;
import org.ws4d.java.util.IDGenerator;
import org.ws4d.java.util.WS4DIllegalStateException;

public class HTTPBinding
implements CommunicationBinding {
    private final String path;
    private final int hashCode;
    private final boolean autoPort;
    public static final int HTTP_BINDING = 0;
    public static final int HTTPS_BINDING = 1;
    public static final int DISCOVERY_BINDING = 2;
    protected IPAddress ipAddress = null;
    protected int port = -1;
    protected URI transportAddress = null;

    public HTTPBinding(IPAddress iPAddress, int n, String string) {
        if (iPAddress == null) {
            throw new WS4DIllegalStateException("Cannot create IP binding without IP host address");
        }
        if (n < 0 || n > 65535) {
            throw new WS4DIllegalStateException("Cannot create IP binding with illegal port number");
        }
        this.ipAddress = iPAddress;
        this.port = n;
        boolean bl = this.autoPort = n == 0;
        if (string == null) {
            string = "/" + IDGenerator.getUUID();
        } else if (!string.startsWith("/")) {
            string = "/" + string;
        }
        int n2 = 31;
        int n3 = 1;
        n3 = n2 * n3 + iPAddress.hashCode();
        n3 = n2 * n3 + string.hashCode();
        this.path = string;
        this.hashCode = n3;
    }

    public HTTPBinding(String string, int n, String string2) {
        this(IPNetworkDetection.getInstance().getIPAddress(string), n, string2);
    }

    public String getPath() {
        return this.path;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        HTTPBinding hTTPBinding = (HTTPBinding)object;
        return this.getTransportAddress().equals(hTTPBinding.getTransportAddress()) && this.getType() == hTTPBinding.getType();
    }

    public void setPort(int n) {
        if (this.port == 0) {
            this.port = n;
            this.transportAddress = null;
        } else if (this.port != n) {
            throw new RuntimeException("Attempt to overwrite non-zero port.");
        }
    }

    public void resetAutoPort() {
        if (this.autoPort) {
            this.port = 0;
            this.transportAddress = null;
        }
    }

    public int getType() {
        return 0;
    }

    public URI getTransportAddress() {
        if (this.transportAddress == null) {
            this.transportAddress = new URI(this.getURISchema() + "://" + this.ipAddress.getAddressWithoutNicId() + ":" + this.port + this.path);
        }
        return this.transportAddress;
    }

    public String getURISchema() {
        return "http";
    }

    public String getCommunicationManagerId() {
        return "DPWS";
    }

    public IPAddress getHostAddress() {
        return this.ipAddress;
    }

    public int getPort() {
        return this.port;
    }

    public String toString() {
        return this.ipAddress + ":" + this.port;
    }
}

