/*
 * Decompiled with CFR 0.152.
 */
package org.ws4d.java.communication;

import org.ws4d.java.DPWSFramework;
import org.ws4d.java.communication.CommunicationManager;
import org.ws4d.java.communication.DPWS2006.DefaultDPWSCommunicatonUtil;
import org.ws4d.java.communication.IncomingMessageListener;
import org.ws4d.java.communication.IncomingSOAPReceiver;
import org.ws4d.java.communication.ProtocolData;
import org.ws4d.java.communication.connection.ip.IPAddress;
import org.ws4d.java.communication.monitor.MonitorStreamFactory;
import org.ws4d.java.communication.monitor.MonitoringContext;
import org.ws4d.java.communication.protocol.soap.generator.DefaultMessageDiscarder;
import org.ws4d.java.communication.protocol.soap.server.SOAPoverUDPServer;
import org.ws4d.java.dispatch.DeviceServiceRegistry;
import org.ws4d.java.dispatch.MessageInformer;
import org.ws4d.java.message.FaultMessage;
import org.ws4d.java.message.InvokeMessage;
import org.ws4d.java.message.Message;
import org.ws4d.java.message.SOAPException;
import org.ws4d.java.message.SOAPHeader;
import org.ws4d.java.message.discovery.ByeMessage;
import org.ws4d.java.message.discovery.HelloMessage;
import org.ws4d.java.message.discovery.ProbeMatchesMessage;
import org.ws4d.java.message.discovery.ProbeMessage;
import org.ws4d.java.message.discovery.ResolveMatchesMessage;
import org.ws4d.java.message.discovery.ResolveMessage;
import org.ws4d.java.message.eventing.GetStatusMessage;
import org.ws4d.java.message.eventing.GetStatusResponseMessage;
import org.ws4d.java.message.eventing.RenewMessage;
import org.ws4d.java.message.eventing.RenewResponseMessage;
import org.ws4d.java.message.eventing.SubscribeMessage;
import org.ws4d.java.message.eventing.SubscribeResponseMessage;
import org.ws4d.java.message.eventing.SubscriptionEndMessage;
import org.ws4d.java.message.eventing.UnsubscribeMessage;
import org.ws4d.java.message.eventing.UnsubscribeResponseMessage;
import org.ws4d.java.message.metadata.GetMessage;
import org.ws4d.java.message.metadata.GetMetadataMessage;
import org.ws4d.java.message.metadata.GetMetadataResponseMessage;
import org.ws4d.java.message.metadata.GetResponseMessage;
import org.ws4d.java.service.OperationDescription;
import org.ws4d.java.structures.HashSet;
import org.ws4d.java.structures.Iterator;
import org.ws4d.java.structures.MessageIdBuffer;
import org.ws4d.java.util.Log;

final class IncomingUDPReceiver
extends SOAPoverUDPServer.SOAPoverUDPDatagramHandler {
    private static final MessageInformer MESSAGE_INFORMER = MessageInformer.getInstance();
    private final DefaultMessageDiscarder discarder = new RelevanceMessageDiscarder();
    private final DefaultDPWSCommunicatonUtil util = DefaultDPWSCommunicatonUtil.getInstance();
    private final HashSet helloListeners = new HashSet();
    private final HashSet byeListeners = new HashSet();
    private final HashSet probeResolveListeners = new HashSet();

    IncomingUDPReceiver() {
    }

    public synchronized void receive(final HelloMessage helloMessage, final ProtocolData protocolData) {
        IncomingSOAPReceiver.markIncoming(helloMessage);
        if (!helloMessage.getHeader().isValidated()) {
            return;
        }
        if (!DeviceServiceRegistry.checkAndUpdateAppSequence(helloMessage.getEndpointReference(), helloMessage.getAppSequence())) {
            MonitorStreamFactory monitorStreamFactory;
            if (Log.isDebug()) {
                Log.debug("Discarding Hello message! Old AppSequence!", 2);
            }
            if ((monitorStreamFactory = DPWSFramework.getMonitorStreamFactory()) != null) {
                MonitoringContext monitoringContext = monitorStreamFactory.getMonitoringContextIn(protocolData);
                if (monitoringContext != null) {
                    monitorStreamFactory.discard(protocolData, monitoringContext, 5);
                } else {
                    Log.warn("Cannot get correct monitoring context for message generation.");
                }
            }
            return;
        }
        boolean bl = true;
        Iterator iterator = this.helloListeners.iterator();
        while (iterator.hasNext()) {
            final IncomingMessageListener incomingMessageListener = (IncomingMessageListener)iterator.next();
            final boolean bl2 = bl;
            if (bl) {
                bl = false;
            }
            Runnable runnable = new Runnable(){

                public void run() {
                    incomingMessageListener.handle(helloMessage, protocolData);
                    if (bl2) {
                        MESSAGE_INFORMER.forwardMessage(helloMessage, protocolData);
                    }
                }
            };
            DPWSFramework.getThreadPool().execute(runnable);
        }
    }

    public synchronized void receive(final ByeMessage byeMessage, final ProtocolData protocolData) {
        IncomingSOAPReceiver.markIncoming(byeMessage);
        if (!byeMessage.getHeader().isValidated()) {
            return;
        }
        if (!DeviceServiceRegistry.checkAndUpdateAppSequence(byeMessage.getEndpointReference(), byeMessage.getAppSequence())) {
            MonitorStreamFactory monitorStreamFactory;
            if (Log.isDebug()) {
                Log.debug("Discarding Hello message! Old AppSequence!", 2);
            }
            if ((monitorStreamFactory = DPWSFramework.getMonitorStreamFactory()) != null) {
                MonitoringContext monitoringContext = monitorStreamFactory.getMonitoringContextIn(protocolData);
                if (monitoringContext != null) {
                    monitorStreamFactory.discard(protocolData, monitoringContext, 5);
                } else {
                    Log.warn("Cannot get correct monitoring context for message generation.");
                }
            }
            return;
        }
        boolean bl = true;
        Iterator iterator = this.byeListeners.iterator();
        while (iterator.hasNext()) {
            final IncomingMessageListener incomingMessageListener = (IncomingMessageListener)iterator.next();
            final boolean bl2 = bl;
            if (bl) {
                bl = false;
            }
            Runnable runnable = new Runnable(){

                public void run() {
                    incomingMessageListener.handle(byeMessage, protocolData);
                    if (bl2) {
                        MESSAGE_INFORMER.forwardMessage(byeMessage, protocolData);
                    }
                }
            };
            DPWSFramework.getThreadPool().execute(runnable);
        }
    }

    public synchronized void receive(final ProbeMessage probeMessage, final ProtocolData protocolData) {
        final long l = System.currentTimeMillis();
        IncomingSOAPReceiver.markIncoming(probeMessage);
        boolean bl = true;
        Iterator iterator = this.probeResolveListeners.iterator();
        while (iterator.hasNext()) {
            final IncomingMessageListener incomingMessageListener = (IncomingMessageListener)iterator.next();
            final boolean bl2 = bl;
            if (bl) {
                bl = false;
            }
            Runnable runnable = new Runnable(){

                public void run() {
                    block6: {
                        ProtocolData protocolData2 = protocolData.createSwappedProtocolData();
                        try {
                            ProbeMatchesMessage probeMatchesMessage = incomingMessageListener.handle(probeMessage, protocolData);
                            if (bl2) {
                                MESSAGE_INFORMER.forwardMessage(probeMessage, protocolData);
                            }
                            if (probeMatchesMessage == null) break block6;
                            IncomingSOAPReceiver.markOutgoing(probeMatchesMessage);
                            IncomingUDPReceiver.this.util.changeOutgoingMessage(probeMatchesMessage.getProtocolInfo().getVersion(), (Message)probeMatchesMessage);
                            CommunicationManager communicationManager = DPWSFramework.getCommunicationManager(protocolData2.getCommunicationManagerId());
                            long l3 = l + communicationManager.getRandomApplicationDelay(probeMessage.getProtocolInfo().getVersion());
                            long l2 = l3 - System.currentTimeMillis();
                            if (l2 > 0L) {
                                try {
                                    Thread.sleep(l2);
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                            }
                            IncomingUDPReceiver.this.respond(probeMatchesMessage, new IPAddress(protocolData2.getDestinationHost()), protocolData2.getDestinationPort(), protocolData2);
                            MESSAGE_INFORMER.forwardMessage(probeMatchesMessage, protocolData2);
                        }
                        catch (SOAPException sOAPException) {
                            if (!bl2) break block6;
                            MESSAGE_INFORMER.forwardMessage(sOAPException.getFault(), protocolData2);
                        }
                    }
                }
            };
            DPWSFramework.getThreadPool().execute(runnable);
        }
    }

    public void receive(ProbeMatchesMessage probeMatchesMessage, ProtocolData protocolData) {
        this.receiveUnexpectedMessage(probeMatchesMessage, protocolData);
    }

    public synchronized void receive(final ResolveMessage resolveMessage, final ProtocolData protocolData) {
        IncomingSOAPReceiver.markIncoming(resolveMessage);
        boolean bl = true;
        Iterator iterator = this.probeResolveListeners.iterator();
        while (iterator.hasNext()) {
            final IncomingMessageListener incomingMessageListener = (IncomingMessageListener)iterator.next();
            final boolean bl2 = bl;
            if (bl) {
                bl = false;
            }
            Runnable runnable = new Runnable(){

                public void run() {
                    ResolveMatchesMessage resolveMatchesMessage = incomingMessageListener.handle(resolveMessage, protocolData);
                    if (bl2) {
                        MESSAGE_INFORMER.forwardMessage(resolveMessage, protocolData);
                    }
                    if (resolveMatchesMessage != null) {
                        IncomingSOAPReceiver.markOutgoing(resolveMatchesMessage);
                        IncomingUDPReceiver.this.util.changeOutgoingMessage(resolveMatchesMessage.getProtocolInfo().getVersion(), (Message)resolveMatchesMessage);
                        IncomingUDPReceiver.this.respond(resolveMatchesMessage, new IPAddress(protocolData.getDestinationHost()), protocolData.getDestinationPort(), protocolData);
                        MESSAGE_INFORMER.forwardMessage(resolveMatchesMessage, protocolData);
                    }
                }
            };
            DPWSFramework.getThreadPool().execute(runnable);
        }
    }

    public void receive(ResolveMatchesMessage resolveMatchesMessage, ProtocolData protocolData) {
        this.receiveUnexpectedMessage(resolveMatchesMessage, protocolData);
    }

    public void receive(GetMessage getMessage, ProtocolData protocolData) {
        this.receiveUnexpectedMessage(getMessage, protocolData);
    }

    public void receive(GetResponseMessage getResponseMessage, ProtocolData protocolData) {
        this.receiveUnexpectedMessage(getResponseMessage, protocolData);
    }

    public void receive(GetMetadataMessage getMetadataMessage, ProtocolData protocolData) {
        this.receiveUnexpectedMessage(getMetadataMessage, protocolData);
    }

    public void receive(GetMetadataResponseMessage getMetadataResponseMessage, ProtocolData protocolData) {
        this.receiveUnexpectedMessage(getMetadataResponseMessage, protocolData);
    }

    public void receive(SubscribeMessage subscribeMessage, ProtocolData protocolData) {
        this.receiveUnexpectedMessage(subscribeMessage, protocolData);
    }

    public void receive(SubscribeResponseMessage subscribeResponseMessage, ProtocolData protocolData) {
        this.receiveUnexpectedMessage(subscribeResponseMessage, protocolData);
    }

    public void receive(GetStatusMessage getStatusMessage, ProtocolData protocolData) {
        this.receiveUnexpectedMessage(getStatusMessage, protocolData);
    }

    public void receive(GetStatusResponseMessage getStatusResponseMessage, ProtocolData protocolData) {
        this.receiveUnexpectedMessage(getStatusResponseMessage, protocolData);
    }

    public void receive(RenewMessage renewMessage, ProtocolData protocolData) {
        this.receiveUnexpectedMessage(renewMessage, protocolData);
    }

    public void receive(RenewResponseMessage renewResponseMessage, ProtocolData protocolData) {
        this.receiveUnexpectedMessage(renewResponseMessage, protocolData);
    }

    public void receive(UnsubscribeMessage unsubscribeMessage, ProtocolData protocolData) {
        this.receiveUnexpectedMessage(unsubscribeMessage, protocolData);
    }

    public void receive(UnsubscribeResponseMessage unsubscribeResponseMessage, ProtocolData protocolData) {
        this.receiveUnexpectedMessage(unsubscribeResponseMessage, protocolData);
    }

    public void receive(SubscriptionEndMessage subscriptionEndMessage, ProtocolData protocolData) {
        this.receiveUnexpectedMessage(subscriptionEndMessage, protocolData);
    }

    public void receive(InvokeMessage invokeMessage, ProtocolData protocolData) {
        this.receiveUnexpectedMessage(invokeMessage, protocolData);
    }

    public void receive(FaultMessage faultMessage, ProtocolData protocolData) {
        this.receiveUnexpectedMessage(faultMessage, protocolData);
    }

    public void receiveFailed(Exception exception, ProtocolData protocolData) {
    }

    public void sendFailed(Exception exception, ProtocolData protocolData) {
    }

    protected DefaultMessageDiscarder getDiscarder() {
        return this.discarder;
    }

    synchronized void registerHelloListener(IncomingMessageListener incomingMessageListener) {
        this.helloListeners.add(incomingMessageListener);
    }

    synchronized void registerByeListener(IncomingMessageListener incomingMessageListener) {
        this.byeListeners.add(incomingMessageListener);
    }

    synchronized void registerProbeResolveListener(IncomingMessageListener incomingMessageListener) {
        this.probeResolveListeners.add(incomingMessageListener);
    }

    synchronized void unregisterHelloListener(IncomingMessageListener incomingMessageListener) {
        this.helloListeners.remove(incomingMessageListener);
    }

    synchronized void unregisterByeListener(IncomingMessageListener incomingMessageListener) {
        this.byeListeners.remove(incomingMessageListener);
    }

    synchronized void unregisterProbeResolveListener(IncomingMessageListener incomingMessageListener) {
        this.probeResolveListeners.remove(incomingMessageListener);
    }

    synchronized void register(int[] nArray, IncomingMessageListener incomingMessageListener) {
        block6: for (int i = 0; i < nArray.length; ++i) {
            switch (nArray[i]) {
                case 1: {
                    this.helloListeners.add(incomingMessageListener);
                    continue block6;
                }
                case 2: {
                    this.byeListeners.add(incomingMessageListener);
                    continue block6;
                }
                case 3: {
                    this.probeResolveListeners.add(incomingMessageListener);
                    continue block6;
                }
                case 5: {
                    this.probeResolveListeners.add(incomingMessageListener);
                }
            }
        }
    }

    synchronized void unregister(int[] nArray, IncomingMessageListener incomingMessageListener) {
        block6: for (int i = 0; i < nArray.length; ++i) {
            switch (nArray[i]) {
                case 1: {
                    this.helloListeners.remove(incomingMessageListener);
                    continue block6;
                }
                case 2: {
                    this.byeListeners.remove(incomingMessageListener);
                    continue block6;
                }
                case 3: {
                    this.probeResolveListeners.remove(incomingMessageListener);
                    continue block6;
                }
                case 5: {
                    this.probeResolveListeners.remove(incomingMessageListener);
                }
            }
        }
    }

    synchronized boolean isEmpty() {
        return this.helloListeners.isEmpty() && this.byeListeners.isEmpty() && this.probeResolveListeners.isEmpty();
    }

    synchronized void clear() {
        this.helloListeners.clear();
        this.byeListeners.clear();
        this.probeResolveListeners.clear();
    }

    private void receiveUnexpectedMessage(Message message, ProtocolData protocolData) {
        IncomingSOAPReceiver.markIncoming(message);
        String string = message.getAction().toString();
        Log.error("<I> Unexpected multicast SOAP-over-UDP message: " + string);
        if (Log.isDebug()) {
            Log.error(message.toString());
        }
        MESSAGE_INFORMER.forwardMessage(message, protocolData);
    }

    public OperationDescription getOperation(String string) {
        return null;
    }

    private class RelevanceMessageDiscarder
    extends DefaultMessageDiscarder {
        private final MessageIdBuffer duplicateMessageIds = new MessageIdBuffer();

        private RelevanceMessageDiscarder() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int discardMessage(SOAPHeader sOAPHeader, ProtocolData protocolData) {
            int n = super.discardMessage(sOAPHeader, protocolData);
            if (n != 0) {
                return n;
            }
            if (this.duplicateMessageIds.containsOrEnqueue(sOAPHeader.getMessageId())) {
                return 2;
            }
            IncomingUDPReceiver incomingUDPReceiver = IncomingUDPReceiver.this;
            synchronized (incomingUDPReceiver) {
                int n2 = sOAPHeader.getDPWSMessageType();
                switch (n2) {
                    case 1: {
                        if (!IncomingUDPReceiver.this.helloListeners.isEmpty()) break;
                        return 3;
                    }
                    case 2: {
                        if (!IncomingUDPReceiver.this.byeListeners.isEmpty()) break;
                        return 3;
                    }
                    case 3: {
                        if (!IncomingUDPReceiver.this.probeResolveListeners.isEmpty()) break;
                        return 3;
                    }
                    case 5: {
                        if (!IncomingUDPReceiver.this.probeResolveListeners.isEmpty()) break;
                        return 3;
                    }
                    default: {
                        return 3;
                    }
                }
            }
            return 0;
        }
    }
}

